/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonSubTypes;

/**
 * The resource from which the rule collects its data.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "odata.type")
@JsonTypeName("RuleDataSource")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource", value = RuleMetricDataSource.class),
    @JsonSubTypes.Type(name = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource", value = RuleManagementEventDataSource.class)
})
public class RuleDataSource {
    /**
     * the resource identifier of the resource the rule monitors. **NOTE**:
     * this property cannot be updated for an existing rule.
     */
    @JsonProperty(value = "resourceUri")
    private String resourceUri;

    /**
     * Get the resourceUri value.
     *
     * @return the resourceUri value
     */
    public String resourceUri() {
        return this.resourceUri;
    }

    /**
     * Set the resourceUri value.
     *
     * @param resourceUri the resourceUri value to set
     * @return the RuleDataSource object itself.
     */
    public RuleDataSource withResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

}
