/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.apigeneration.LangMethodDefinition;
import com.microsoft.azure.management.monitor.AggregationType;
import com.microsoft.azure.management.monitor.LocalizableString;
import com.microsoft.azure.management.monitor.MetricAvailability;
import com.microsoft.azure.management.monitor.MetricCollection;
import com.microsoft.azure.management.monitor.MetricDefinition;
import com.microsoft.azure.management.monitor.ResultType;
import com.microsoft.azure.management.monitor.Unit;
import com.microsoft.azure.management.monitor.implementation.LocalizableStringImpl;
import com.microsoft.azure.management.monitor.implementation.MetricCollectionImpl;
import com.microsoft.azure.management.monitor.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.monitor.implementation.ResponseInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.format.ISODateTimeFormat;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Monitor.Fluent.Models")
class MetricDefinitionImpl
extends WrapperImpl<MetricDefinitionInner>
implements MetricDefinition,
MetricDefinition.MetricsQueryDefinition {
    private final MonitorManager myManager;
    private MetricDefinitionInner inner;
    private LocalizableString name;
    private DateTime queryStartTime;
    private DateTime queryEndTime;
    private String aggreagation;
    private Period interval;
    private String odataFilter;
    private ResultType resultType;
    private Double top;
    private String orderBy;

    MetricDefinitionImpl(MetricDefinitionInner innerModel, MonitorManager monitorManager) {
        super((Object)innerModel);
        this.myManager = monitorManager;
        this.inner = innerModel;
        this.name = this.inner.name() == null ? null : new LocalizableStringImpl(this.inner.name());
    }

    public MonitorManager manager() {
        return this.myManager;
    }

    @Override
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String resourceId() {
        return this.inner.resourceId();
    }

    @Override
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public LocalizableString name() {
        return this.name;
    }

    @Override
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public Unit unit() {
        return this.inner.unit();
    }

    @Override
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public AggregationType primaryAggregationType() {
        return this.inner.primaryAggregationType();
    }

    @Override
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public List<MetricAvailability> metricAvailabilities() {
        return this.inner.metricAvailabilities();
    }

    @Override
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String id() {
        return this.inner.id();
    }

    @Override
    public MetricDefinitionImpl defineQuery() {
        this.aggreagation = null;
        this.interval = null;
        this.resultType = null;
        this.top = null;
        this.orderBy = null;
        return this;
    }

    @Override
    public MetricDefinitionImpl startingFrom(DateTime startTime) {
        this.queryStartTime = startTime;
        return this;
    }

    @Override
    public MetricDefinitionImpl endsBefore(DateTime endTime) {
        this.queryEndTime = endTime;
        return this;
    }

    @Override
    public MetricDefinitionImpl withAggregation(String aggregation) {
        this.aggreagation = aggregation;
        return this;
    }

    @Override
    public MetricDefinitionImpl withInterval(Period interval) {
        this.interval = interval;
        return this;
    }

    @Override
    public MetricDefinitionImpl withOdataFilter(String odataFilter) {
        this.odataFilter = odataFilter;
        return this;
    }

    @Override
    public MetricDefinitionImpl withResultType(ResultType resultType) {
        this.resultType = resultType;
        return this;
    }

    @Override
    public MetricDefinitionImpl selectTop(double top) {
        this.top = top;
        return this;
    }

    @Override
    public MetricDefinitionImpl orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @Override
    public MetricCollection execute() {
        return (MetricCollection)this.executeAsync().toBlocking().last();
    }

    @Override
    public Observable<MetricCollection> executeAsync() {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).metrics().listAsync(this.inner.resourceId(), String.format("%s/%s", this.queryStartTime.withZone(DateTimeZone.UTC).toString(ISODateTimeFormat.dateTime()), this.queryEndTime.withZone(DateTimeZone.UTC).toString(ISODateTimeFormat.dateTime())), this.interval, this.inner.name().value(), this.aggreagation, this.top, this.orderBy, this.odataFilter, this.resultType).map((Func1)new Func1<ResponseInner, MetricCollection>(){

            public MetricCollection call(ResponseInner responseInner) {
                return new MetricCollectionImpl(responseInner);
            }
        });
    }
}

