/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.LogProfileResourceInner;
import com.microsoft.azure.management.monitor.implementation.LogProfileResourcePatchInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class LogProfilesInner {
    private LogProfilesService service;
    private MonitorManagementClientImpl client;

    public LogProfilesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (LogProfilesService)retrofit.create(LogProfilesService.class);
        this.client = client;
    }

    public void delete(String logProfileName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(logProfileName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String logProfileName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(logProfileName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String logProfileName) {
        return this.deleteWithServiceResponseAsync(logProfileName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String logProfileName) {
        if (logProfileName == null) {
            throw new IllegalArgumentException("Parameter logProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.delete(logProfileName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogProfilesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LogProfileResourceInner get(String logProfileName) {
        return (LogProfileResourceInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(logProfileName).toBlocking().single()).body());
    }

    public ServiceFuture<LogProfileResourceInner> getAsync(String logProfileName, ServiceCallback<LogProfileResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(logProfileName), serviceCallback);
    }

    public Observable<LogProfileResourceInner> getAsync(String logProfileName) {
        return this.getWithServiceResponseAsync(logProfileName).map((Func1)new Func1<ServiceResponse<LogProfileResourceInner>, LogProfileResourceInner>(){

            public LogProfileResourceInner call(ServiceResponse<LogProfileResourceInner> response) {
                return (LogProfileResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LogProfileResourceInner>> getWithServiceResponseAsync(String logProfileName) {
        if (logProfileName == null) {
            throw new IllegalArgumentException("Parameter logProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.get(logProfileName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogProfileResourceInner>>>(){

            public Observable<ServiceResponse<LogProfileResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogProfilesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogProfileResourceInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogProfileResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public LogProfileResourceInner createOrUpdate(String logProfileName, LogProfileResourceInner parameters) {
        return (LogProfileResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(logProfileName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<LogProfileResourceInner> createOrUpdateAsync(String logProfileName, LogProfileResourceInner parameters, ServiceCallback<LogProfileResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(logProfileName, parameters), serviceCallback);
    }

    public Observable<LogProfileResourceInner> createOrUpdateAsync(String logProfileName, LogProfileResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(logProfileName, parameters).map((Func1)new Func1<ServiceResponse<LogProfileResourceInner>, LogProfileResourceInner>(){

            public LogProfileResourceInner call(ServiceResponse<LogProfileResourceInner> response) {
                return (LogProfileResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LogProfileResourceInner>> createOrUpdateWithServiceResponseAsync(String logProfileName, LogProfileResourceInner parameters) {
        if (logProfileName == null) {
            throw new IllegalArgumentException("Parameter logProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-03-01";
        return this.service.createOrUpdate(logProfileName, this.client.subscriptionId(), "2016-03-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogProfileResourceInner>>>(){

            public Observable<ServiceResponse<LogProfileResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogProfilesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogProfileResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogProfileResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LogProfileResourceInner update(String logProfileName, LogProfileResourcePatchInner logProfilesResource) {
        return (LogProfileResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(logProfileName, logProfilesResource).toBlocking().single()).body());
    }

    public ServiceFuture<LogProfileResourceInner> updateAsync(String logProfileName, LogProfileResourcePatchInner logProfilesResource, ServiceCallback<LogProfileResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(logProfileName, logProfilesResource), serviceCallback);
    }

    public Observable<LogProfileResourceInner> updateAsync(String logProfileName, LogProfileResourcePatchInner logProfilesResource) {
        return this.updateWithServiceResponseAsync(logProfileName, logProfilesResource).map((Func1)new Func1<ServiceResponse<LogProfileResourceInner>, LogProfileResourceInner>(){

            public LogProfileResourceInner call(ServiceResponse<LogProfileResourceInner> response) {
                return (LogProfileResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LogProfileResourceInner>> updateWithServiceResponseAsync(String logProfileName, LogProfileResourcePatchInner logProfilesResource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (logProfileName == null) {
            throw new IllegalArgumentException("Parameter logProfileName is required and cannot be null.");
        }
        if (logProfilesResource == null) {
            throw new IllegalArgumentException("Parameter logProfilesResource is required and cannot be null.");
        }
        Validator.validate((Object)logProfilesResource);
        String apiVersion = "2016-03-01";
        return this.service.update(this.client.subscriptionId(), logProfileName, "2016-03-01", logProfilesResource, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogProfileResourceInner>>>(){

            public Observable<ServiceResponse<LogProfileResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogProfilesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogProfileResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogProfileResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<LogProfileResourceInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<LogProfileResourceInner>(page){

            public Page<LogProfileResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<LogProfileResourceInner>> listAsync(ServiceCallback<List<LogProfileResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<LogProfileResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<LogProfileResourceInner>>, Page<LogProfileResourceInner>>(){

            public Page<LogProfileResourceInner> call(ServiceResponse<List<LogProfileResourceInner>> response) {
                PageImpl1<LogProfileResourceInner> page = new PageImpl1<LogProfileResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<LogProfileResourceInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.list(this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogProfileResourceInner>>>>(){

            public Observable<ServiceResponse<List<LogProfileResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LogProfilesInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<LogProfileResourceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<LogProfileResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LogProfilesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.LogProfiles delete"})
        @HTTP(path="subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="logProfileName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.LogProfiles get"})
        @GET(value="subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}")
        public Observable<Response<ResponseBody>> get(@Path(value="logProfileName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.LogProfiles createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="logProfileName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Body LogProfileResourceInner var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.LogProfiles update"})
        @PATCH(value="subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="logProfileName") String var2, @Query(value="api-version") String var3, @Body LogProfileResourcePatchInner var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.LogProfiles list"})
        @GET(value="subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

