/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.msi.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in UserAssignedIdentities.
 */
public class UserAssignedIdentitiesInner implements InnerSupportsGet<IdentityInner>, InnerSupportsDelete<IdentityInner>, InnerSupportsListing<IdentityInner> {
    /** The Retrofit service to perform REST calls. */
    private UserAssignedIdentitiesService service;
    /** The service client containing this operation class. */
    private ManagedServiceIdentityClientImpl client;

    /**
     * Initializes an instance of UserAssignedIdentitiesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public UserAssignedIdentitiesInner(Retrofit retrofit, ManagedServiceIdentityClientImpl client) {
        this.service = retrofit.create(UserAssignedIdentitiesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for UserAssignedIdentities to be
     * used by Retrofit to perform actually REST calls.
     */
    interface UserAssignedIdentitiesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.ManagedIdentity/userAssignedIdentities")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Body IdentityInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Body IdentityInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.msi.UserAssignedIdentities listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentityInner&gt; object if successful.
     */
    public PagedList<IdentityInner> list() {
        ServiceResponse<Page<IdentityInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<IdentityInner>(response.body()) {
            @Override
            public Page<IdentityInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentityInner>> listAsync(final ListOperationCallback<IdentityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<Page<IdentityInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<IdentityInner>>, Page<IdentityInner>>() {
                @Override
                public Page<IdentityInner> call(ServiceResponse<Page<IdentityInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<IdentityInner>>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(ServiceResponse<Page<IdentityInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentityInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentityInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentityInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IdentityInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IdentityInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IdentityInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentityInner&gt; object if successful.
     */
    public PagedList<IdentityInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<IdentityInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<IdentityInner>(response.body()) {
            @Override
            public Page<IdentityInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentityInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<IdentityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<Page<IdentityInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<IdentityInner>>, Page<IdentityInner>>() {
                @Override
                public Page<IdentityInner> call(ServiceResponse<Page<IdentityInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<IdentityInner>>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(ServiceResponse<Page<IdentityInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
    ServiceResponse<PageImpl<IdentityInner>> * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentityInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentityInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentityInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IdentityInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IdentityInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IdentityInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to create or update the identity
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IdentityInner object if successful.
     */
    public IdentityInner createOrUpdate(String resourceGroupName, String resourceName, IdentityInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single().body();
    }

    /**
     * Create or update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to create or update the identity
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IdentityInner> createOrUpdateAsync(String resourceGroupName, String resourceName, IdentityInner parameters, final ServiceCallback<IdentityInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    /**
     * Create or update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to create or update the identity
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<IdentityInner> createOrUpdateAsync(String resourceGroupName, String resourceName, IdentityInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map(new Func1<ServiceResponse<IdentityInner>, IdentityInner>() {
            @Override
            public IdentityInner call(ServiceResponse<IdentityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to create or update the identity
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<ServiceResponse<IdentityInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, IdentityInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IdentityInner>>>() {
                @Override
                public Observable<ServiceResponse<IdentityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IdentityInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IdentityInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IdentityInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IdentityInner>() { }.getType())
                .register(201, new TypeToken<IdentityInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to update the identity
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IdentityInner object if successful.
     */
    public IdentityInner update(String resourceGroupName, String resourceName, IdentityInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single().body();
    }

    /**
     * Update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to update the identity
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IdentityInner> updateAsync(String resourceGroupName, String resourceName, IdentityInner parameters, final ServiceCallback<IdentityInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    /**
     * Update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to update the identity
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<IdentityInner> updateAsync(String resourceGroupName, String resourceName, IdentityInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map(new Func1<ServiceResponse<IdentityInner>, IdentityInner>() {
            @Override
            public IdentityInner call(ServiceResponse<IdentityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an identity in the specified subscription and resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param parameters Parameters to update the identity
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<ServiceResponse<IdentityInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceName, IdentityInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.update(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IdentityInner>>>() {
                @Override
                public Observable<ServiceResponse<IdentityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IdentityInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IdentityInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IdentityInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IdentityInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IdentityInner object if successful.
     */
    public IdentityInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single().body();
    }

    /**
     * Gets the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IdentityInner> getByResourceGroupAsync(String resourceGroupName, String resourceName, final ServiceCallback<IdentityInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    /**
     * Gets the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<IdentityInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).map(new Func1<ServiceResponse<IdentityInner>, IdentityInner>() {
            @Override
            public IdentityInner call(ServiceResponse<IdentityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<ServiceResponse<IdentityInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IdentityInner>>>() {
                @Override
                public Observable<ServiceResponse<IdentityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IdentityInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IdentityInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IdentityInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IdentityInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IdentityInner object if successful.
     */
    public IdentityInner delete(String resourceGroupName, String resourceName) {
        return deleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single().body();
    }

    /**
     * Deletes the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IdentityInner> deleteAsync(String resourceGroupName, String resourceName, final ServiceCallback<IdentityInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    /**
     * Deletes the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<IdentityInner> deleteAsync(String resourceGroupName, String resourceName) {
        return deleteWithServiceResponseAsync(resourceGroupName, resourceName).map(new Func1<ServiceResponse<IdentityInner>, IdentityInner>() {
            @Override
            public IdentityInner call(ServiceResponse<IdentityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the identity.
     *
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentityInner object
     */
    public Observable<ServiceResponse<IdentityInner>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IdentityInner>>>() {
                @Override
                public Observable<ServiceResponse<IdentityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IdentityInner> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IdentityInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IdentityInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IdentityInner>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentityInner&gt; object if successful.
     */
    public PagedList<IdentityInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<IdentityInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IdentityInner>(response.body()) {
            @Override
            public Page<IdentityInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentityInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<IdentityInner>> serviceFuture, final ListOperationCallback<IdentityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<Page<IdentityInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<IdentityInner>>, Page<IdentityInner>>() {
                @Override
                public Page<IdentityInner> call(ServiceResponse<Page<IdentityInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<IdentityInner>>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(ServiceResponse<Page<IdentityInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified subscription.
     *
    ServiceResponse<PageImpl<IdentityInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentityInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentityInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentityInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IdentityInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IdentityInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IdentityInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentityInner&gt; object if successful.
     */
    public PagedList<IdentityInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<IdentityInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IdentityInner>(response.body()) {
            @Override
            public Page<IdentityInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentityInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<IdentityInner>> serviceFuture, final ListOperationCallback<IdentityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<Page<IdentityInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<IdentityInner>>, Page<IdentityInner>>() {
                @Override
                public Page<IdentityInner> call(ServiceResponse<Page<IdentityInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentityInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<IdentityInner>>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(ServiceResponse<Page<IdentityInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the userAssignedIdentities available under the specified ResourceGroup.
     *
    ServiceResponse<PageImpl<IdentityInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentityInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentityInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentityInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentityInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentityInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IdentityInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IdentityInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IdentityInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
