/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.msi.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.msi.implementation.IdentityInner;
import com.microsoft.azure.management.msi.implementation.MSIManager;
import com.microsoft.azure.management.msi.implementation.ManagedServiceIdentityClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
final class IdentityImpl
extends GroupableResourceImpl<Identity, IdentityInner, IdentityImpl, MSIManager>
implements Identity,
Identity.Definition,
Identity.Update {
    private RoleAssignmentHelper roleAssignmentHelper;

    protected IdentityImpl(String name, IdentityInner innerObject, MSIManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        this.roleAssignmentHelper = new RoleAssignmentHelper(manager.graphRbacManager(), this.taskGroup(), this.idProvider());
    }

    @Override
    public String tenantId() {
        if (((IdentityInner)((Object)this.inner())).tenantId() == null) {
            return null;
        }
        return ((IdentityInner)((Object)this.inner())).tenantId().toString();
    }

    @Override
    public String principalId() {
        if (((IdentityInner)((Object)this.inner())).principalId() == null) {
            return null;
        }
        return ((IdentityInner)((Object)this.inner())).principalId().toString();
    }

    @Override
    public String clientId() {
        if (((IdentityInner)((Object)this.inner())).clientId() == null) {
            return null;
        }
        return ((IdentityInner)((Object)this.inner())).clientId().toString();
    }

    @Override
    public String clientSecretUrl() {
        return ((IdentityInner)((Object)this.inner())).clientSecretUrl();
    }

    @Override
    public IdentityImpl withAccessTo(com.microsoft.azure.management.resources.fluentcore.arm.models.Resource resource, BuiltInRole role) {
        this.roleAssignmentHelper.withAccessTo(resource.id(), role);
        return this;
    }

    @Override
    public IdentityImpl withAccessTo(String resourceId, BuiltInRole role) {
        this.roleAssignmentHelper.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public IdentityImpl withAccessToCurrentResourceGroup(BuiltInRole role) {
        this.roleAssignmentHelper.withAccessToCurrentResourceGroup(role);
        return this;
    }

    @Override
    public IdentityImpl withAccessTo(com.microsoft.azure.management.resources.fluentcore.arm.models.Resource resource, String roleDefinitionId) {
        this.roleAssignmentHelper.withAccessTo(resource.id(), roleDefinitionId);
        return this;
    }

    @Override
    public IdentityImpl withAccessTo(String resourceId, String roleDefinitionId) {
        this.roleAssignmentHelper.withAccessTo(resourceId, roleDefinitionId);
        return this;
    }

    @Override
    public IdentityImpl withAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.roleAssignmentHelper.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public IdentityImpl withoutAccess(RoleAssignment access) {
        this.roleAssignmentHelper.withoutAccessTo(access);
        return this;
    }

    @Override
    public IdentityImpl withoutAccessTo(String resourceId, BuiltInRole role) {
        this.roleAssignmentHelper.withoutAccessTo(resourceId, role);
        return this;
    }

    public Observable<Identity> createResourceAsync() {
        return ((ManagedServiceIdentityClientImpl)((Object)((MSIManager)this.manager()).inner())).userAssignedIdentities().createOrUpdateAsync(this.resourceGroupName(), this.name(), (IdentityInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap((Func1)new Func1<Identity, Observable<Identity>>(){

            public Observable<Identity> call(Identity identity) {
                return Observable.just((Object)identity).delay(30L, TimeUnit.SECONDS, SdkContext.getRxScheduler());
            }
        });
    }

    protected Observable<IdentityInner> getInnerAsync() {
        return ((ManagedServiceIdentityClientImpl)((Object)((MSIManager)this.myManager).inner())).userAssignedIdentities().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                Objects.requireNonNull(IdentityImpl.this.inner());
                Objects.requireNonNull(((IdentityInner)((Object)IdentityImpl.this.inner())).principalId());
                return ((IdentityInner)((Object)IdentityImpl.this.inner())).principalId().toString();
            }

            public String resourceId() {
                Objects.requireNonNull(IdentityImpl.this.inner());
                Objects.requireNonNull(((IdentityInner)((Object)IdentityImpl.this.inner())).id());
                return ((IdentityInner)((Object)IdentityImpl.this.inner())).id();
            }
        };
    }
}

