/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.microsoft.azure.SubResource;

/**
 * Effective NetworkSecurityGroup association.
 */
public class EffectiveNetworkSecurityGroupAssociation {
    /**
     * Gets the id of subnet if assigned.
     */
    private SubResource subnet;

    /**
     * Gets the id of network interface if assigned.
     */
    private SubResource networkInterface;

    /**
     * Get the subnet value.
     *
     * @return the subnet value
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet value.
     *
     * @param subnet the subnet value to set
     * @return the EffectiveNetworkSecurityGroupAssociation object itself.
     */
    public EffectiveNetworkSecurityGroupAssociation withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the networkInterface value.
     *
     * @return the networkInterface value
     */
    public SubResource networkInterface() {
        return this.networkInterface;
    }

    /**
     * Set the networkInterface value.
     *
     * @param networkInterface the networkInterface value to set
     * @return the EffectiveNetworkSecurityGroupAssociation object itself.
     */
    public EffectiveNetworkSecurityGroupAssociation withNetworkInterface(SubResource networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

}
