/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in RouteTables.
 */
public final class RouteTablesInner {
    /** The Retrofit service to perform REST calls. */
    private RouteTablesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of RouteTablesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RouteTablesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(RouteTablesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for RouteTables to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RouteTablesService {
        @Headers("Content-Type: application/json; charset=utf-8")
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("routeTableName") String routeTableName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("routeTableName") String routeTableName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("routeTableName") String routeTableName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("routeTableName") String routeTableName, @Path("subscriptionId") String subscriptionId, @Body RouteTableInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("routeTableName") String routeTableName, @Path("subscriptionId") String subscriptionId, @Body RouteTableInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/routeTables")
        Observable<Response<ResponseBody>> listAll(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{nextLink}")
        Observable<Response<ResponseBody>> listNext(@Path(value = "nextLink", encoded = true) String nextPageLink, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{nextLink}")
        Observable<Response<ResponseBody>> listAllNext(@Path(value = "nextLink", encoded = true) String nextPageLink, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     */
    public void delete(String resourceGroupName, String routeTableName) {
        deleteWithServiceResponseAsync(resourceGroupName, routeTableName).toBlocking().last().getBody();
    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> deleteAsync(String resourceGroupName, String routeTableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(deleteWithServiceResponseAsync(resourceGroupName, routeTableName), serviceCallback);
    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String routeTableName) {
        return deleteWithServiceResponseAsync(resourceGroupName, routeTableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String routeTableName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, routeTableName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     */
    public void beginDelete(String resourceGroupName, String routeTableName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, routeTableName).toBlocking().single().getBody();
    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> beginDeleteAsync(String resourceGroupName, String routeTableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(beginDeleteWithServiceResponseAsync(resourceGroupName, routeTableName), serviceCallback);
    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String routeTableName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, routeTableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * The Delete RouteTable operation deletes the specified Route Table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String routeTableName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, routeTableName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, CloudException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .build(response);
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @return the RouteTableInner object if successful.
     */
    public RouteTableInner get(String resourceGroupName, String routeTableName) {
        return getWithServiceResponseAsync(resourceGroupName, routeTableName).toBlocking().single().getBody();
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<RouteTableInner> getAsync(String resourceGroupName, String routeTableName, final ServiceCallback<RouteTableInner> serviceCallback) {
        return ServiceCall.create(getWithServiceResponseAsync(resourceGroupName, routeTableName), serviceCallback);
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @return the observable to the RouteTableInner object
     */
    public Observable<RouteTableInner> getAsync(String resourceGroupName, String routeTableName) {
        return getWithServiceResponseAsync(resourceGroupName, routeTableName).map(new Func1<ServiceResponse<RouteTableInner>, RouteTableInner>() {
            @Override
            public RouteTableInner call(ServiceResponse<RouteTableInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @return the observable to the RouteTableInner object
     */
    public Observable<ServiceResponse<RouteTableInner>> getWithServiceResponseAsync(String resourceGroupName, String routeTableName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String expand = null;
        return service.get(resourceGroupName, routeTableName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteTableInner>>>() {
                @Override
                public Observable<ServiceResponse<RouteTableInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RouteTableInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param expand expand references resources.
     * @return the RouteTableInner object if successful.
     */
    public RouteTableInner get(String resourceGroupName, String routeTableName, String expand) {
        return getWithServiceResponseAsync(resourceGroupName, routeTableName, expand).toBlocking().single().getBody();
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param expand expand references resources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<RouteTableInner> getAsync(String resourceGroupName, String routeTableName, String expand, final ServiceCallback<RouteTableInner> serviceCallback) {
        return ServiceCall.create(getWithServiceResponseAsync(resourceGroupName, routeTableName, expand), serviceCallback);
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param expand expand references resources.
     * @return the observable to the RouteTableInner object
     */
    public Observable<RouteTableInner> getAsync(String resourceGroupName, String routeTableName, String expand) {
        return getWithServiceResponseAsync(resourceGroupName, routeTableName, expand).map(new Func1<ServiceResponse<RouteTableInner>, RouteTableInner>() {
            @Override
            public RouteTableInner call(ServiceResponse<RouteTableInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * The Get RouteTables operation retrieves information about the specified route table.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param expand expand references resources.
     * @return the observable to the RouteTableInner object
     */
    public Observable<ServiceResponse<RouteTableInner>> getWithServiceResponseAsync(String resourceGroupName, String routeTableName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, routeTableName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteTableInner>>>() {
                @Override
                public Observable<ServiceResponse<RouteTableInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RouteTableInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RouteTableInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<RouteTableInner, CloudException>(this.client.mapperAdapter())
                .register(200, new TypeToken<RouteTableInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @return the RouteTableInner object if successful.
     */
    public RouteTableInner createOrUpdate(String resourceGroupName, String routeTableName, RouteTableInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, routeTableName, parameters).toBlocking().last().getBody();
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<RouteTableInner> createOrUpdateAsync(String resourceGroupName, String routeTableName, RouteTableInner parameters, final ServiceCallback<RouteTableInner> serviceCallback) {
        return ServiceCall.create(createOrUpdateWithServiceResponseAsync(resourceGroupName, routeTableName, parameters), serviceCallback);
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @return the observable for the request
     */
    public Observable<RouteTableInner> createOrUpdateAsync(String resourceGroupName, String routeTableName, RouteTableInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, routeTableName, parameters).map(new Func1<ServiceResponse<RouteTableInner>, RouteTableInner>() {
            @Override
            public RouteTableInner call(ServiceResponse<RouteTableInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RouteTableInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String routeTableName, RouteTableInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, routeTableName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteTableInner>() { }.getType());
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @return the RouteTableInner object if successful.
     */
    public RouteTableInner beginCreateOrUpdate(String resourceGroupName, String routeTableName, RouteTableInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeTableName, parameters).toBlocking().single().getBody();
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<RouteTableInner> beginCreateOrUpdateAsync(String resourceGroupName, String routeTableName, RouteTableInner parameters, final ServiceCallback<RouteTableInner> serviceCallback) {
        return ServiceCall.create(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeTableName, parameters), serviceCallback);
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @return the observable to the RouteTableInner object
     */
    public Observable<RouteTableInner> beginCreateOrUpdateAsync(String resourceGroupName, String routeTableName, RouteTableInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeTableName, parameters).map(new Func1<ServiceResponse<RouteTableInner>, RouteTableInner>() {
            @Override
            public RouteTableInner call(ServiceResponse<RouteTableInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * The Put RouteTable operation creates/updates a route table in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param routeTableName The name of the route table.
     * @param parameters Parameters supplied to the create/update Route Table operation
     * @return the observable to the RouteTableInner object
     */
    public Observable<ServiceResponse<RouteTableInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String routeTableName, RouteTableInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdate(resourceGroupName, routeTableName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteTableInner>>>() {
                @Override
                public Observable<ServiceResponse<RouteTableInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RouteTableInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RouteTableInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<RouteTableInner, CloudException>(this.client.mapperAdapter())
                .register(200, new TypeToken<RouteTableInner>() { }.getType())
                .register(201, new TypeToken<RouteTableInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the PagedList&lt;RouteTableInner&gt; object if successful.
     */
    public PagedList<RouteTableInner> list(final String resourceGroupName) {
        ServiceResponse<Page<RouteTableInner>> response = listSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RouteTableInner>(response.getBody()) {
            @Override
            public Page<RouteTableInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().getBody();
            }
        };
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<RouteTableInner>> listAsync(final String resourceGroupName, final ListOperationCallback<RouteTableInner> serviceCallback) {
        return AzureServiceCall.create(
            listSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<Page<RouteTableInner>> listAsync(final String resourceGroupName) {
        return listWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<RouteTableInner>>, Page<RouteTableInner>>() {
                @Override
                public Page<RouteTableInner> call(ServiceResponse<Page<RouteTableInner>> response) {
                    return response.getBody();
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listWithServiceResponseAsync(final String resourceGroupName) {
        return listSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<RouteTableInner>>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(ServiceResponse<Page<RouteTableInner>> page) {
                    String nextPageLink = page.getBody().getNextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
    ServiceResponse<PageImpl<RouteTableInner>> * @param resourceGroupName The name of the resource group.
     * @return the PagedList&lt;RouteTableInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RouteTableInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RouteTableInner>>(result.getBody(), result.getResponse()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RouteTableInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<RouteTableInner>, CloudException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<RouteTableInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @return the PagedList&lt;RouteTableInner&gt; object if successful.
     */
    public PagedList<RouteTableInner> listAll() {
        ServiceResponse<Page<RouteTableInner>> response = listAllSinglePageAsync().toBlocking().single();
        return new PagedList<RouteTableInner>(response.getBody()) {
            @Override
            public Page<RouteTableInner> nextPage(String nextPageLink) {
                return listAllNextSinglePageAsync(nextPageLink).toBlocking().single().getBody();
            }
        };
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<RouteTableInner>> listAllAsync(final ListOperationCallback<RouteTableInner> serviceCallback) {
        return AzureServiceCall.create(
            listAllSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(String nextPageLink) {
                    return listAllNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<Page<RouteTableInner>> listAllAsync() {
        return listAllWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<RouteTableInner>>, Page<RouteTableInner>>() {
                @Override
                public Page<RouteTableInner> call(ServiceResponse<Page<RouteTableInner>> response) {
                    return response.getBody();
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listAllWithServiceResponseAsync() {
        return listAllSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<RouteTableInner>>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(ServiceResponse<Page<RouteTableInner>> page) {
                    String nextPageLink = page.getBody().getNextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAllNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @return the PagedList&lt;RouteTableInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listAllSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAll(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RouteTableInner>> result = listAllDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RouteTableInner>>(result.getBody(), result.getResponse()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RouteTableInner>> listAllDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<RouteTableInner>, CloudException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<RouteTableInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the PagedList&lt;RouteTableInner&gt; object if successful.
     */
    public PagedList<RouteTableInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<RouteTableInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RouteTableInner>(response.getBody()) {
            @Override
            public Page<RouteTableInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().getBody();
            }
        };
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<RouteTableInner>> listNextAsync(final String nextPageLink, final ServiceCall<List<RouteTableInner>> serviceCall, final ListOperationCallback<RouteTableInner> serviceCallback) {
        return AzureServiceCall.create(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<Page<RouteTableInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RouteTableInner>>, Page<RouteTableInner>>() {
                @Override
                public Page<RouteTableInner> call(ServiceResponse<Page<RouteTableInner>> response) {
                    return response.getBody();
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RouteTableInner>>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(ServiceResponse<Page<RouteTableInner>> page) {
                    String nextPageLink = page.getBody().getNextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a resource group.
     *
    ServiceResponse<PageImpl<RouteTableInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the PagedList&lt;RouteTableInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RouteTableInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RouteTableInner>>(result.getBody(), result.getResponse()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RouteTableInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<RouteTableInner>, CloudException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<RouteTableInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the PagedList&lt;RouteTableInner&gt; object if successful.
     */
    public PagedList<RouteTableInner> listAllNext(final String nextPageLink) {
        ServiceResponse<Page<RouteTableInner>> response = listAllNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RouteTableInner>(response.getBody()) {
            @Override
            public Page<RouteTableInner> nextPage(String nextPageLink) {
                return listAllNextSinglePageAsync(nextPageLink).toBlocking().single().getBody();
            }
        };
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<RouteTableInner>> listAllNextAsync(final String nextPageLink, final ServiceCall<List<RouteTableInner>> serviceCall, final ListOperationCallback<RouteTableInner> serviceCallback) {
        return AzureServiceCall.create(
            listAllNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(String nextPageLink) {
                    return listAllNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<Page<RouteTableInner>> listAllNextAsync(final String nextPageLink) {
        return listAllNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RouteTableInner>>, Page<RouteTableInner>>() {
                @Override
                public Page<RouteTableInner> call(ServiceResponse<Page<RouteTableInner>> response) {
                    return response.getBody();
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the observable to the PagedList&lt;RouteTableInner&gt; object
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listAllNextWithServiceResponseAsync(final String nextPageLink) {
        return listAllNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RouteTableInner>>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(ServiceResponse<Page<RouteTableInner>> page) {
                    String nextPageLink = page.getBody().getNextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAllNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The list RouteTables returns all route tables in a subscription.
     *
    ServiceResponse<PageImpl<RouteTableInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @return the PagedList&lt;RouteTableInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RouteTableInner>>> listAllNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return service.listAllNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteTableInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RouteTableInner>> result = listAllNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RouteTableInner>>(result.getBody(), result.getResponse()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RouteTableInner>> listAllNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<RouteTableInner>, CloudException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<RouteTableInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
