/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.Frontend;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.InboundNatPool;
import com.microsoft.azure.management.network.InboundNatRule;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PrivateFrontend;
import com.microsoft.azure.management.network.PublicFrontend;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.implementation.FrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@LangDefinition
class FrontendImpl
extends ChildResourceImpl<FrontendIPConfigurationInner, LoadBalancerImpl, LoadBalancer>
implements Frontend,
PrivateFrontend,
PrivateFrontend.Definition<LoadBalancer.DefinitionStages.WithPrivateFrontendOrBackend>,
PrivateFrontend.UpdateDefinition<LoadBalancer.Update>,
PrivateFrontend.Update,
PublicFrontend,
PublicFrontend.Definition<LoadBalancer.DefinitionStages.WithPublicFrontendOrBackend>,
PublicFrontend.UpdateDefinition<LoadBalancer.Update>,
PublicFrontend.Update {
    FrontendImpl(FrontendIPConfigurationInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        SubResource subnetRef = ((FrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourcePathFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    public String subnetName() {
        SubResource subnetRef = ((FrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String privateIpAddress() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).privateIPAddress();
    }

    @Override
    public IPAllocationMethod privateIpAllocationMethod() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).privateIPAllocationMethod();
    }

    public String name() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).name();
    }

    @Override
    public String publicIpAddressId() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress().id();
    }

    @Override
    public boolean isPublic() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress() != null;
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).loadBalancingRules() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public Map<String, InboundNatPool> inboundNatPools() {
        TreeMap<String, InboundNatPool> pools = new TreeMap<String, InboundNatPool>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatPools() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatPools()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                InboundNatPool pool = ((LoadBalancerImpl)this.parent()).inboundNatPools().get(name);
                if (pool == null) continue;
                pools.put(name, pool);
            }
        }
        return Collections.unmodifiableMap(pools);
    }

    @Override
    public Map<String, InboundNatRule> inboundNatRules() {
        TreeMap<String, InboundNatRule> rules = new TreeMap<String, InboundNatRule>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatRules() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                InboundNatRule rule = ((LoadBalancerImpl)this.parent()).inboundNatRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public FrontendImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public FrontendImpl withExistingSubnet(String parentNetworkResourceId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(parentNetworkResourceId + "/subnets/" + subnetName);
        ((FrontendIPConfigurationInner)((Object)this.inner())).withSubnet(subnetRef).withPublicIPAddress(null);
        return this;
    }

    @Override
    public FrontendImpl withExistingPublicIpAddress(PublicIpAddress pip) {
        return this.withExistingPublicIpAddress(pip.id());
    }

    @Override
    public FrontendImpl withExistingPublicIpAddress(String resourceId) {
        SubResource pipRef = new SubResource().withId(resourceId);
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(pipRef).withSubnet(null).withPrivateIPAddress(null).withPrivateIPAllocationMethod(null);
        return this;
    }

    @Override
    public FrontendImpl withoutPublicIpAddress() {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(null);
        return this;
    }

    @Override
    public FrontendImpl withPrivateIpAddressDynamic() {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(null).withPrivateIPAllocationMethod(IPAllocationMethod.DYNAMIC).withPublicIPAddress(null);
        return this;
    }

    @Override
    public FrontendImpl withPrivateIpAddressStatic(String ipAddress) {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(ipAddress).withPrivateIPAllocationMethod(IPAllocationMethod.STATIC).withPublicIPAddress(null);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withFrontend(this);
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        String pipId = this.publicIpAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIpAddress)((LoadBalancerImpl)this.parent()).manager().publicIpAddresses().getById(pipId);
    }
}

