/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.Backend;
import com.microsoft.azure.management.network.Frontend;
import com.microsoft.azure.management.network.HttpProbe;
import com.microsoft.azure.management.network.InboundNatPool;
import com.microsoft.azure.management.network.InboundNatRule;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NicIpConfiguration;
import com.microsoft.azure.management.network.Probe;
import com.microsoft.azure.management.network.ProbeProtocol;
import com.microsoft.azure.management.network.PublicFrontend;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.TcpProbe;
import com.microsoft.azure.management.network.TransportProtocol;
import com.microsoft.azure.management.network.implementation.BackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.BackendImpl;
import com.microsoft.azure.management.network.implementation.FrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.FrontendImpl;
import com.microsoft.azure.management.network.implementation.InboundNatPoolImpl;
import com.microsoft.azure.management.network.implementation.InboundNatPoolInner;
import com.microsoft.azure.management.network.implementation.InboundNatRuleImpl;
import com.microsoft.azure.management.network.implementation.InboundNatRuleInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.LoadBalancersInner;
import com.microsoft.azure.management.network.implementation.LoadBalancingRuleImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancingRuleInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.ProbeImpl;
import com.microsoft.azure.management.network.implementation.ProbeInner;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class LoadBalancerImpl
extends GroupableParentResourceImpl<LoadBalancer, LoadBalancerInner, LoadBalancerImpl, NetworkManager>
implements LoadBalancer,
LoadBalancer.Definition,
LoadBalancer.Update {
    static final String DEFAULT = "default";
    private final LoadBalancersInner innerCollection;
    private final HashMap<String, String> nicsInBackends = new HashMap();
    private final HashMap<String, String> creatablePIPKeys = new HashMap();
    private Map<String, Backend> backends;
    private Map<String, TcpProbe> tcpProbes;
    private Map<String, HttpProbe> httpProbes;
    private Map<String, LoadBalancingRule> loadBalancingRules;
    private Map<String, Frontend> frontends;
    private Map<String, InboundNatRule> inboundNatRules;
    private Map<String, InboundNatPool> inboundNatPools;

    LoadBalancerImpl(String name, LoadBalancerInner innerModel, LoadBalancersInner innerCollection, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.innerCollection = innerCollection;
    }

    public LoadBalancerImpl refresh() {
        LoadBalancerInner inner = this.innerCollection.get(this.resourceGroupName(), this.name());
        this.setInner((Object)inner);
        this.initializeChildrenFromInner();
        return this;
    }

    protected void initializeChildrenFromInner() {
        this.initializeFrontendsFromInner();
        this.initializeProbesFromInner();
        this.initializeBackendsFromInner();
        this.initializeLoadBalancingRulesFromInner();
        this.initializeInboundNatRulesFromInner();
        this.initializeInboundNatPoolsFromInner();
    }

    protected void beforeCreating() {
        SubResource frontendRef;
        for (Map.Entry<String, String> pipFrontendAssociation : this.creatablePIPKeys.entrySet()) {
            PublicIpAddress pip = (PublicIpAddress)this.createdResource(pipFrontendAssociation.getKey());
            if (pip == null) continue;
            this.withExistingPublicIpAddress(pip.id(), pipFrontendAssociation.getValue());
        }
        this.creatablePIPKeys.clear();
        ((LoadBalancerInner)((Object)this.inner())).withProbes(this.innersFromWrappers(this.httpProbes.values()));
        ((LoadBalancerInner)((Object)this.inner())).withProbes(this.innersFromWrappers(this.tcpProbes.values(), ((LoadBalancerInner)((Object)this.inner())).probes()));
        ((LoadBalancerInner)((Object)this.inner())).withBackendAddressPools(this.innersFromWrappers(this.backends.values()));
        ((LoadBalancerInner)((Object)this.inner())).withFrontendIPConfigurations(this.innersFromWrappers(this.frontends.values()));
        ((LoadBalancerInner)((Object)this.inner())).withInboundNatRules(this.innersFromWrappers(this.inboundNatRules.values()));
        for (InboundNatRule natRule : this.inboundNatRules.values()) {
            frontendRef = ((InboundNatRuleInner)((Object)natRule.inner())).frontendIPConfiguration();
            if (frontendRef == null || this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)frontendRef.id()))) continue;
            ((InboundNatRuleInner)((Object)natRule.inner())).withFrontendIPConfiguration(null);
        }
        ((LoadBalancerInner)((Object)this.inner())).withInboundNatPools(this.innersFromWrappers(this.inboundNatPools.values()));
        for (InboundNatPool natPool : this.inboundNatPools.values()) {
            frontendRef = ((InboundNatPoolInner)((Object)natPool.inner())).frontendIPConfiguration();
            if (frontendRef == null || this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)frontendRef.id()))) continue;
            ((InboundNatPoolInner)((Object)natPool.inner())).withFrontendIPConfiguration(null);
        }
        ((LoadBalancerInner)((Object)this.inner())).withLoadBalancingRules(this.innersFromWrappers(this.loadBalancingRules.values()));
        for (LoadBalancingRule lbRule : this.loadBalancingRules.values()) {
            SubResource probeRef;
            SubResource backendRef;
            frontendRef = ((LoadBalancingRuleInner)((Object)lbRule.inner())).frontendIPConfiguration();
            if (frontendRef != null && !this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)frontendRef.id()))) {
                ((LoadBalancingRuleInner)((Object)lbRule.inner())).withFrontendIPConfiguration(null);
            }
            if ((backendRef = ((LoadBalancingRuleInner)((Object)lbRule.inner())).backendAddressPool()) != null && !this.backends().containsKey(ResourceUtils.nameFromResourceId((String)backendRef.id()))) {
                ((LoadBalancingRuleInner)((Object)lbRule.inner())).withBackendAddressPool(null);
            }
            if ((probeRef = ((LoadBalancingRuleInner)((Object)lbRule.inner())).probe()) == null || this.httpProbes().containsKey(ResourceUtils.nameFromResourceId((String)probeRef.id())) || this.tcpProbes().containsKey(ResourceUtils.nameFromResourceId((String)probeRef.id()))) continue;
            ((LoadBalancingRuleInner)((Object)lbRule.inner())).withProbe(null);
        }
    }

    protected void afterCreating() {
        for (Map.Entry<String, String> nicInBackend : this.nicsInBackends.entrySet()) {
            String nicId = nicInBackend.getKey();
            String backendName = nicInBackend.getValue();
            try {
                NetworkInterface nic = (NetworkInterface)this.manager().networkInterfaces().getById(nicId);
                NicIpConfiguration nicIp = nic.primaryIpConfiguration();
                ((NetworkInterface.Update)((NetworkInterface.Update)nic.update()).updateIpConfiguration(nicIp.name()).withExistingLoadBalancerBackend(this, backendName).parent()).apply();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.nicsInBackends.clear();
        this.refresh();
    }

    protected Observable<LoadBalancerInner> createInner() {
        return this.innerCollection.createOrUpdateAsync(this.resourceGroupName(), this.name(), (LoadBalancerInner)((Object)this.inner()));
    }

    private void initializeFrontendsFromInner() {
        this.frontends = new TreeMap<String, Frontend>();
        List<FrontendIPConfigurationInner> frontendsInner = ((LoadBalancerInner)((Object)this.inner())).frontendIPConfigurations();
        if (frontendsInner != null) {
            for (FrontendIPConfigurationInner frontendInner : frontendsInner) {
                FrontendImpl frontend = new FrontendImpl(frontendInner, this);
                this.frontends.put(frontendInner.name(), frontend);
            }
        }
    }

    private void initializeBackendsFromInner() {
        this.backends = new TreeMap<String, Backend>();
        List<BackendAddressPoolInner> backendsInner = ((LoadBalancerInner)((Object)this.inner())).backendAddressPools();
        if (backendsInner != null) {
            for (BackendAddressPoolInner backendInner : backendsInner) {
                BackendImpl backend = new BackendImpl(backendInner, this);
                this.backends.put(backendInner.name(), backend);
            }
        }
    }

    private void initializeProbesFromInner() {
        this.httpProbes = new TreeMap<String, HttpProbe>();
        this.tcpProbes = new TreeMap<String, TcpProbe>();
        if (((LoadBalancerInner)((Object)this.inner())).probes() != null) {
            for (ProbeInner probeInner : ((LoadBalancerInner)((Object)this.inner())).probes()) {
                ProbeImpl probe = new ProbeImpl(probeInner, this);
                if (probeInner.protocol().equals(ProbeProtocol.TCP)) {
                    this.tcpProbes.put(probeInner.name(), probe);
                    continue;
                }
                if (!probeInner.protocol().equals(ProbeProtocol.HTTP)) continue;
                this.httpProbes.put(probeInner.name(), probe);
            }
        }
    }

    private void initializeLoadBalancingRulesFromInner() {
        this.loadBalancingRules = new TreeMap<String, LoadBalancingRule>();
        List<LoadBalancingRuleInner> rulesInner = ((LoadBalancerInner)((Object)this.inner())).loadBalancingRules();
        if (rulesInner != null) {
            for (LoadBalancingRuleInner ruleInner : rulesInner) {
                LoadBalancingRuleImpl rule = new LoadBalancingRuleImpl(ruleInner, this);
                this.loadBalancingRules.put(ruleInner.name(), rule);
            }
        }
    }

    private void initializeInboundNatPoolsFromInner() {
        this.inboundNatPools = new TreeMap<String, InboundNatPool>();
        List<InboundNatPoolInner> inners = ((LoadBalancerInner)((Object)this.inner())).inboundNatPools();
        if (inners != null) {
            for (InboundNatPoolInner inner : inners) {
                InboundNatPoolImpl wrapper = new InboundNatPoolImpl(inner, this);
                this.inboundNatPools.put(wrapper.name(), wrapper);
            }
        }
    }

    private void initializeInboundNatRulesFromInner() {
        this.inboundNatRules = new TreeMap<String, InboundNatRule>();
        List<InboundNatRuleInner> rulesInner = ((LoadBalancerInner)((Object)this.inner())).inboundNatRules();
        if (rulesInner != null) {
            for (InboundNatRuleInner ruleInner : rulesInner) {
                InboundNatRuleImpl rule = new InboundNatRuleImpl(ruleInner, this);
                this.inboundNatRules.put(ruleInner.name(), rule);
            }
        }
    }

    NetworkManager manager() {
        return (NetworkManager)this.myManager;
    }

    String futureResourceId() {
        return super.resourceIdBase() + "/providers/Microsoft.Network/loadBalancers/" + this.name();
    }

    LoadBalancerImpl withFrontend(FrontendImpl frontend) {
        if (frontend == null) {
            return null;
        }
        this.frontends.put(frontend.name(), frontend);
        return this;
    }

    LoadBalancerImpl withProbe(ProbeImpl probe) {
        if (probe == null) {
            return null;
        }
        if (probe.protocol() == ProbeProtocol.HTTP) {
            this.httpProbes.put(probe.name(), probe);
        } else if (probe.protocol() == ProbeProtocol.TCP) {
            this.tcpProbes.put(probe.name(), probe);
        }
        return this;
    }

    LoadBalancerImpl withLoadBalancingRule(LoadBalancingRuleImpl loadBalancingRule) {
        if (loadBalancingRule == null) {
            return null;
        }
        this.loadBalancingRules.put(loadBalancingRule.name(), loadBalancingRule);
        return this;
    }

    LoadBalancerImpl withInboundNatRule(InboundNatRuleImpl inboundNatRule) {
        if (inboundNatRule == null) {
            return null;
        }
        this.inboundNatRules.put(inboundNatRule.name(), inboundNatRule);
        return this;
    }

    LoadBalancerImpl withInboundNatPool(InboundNatPoolImpl inboundNatPool) {
        if (inboundNatPool == null) {
            return null;
        }
        this.inboundNatPools.put(inboundNatPool.name(), inboundNatPool);
        return this;
    }

    LoadBalancerImpl withBackend(BackendImpl backend) {
        if (backend == null) {
            return null;
        }
        this.backends.put(backend.name(), backend);
        return this;
    }

    @Override
    public LoadBalancerImpl withNewPublicIpAddress() {
        String dnsLeafLabel = this.name().toLowerCase().replace("\\s", "");
        return this.withNewPublicIpAddress(dnsLeafLabel);
    }

    @Override
    public LoadBalancerImpl withNewPublicIpAddress(String dnsLeafLabel) {
        PublicIpAddress.DefinitionStages.WithGroup precreatablePIP = (PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.manager().publicIpAddresses().define(dnsLeafLabel)).withRegion(this.regionName());
        Creatable creatablePip = this.creatableGroup == null ? (Creatable)precreatablePIP.withExistingResourceGroup(this.resourceGroupName()) : (Creatable)precreatablePIP.withNewResourceGroup(this.creatableGroup);
        return this.withNewPublicIpAddress(creatablePip);
    }

    @Override
    public final LoadBalancerImpl withNewPublicIpAddress(Creatable<PublicIpAddress> creatablePIP) {
        this.creatablePIPKeys.put(creatablePIP.key(), DEFAULT);
        this.addCreatableDependency(creatablePIP);
        return this;
    }

    @Override
    public LoadBalancerImpl withExistingPublicIpAddress(PublicIpAddress publicIpAddress) {
        return this.withExistingPublicIpAddress(publicIpAddress.id(), DEFAULT);
    }

    private LoadBalancerImpl withExistingPublicIpAddress(String resourceId, String frontendName) {
        if (frontendName == null) {
            frontendName = DEFAULT;
        }
        return this.definePublicFrontend(frontendName).withExistingPublicIpAddress(resourceId).attach();
    }

    @Override
    public LoadBalancerImpl withExistingSubnet(Network network, String subnetName) {
        return this.definePrivateFrontend(DEFAULT).withExistingSubnet(network, subnetName).attach();
    }

    private LoadBalancerImpl withExistingVirtualMachine(HasNetworkInterfaces vm, String backendName) {
        if (backendName == null) {
            backendName = DEFAULT;
        }
        this.defineBackend(backendName).attach();
        if (vm.primaryNetworkInterfaceId() != null) {
            this.nicsInBackends.put(vm.primaryNetworkInterfaceId(), backendName.toLowerCase());
        }
        return this;
    }

    @Override
    public LoadBalancerImpl withExistingVirtualMachines(HasNetworkInterfaces ... vms) {
        if (vms != null) {
            for (HasNetworkInterfaces vm : vms) {
                this.withExistingVirtualMachine(vm, null);
            }
        }
        return this;
    }

    @Override
    public LoadBalancerImpl withLoadBalancingRule(int frontendPort, TransportProtocol protocol, int backendPort) {
        this.defineLoadBalancingRule(DEFAULT).withFrontendPort(frontendPort).withFrontend(DEFAULT).withBackendPort(backendPort).withBackend(DEFAULT).withProtocol(protocol).withProbe(DEFAULT).attach();
        return this;
    }

    @Override
    public LoadBalancerImpl withLoadBalancingRule(int port, TransportProtocol protocol) {
        return this.withLoadBalancingRule(port, protocol, port);
    }

    @Override
    public LoadBalancerImpl withTcpProbe(int port) {
        return this.defineTcpProbe(DEFAULT).withPort(port).attach();
    }

    @Override
    public LoadBalancerImpl withHttpProbe(String path) {
        return this.defineHttpProbe(DEFAULT).withRequestPath(path).withPort(80).attach();
    }

    public ProbeImpl defineTcpProbe(String name) {
        Probe probe = this.tcpProbes.get(name);
        if (probe == null) {
            ProbeInner inner = new ProbeInner().withName(name).withProtocol(ProbeProtocol.TCP);
            return new ProbeImpl(inner, this);
        }
        return (ProbeImpl)probe;
    }

    public ProbeImpl defineHttpProbe(String name) {
        Probe probe = this.httpProbes.get(name);
        if (probe == null) {
            ProbeInner inner = new ProbeInner().withName(name).withProtocol(ProbeProtocol.HTTP).withPort(80);
            return new ProbeImpl(inner, this);
        }
        return (ProbeImpl)probe;
    }

    public LoadBalancingRuleImpl defineLoadBalancingRule(String name) {
        LoadBalancingRule lbRule = this.loadBalancingRules.get(name);
        if (lbRule == null) {
            LoadBalancingRuleInner inner = new LoadBalancingRuleInner().withName(name);
            return new LoadBalancingRuleImpl(inner, this);
        }
        return (LoadBalancingRuleImpl)lbRule;
    }

    public InboundNatRuleImpl defineInboundNatRule(String name) {
        InboundNatRule natRule = this.inboundNatRules.get(name);
        if (natRule == null) {
            InboundNatRuleInner inner = new InboundNatRuleInner().withName(name);
            return new InboundNatRuleImpl(inner, this);
        }
        return (InboundNatRuleImpl)natRule;
    }

    public InboundNatPoolImpl defineInboundNatPool(String name) {
        InboundNatPool natPool = this.inboundNatPools.get(name);
        if (natPool == null) {
            InboundNatPoolInner inner = new InboundNatPoolInner().withName(name);
            return new InboundNatPoolImpl(inner, this);
        }
        return (InboundNatPoolImpl)natPool;
    }

    public FrontendImpl definePrivateFrontend(String name) {
        return this.defineFrontend(name);
    }

    public FrontendImpl definePublicFrontend(String name) {
        return this.defineFrontend(name);
    }

    private FrontendImpl defineFrontend(String name) {
        Frontend frontend = this.frontends.get(name);
        if (frontend == null) {
            FrontendIPConfigurationInner inner = new FrontendIPConfigurationInner().withName(name);
            return new FrontendImpl(inner, this);
        }
        return (FrontendImpl)frontend;
    }

    public BackendImpl defineBackend(String name) {
        Backend backend = this.backends.get(name);
        if (backend == null) {
            BackendAddressPoolInner inner = new BackendAddressPoolInner().withName(name);
            return new BackendImpl(inner, this);
        }
        return (BackendImpl)backend;
    }

    @Override
    public LoadBalancerImpl withoutProbe(String name) {
        if (this.httpProbes.containsKey(name)) {
            this.httpProbes.remove(name);
        } else if (this.tcpProbes.containsKey(name)) {
            this.tcpProbes.remove(name);
        }
        return this;
    }

    @Override
    public ProbeImpl updateTcpProbe(String name) {
        return (ProbeImpl)this.tcpProbes.get(name);
    }

    @Override
    public BackendImpl updateBackend(String name) {
        return (BackendImpl)this.backends.get(name);
    }

    @Override
    public FrontendImpl updateInternetFrontend(String name) {
        return (FrontendImpl)this.frontends.get(name);
    }

    @Override
    public FrontendImpl updateInternalFrontend(String name) {
        return (FrontendImpl)this.frontends.get(name);
    }

    @Override
    public InboundNatRuleImpl updateInboundNatRule(String name) {
        return (InboundNatRuleImpl)this.inboundNatRules.get(name);
    }

    @Override
    public InboundNatPoolImpl updateInboundNatPool(String name) {
        return (InboundNatPoolImpl)this.inboundNatPools.get(name);
    }

    @Override
    public ProbeImpl updateHttpProbe(String name) {
        return (ProbeImpl)this.httpProbes.get(name);
    }

    @Override
    public LoadBalancingRuleImpl updateLoadBalancingRule(String name) {
        return (LoadBalancingRuleImpl)this.loadBalancingRules.get(name);
    }

    @Override
    public LoadBalancerImpl withoutLoadBalancingRule(String name) {
        this.loadBalancingRules.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutInboundNatRule(String name) {
        this.inboundNatRules.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutBackend(String name) {
        this.backends.remove(name);
        return this;
    }

    @Override
    public LoadBalancer.Update withoutInboundNatPool(String name) {
        this.inboundNatPools.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutFrontend(String name) {
        this.frontends.remove(name);
        return this;
    }

    @Override
    public Map<String, Backend> backends() {
        return Collections.unmodifiableMap(this.backends);
    }

    @Override
    public Map<String, InboundNatPool> inboundNatPools() {
        return Collections.unmodifiableMap(this.inboundNatPools);
    }

    @Override
    public Map<String, TcpProbe> tcpProbes() {
        return Collections.unmodifiableMap(this.tcpProbes);
    }

    @Override
    public Map<String, Frontend> frontends() {
        return Collections.unmodifiableMap(this.frontends);
    }

    @Override
    public Map<String, InboundNatRule> inboundNatRules() {
        return Collections.unmodifiableMap(this.inboundNatRules);
    }

    @Override
    public Map<String, HttpProbe> httpProbes() {
        return Collections.unmodifiableMap(this.httpProbes);
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        return Collections.unmodifiableMap(this.loadBalancingRules);
    }

    @Override
    public List<String> publicIpAddressIds() {
        ArrayList<String> publicIpAddressIds = new ArrayList<String>();
        for (Frontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            String pipId = ((PublicFrontend)frontend).publicIpAddressId();
            publicIpAddressIds.add(pipId);
        }
        return Collections.unmodifiableList(publicIpAddressIds);
    }
}

