/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class LoadBalancersInner {
    private LoadBalancersService service;
    private NetworkManagementClientImpl client;

    public LoadBalancersInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LoadBalancersService)retrofit.create(LoadBalancersService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String loadBalancerName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> deleteAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String loadBalancerName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, loadBalancerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String loadBalancerName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, loadBalancerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).build(response);
    }

    public LoadBalancerInner get(String resourceGroupName, String loadBalancerName) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName).toBlocking().single()).getBody());
    }

    public ServiceCall<LoadBalancerInner> getAsync(String resourceGroupName, String loadBalancerName, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName), serviceCallback);
    }

    public Observable<LoadBalancerInner> getAsync(String resourceGroupName, String loadBalancerName) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String expand = null;
        return this.service.get(resourceGroupName, loadBalancerName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public LoadBalancerInner get(String resourceGroupName, String loadBalancerName, String expand) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, expand).toBlocking().single()).getBody());
    }

    public ServiceCall<LoadBalancerInner> getAsync(String resourceGroupName, String loadBalancerName, String expand, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, expand), serviceCallback);
    }

    public Observable<LoadBalancerInner> getAsync(String resourceGroupName, String loadBalancerName, String expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, expand).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, loadBalancerName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LoadBalancerInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<LoadBalancerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LoadBalancerInner createOrUpdate(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).toBlocking().last()).getBody());
    }

    public ServiceCall<LoadBalancerInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceCall.create(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters), serviceCallback);
    }

    public Observable<LoadBalancerInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, loadBalancerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<LoadBalancerInner>(){}.getType());
    }

    public LoadBalancerInner beginCreateOrUpdate(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return (LoadBalancerInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).toBlocking().single()).getBody());
    }

    public ServiceCall<LoadBalancerInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters, ServiceCallback<LoadBalancerInner> serviceCallback) {
        return ServiceCall.create(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters), serviceCallback);
    }

    public Observable<LoadBalancerInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, parameters).map((Func1)new Func1<ServiceResponse<LoadBalancerInner>, LoadBalancerInner>(){

            public LoadBalancerInner call(ServiceResponse<LoadBalancerInner> response) {
                return (LoadBalancerInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<LoadBalancerInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, LoadBalancerInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginCreateOrUpdate(resourceGroupName, loadBalancerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LoadBalancerInner>>>(){

            public Observable<ServiceResponse<LoadBalancerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LoadBalancerInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(201, new TypeToken<LoadBalancerInner>(){}.getType()).register(200, new TypeToken<LoadBalancerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> listAll() {
        ServiceResponse response = (ServiceResponse)this.listAllSinglePageAsync().toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.getBody()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<LoadBalancerInner>> listAllAsync(ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listAllAsync() {
        return this.listAllWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listAllWithServiceResponseAsync() {
        return this.listAllSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listAllSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAll(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listAllDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listAllDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> list(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.getBody()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<LoadBalancerInner>> listAsync(String resourceGroupName, ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listAsync(String resourceGroupName) {
        return this.listWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listWithServiceResponseAsync(String resourceGroupName) {
        return this.listSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> listAllNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.getBody()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listAllNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<LoadBalancerInner>> listAllNextAsync(String nextPageLink, ServiceCall<List<LoadBalancerInner>> serviceCall, ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceCall.create(this.listAllNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listAllNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listAllNextAsync(String nextPageLink) {
        return this.listAllNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listAllNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAllNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listAllNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listAllNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listAllNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listAllNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listAllNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LoadBalancerInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<LoadBalancerInner>((Page)response.getBody()){

            public Page<LoadBalancerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<LoadBalancerInner>> listNextAsync(String nextPageLink, ServiceCall<List<LoadBalancerInner>> serviceCall, ListOperationCallback<LoadBalancerInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(String nextPageLink) {
                return LoadBalancersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LoadBalancerInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Page<LoadBalancerInner>>(){

            public Page<LoadBalancerInner> call(ServiceResponse<Page<LoadBalancerInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<LoadBalancerInner>>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(ServiceResponse<Page<LoadBalancerInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LoadBalancerInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LoadBalancerInner>>>>(){

            public Observable<ServiceResponse<Page<LoadBalancerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LoadBalancerInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<LoadBalancerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LoadBalancersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Body LoadBalancerInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Body LoadBalancerInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/loadBalancers")
        public Observable<Response<ResponseBody>> listAll(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listAllNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

