/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class LocalNetworkGatewaysInner {
    private LocalNetworkGatewaysService service;
    private NetworkManagementClientImpl client;

    public LocalNetworkGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LocalNetworkGatewaysService)retrofit.create(LocalNetworkGatewaysService.class);
        this.client = client;
    }

    public LocalNetworkGatewayInner createOrUpdate(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters) {
        return (LocalNetworkGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName, parameters).toBlocking().last()).getBody());
    }

    public ServiceCall<LocalNetworkGatewayInner> createOrUpdateAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters, ServiceCallback<LocalNetworkGatewayInner> serviceCallback) {
        return ServiceCall.create(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<LocalNetworkGatewayInner> createOrUpdateAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<LocalNetworkGatewayInner>, LocalNetworkGatewayInner>(){

            public LocalNetworkGatewayInner call(ServiceResponse<LocalNetworkGatewayInner> response) {
                return (LocalNetworkGatewayInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<LocalNetworkGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (localNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter localNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, localNetworkGatewayName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<LocalNetworkGatewayInner>(){}.getType());
    }

    public LocalNetworkGatewayInner beginCreateOrUpdate(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters) {
        return (LocalNetworkGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName, parameters).toBlocking().single()).getBody());
    }

    public ServiceCall<LocalNetworkGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters, ServiceCallback<LocalNetworkGatewayInner> serviceCallback) {
        return ServiceCall.create(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<LocalNetworkGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<LocalNetworkGatewayInner>, LocalNetworkGatewayInner>(){

            public LocalNetworkGatewayInner call(ServiceResponse<LocalNetworkGatewayInner> response) {
                return (LocalNetworkGatewayInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<LocalNetworkGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (localNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter localNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginCreateOrUpdate(resourceGroupName, localNetworkGatewayName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LocalNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<LocalNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LocalNetworkGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LocalNetworkGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(201, new TypeToken<LocalNetworkGatewayInner>(){}.getType()).register(200, new TypeToken<LocalNetworkGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LocalNetworkGatewayInner get(String resourceGroupName, String localNetworkGatewayName) {
        return (LocalNetworkGatewayInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName).toBlocking().single()).getBody());
    }

    public ServiceCall<LocalNetworkGatewayInner> getAsync(String resourceGroupName, String localNetworkGatewayName, ServiceCallback<LocalNetworkGatewayInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName), serviceCallback);
    }

    public Observable<LocalNetworkGatewayInner> getAsync(String resourceGroupName, String localNetworkGatewayName) {
        return this.getWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName).map((Func1)new Func1<ServiceResponse<LocalNetworkGatewayInner>, LocalNetworkGatewayInner>(){

            public LocalNetworkGatewayInner call(ServiceResponse<LocalNetworkGatewayInner> response) {
                return (LocalNetworkGatewayInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<LocalNetworkGatewayInner>> getWithServiceResponseAsync(String resourceGroupName, String localNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (localNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter localNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, localNetworkGatewayName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LocalNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<LocalNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LocalNetworkGatewaysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LocalNetworkGatewayInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<LocalNetworkGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String localNetworkGatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> deleteAsync(String resourceGroupName, String localNetworkGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.deleteWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String localNetworkGatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String localNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (localNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter localNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, localNetworkGatewayName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String localNetworkGatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginDeleteAsync(String resourceGroupName, String localNetworkGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginDeleteWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String localNetworkGatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, localNetworkGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String localNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (localNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter localNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, localNetworkGatewayName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LocalNetworkGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).build(response);
    }

    public PagedList<LocalNetworkGatewayInner> list(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<LocalNetworkGatewayInner>((Page)response.getBody()){

            public Page<LocalNetworkGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocalNetworkGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<LocalNetworkGatewayInner>> listAsync(String resourceGroupName, ListOperationCallback<LocalNetworkGatewayInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> call(String nextPageLink) {
                return LocalNetworkGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LocalNetworkGatewayInner>> listAsync(String resourceGroupName) {
        return this.listWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<LocalNetworkGatewayInner>>, Page<LocalNetworkGatewayInner>>(){

            public Page<LocalNetworkGatewayInner> call(ServiceResponse<Page<LocalNetworkGatewayInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> listWithServiceResponseAsync(String resourceGroupName) {
        return this.listSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<LocalNetworkGatewayInner>>, Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> call(ServiceResponse<Page<LocalNetworkGatewayInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocalNetworkGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> listSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocalNetworkGatewaysInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LocalNetworkGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<LocalNetworkGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<LocalNetworkGatewayInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<LocalNetworkGatewayInner>((Page)response.getBody()){

            public Page<LocalNetworkGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocalNetworkGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<LocalNetworkGatewayInner>> listNextAsync(String nextPageLink, ServiceCall<List<LocalNetworkGatewayInner>> serviceCall, ListOperationCallback<LocalNetworkGatewayInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> call(String nextPageLink) {
                return LocalNetworkGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<LocalNetworkGatewayInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<LocalNetworkGatewayInner>>, Page<LocalNetworkGatewayInner>>(){

            public Page<LocalNetworkGatewayInner> call(ServiceResponse<Page<LocalNetworkGatewayInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<LocalNetworkGatewayInner>>, Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> call(ServiceResponse<Page<LocalNetworkGatewayInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocalNetworkGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<LocalNetworkGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocalNetworkGatewaysInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LocalNetworkGatewayInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<LocalNetworkGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LocalNetworkGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="localNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body LocalNetworkGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="localNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body LocalNetworkGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="localNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="localNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="localNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

