/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.AddressSpace;
import com.microsoft.azure.management.network.DhcpOptions;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.SubnetImpl;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworksInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class NetworkImpl
extends GroupableParentResourceImpl<Network, VirtualNetworkInner, NetworkImpl, NetworkManager>
implements Network,
Network.Definition,
Network.Update {
    private final VirtualNetworksInner innerCollection;
    private Map<String, Subnet> subnets;

    NetworkImpl(String name, VirtualNetworkInner innerModel, VirtualNetworksInner innerCollection, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.innerCollection = innerCollection;
    }

    protected void initializeChildrenFromInner() {
        this.subnets = new TreeMap<String, Subnet>();
        List<SubnetInner> inners = ((VirtualNetworkInner)((Object)this.inner())).subnets();
        if (inners != null) {
            for (SubnetInner inner : inners) {
                SubnetImpl subnet = new SubnetImpl(inner, this);
                this.subnets.put(inner.name(), subnet);
            }
        }
    }

    public NetworkImpl refresh() {
        VirtualNetworkInner inner = this.innerCollection.get(this.resourceGroupName(), this.name());
        this.setInner((Object)inner);
        this.initializeChildrenFromInner();
        return this;
    }

    NetworkImpl withSubnet(SubnetImpl subnet) {
        this.subnets.put(subnet.name(), subnet);
        return this;
    }

    NetworkManager manager() {
        return (NetworkManager)this.myManager;
    }

    @Override
    public NetworkImpl withDnsServer(String ipAddress) {
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).withDhcpOptions(new DhcpOptions());
        }
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().withDnsServers(new ArrayList<String>());
        }
        ((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers().add(ipAddress);
        return this;
    }

    @Override
    public NetworkImpl withSubnet(String name, String cidr) {
        return this.defineSubnet(name).withAddressPrefix(cidr).attach();
    }

    @Override
    public NetworkImpl withSubnets(Map<String, String> nameCidrPairs) {
        this.subnets.clear();
        for (Map.Entry<String, String> pair : nameCidrPairs.entrySet()) {
            this.withSubnet(pair.getKey(), pair.getValue());
        }
        return this;
    }

    @Override
    public NetworkImpl withoutSubnet(String name) {
        this.subnets.remove(name);
        return this;
    }

    @Override
    public NetworkImpl withAddressSpace(String cidr) {
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).withAddressSpace(new AddressSpace());
        }
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).addressSpace().withAddressPrefixes(new ArrayList<String>());
        }
        ((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes().add(cidr);
        return this;
    }

    public SubnetImpl defineSubnet(String name) {
        SubnetInner inner = new SubnetInner().withName(name);
        return new SubnetImpl(inner, this);
    }

    @Override
    public List<String> addressSpaces() {
        ArrayList addressSpaces = new ArrayList();
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace() == null) {
            return Collections.unmodifiableList(addressSpaces);
        }
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes() == null) {
            return Collections.unmodifiableList(addressSpaces);
        }
        return Collections.unmodifiableList(((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes());
    }

    @Override
    public List<String> dnsServerIps() {
        ArrayList ips = new ArrayList();
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions() == null) {
            return Collections.unmodifiableList(ips);
        }
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers() == null) {
            return Collections.unmodifiableList(ips);
        }
        return ((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers();
    }

    @Override
    public Map<String, Subnet> subnets() {
        return Collections.unmodifiableMap(this.subnets);
    }

    protected void beforeCreating() {
        if (this.addressSpaces().size() == 0) {
            this.withAddressSpace("10.0.0.0/16");
        }
        if (this.isInCreateMode() && this.subnets.size() == 0) {
            this.withSubnet("subnet1", this.addressSpaces().get(0));
        }
        ((VirtualNetworkInner)((Object)this.inner())).withSubnets(this.innersFromWrappers(this.subnets.values()));
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    @Override
    public SubnetImpl updateSubnet(String name) {
        return (SubnetImpl)this.subnets.get(name);
    }

    protected Observable<VirtualNetworkInner> createInner() {
        return this.innerCollection.createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualNetworkInner)((Object)this.inner()));
    }
}

