/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NicIpConfiguration;
import com.microsoft.azure.management.network.PublicIpAddress;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NicIpConfigurationImpl;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class NetworkInterfaceImpl
extends GroupableParentResourceImpl<NetworkInterface, NetworkInterfaceInner, NetworkInterfaceImpl, NetworkManager>
implements NetworkInterface,
NetworkInterface.Definition,
NetworkInterface.Update {
    private final NetworkInterfacesInner innerCollection;
    private final String nicName;
    protected final ResourceNamer namer;
    private NicIpConfigurationImpl nicPrimaryIpConfiguration;
    private Map<String, NicIpConfiguration> nicIpConfigurations;
    private String creatableNetworkSecurityGroupKey;
    private NetworkSecurityGroup existingNetworkSecurityGroupToAssociate;
    private NetworkSecurityGroup networkSecurityGroup;

    NetworkInterfaceImpl(String name, NetworkInterfaceInner innerModel, NetworkInterfacesInner client, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
        this.innerCollection = client;
        this.nicName = name;
        this.namer = new ResourceNamer(this.nicName);
        this.initializeChildrenFromInner();
    }

    public NetworkInterface refresh() {
        NetworkInterfaceInner inner = this.innerCollection.get(this.resourceGroupName(), this.name());
        this.setInner((Object)inner);
        this.clearCachedRelatedResources();
        this.initializeChildrenFromInner();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(Creatable<Network> creatable) {
        this.primaryIpConfiguration().withNewNetwork((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String name, String addressSpaceCidr) {
        this.primaryIpConfiguration().withNewNetwork(name, addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String addressSpaceCidr) {
        this.primaryIpConfiguration().withNewNetwork(addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryNetwork(Network network) {
        this.primaryIpConfiguration().withExistingNetwork(network);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        this.primaryIpConfiguration().withNewPublicIpAddress((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIpAddress() {
        this.primaryIpConfiguration().withNewPublicIpAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIpAddress(String leafDnsLabel) {
        this.primaryIpConfiguration().withNewPublicIpAddress(leafDnsLabel);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerBackend(LoadBalancer loadBalancer, String backendName) {
        this.primaryIpConfiguration().withExistingLoadBalancerBackend(loadBalancer, backendName);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerInboundNatRule(LoadBalancer loadBalancer, String inboundNatRuleName) {
        this.primaryIpConfiguration().withExistingLoadBalancerInboundNatRule(loadBalancer, inboundNatRuleName);
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerBackends() {
        for (NicIpConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIpConfiguration(ipConfig.name()).withoutLoadBalancerBackends();
        }
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerInboundNatRules() {
        for (NicIpConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIpConfiguration(ipConfig.name()).withoutLoadBalancerInboundNatRules();
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutPrimaryPublicIpAddress() {
        this.primaryIpConfiguration().withoutPublicIpAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryPublicIpAddress(PublicIpAddress publicIpAddress) {
        this.primaryIpConfiguration().withExistingPublicIpAddress(publicIpAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIpAddressDynamic() {
        this.primaryIpConfiguration().withPrivateIpAddressDynamic();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIpAddressStatic(String staticPrivateIpAddress) {
        this.primaryIpConfiguration().withPrivateIpAddressStatic(staticPrivateIpAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> creatable) {
        if (this.creatableNetworkSecurityGroupKey == null) {
            this.creatableNetworkSecurityGroupKey = creatable.key();
            this.addCreatableDependency(creatable);
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup networkSecurityGroup) {
        this.existingNetworkSecurityGroupToAssociate = networkSecurityGroup;
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutNetworkSecurityGroup() {
        ((NetworkInterfaceInner)((Object)this.inner())).withNetworkSecurityGroup(null);
        return this;
    }

    public NicIpConfigurationImpl defineSecondaryIpConfiguration(String name) {
        return this.prepareNewNicIpConfiguration(name);
    }

    @Override
    public NicIpConfigurationImpl updateIpConfiguration(String name) {
        return (NicIpConfigurationImpl)this.nicIpConfigurations.get(name);
    }

    @Override
    public NetworkInterfaceImpl withIpForwarding() {
        ((NetworkInterfaceInner)((Object)this.inner())).withEnableIPForwarding(true);
        return this;
    }

    public NetworkInterfaceImpl withoutIpConfiguration(String name) {
        this.nicIpConfigurations.remove(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutIpForwarding() {
        ((NetworkInterfaceInner)((Object)this.inner())).withEnableIPForwarding(false);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withDnsServer(String ipAddress) {
        this.dnsServerIps().add(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutDnsServer(String ipAddress) {
        this.dnsServerIps().remove(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withAzureDnsServer() {
        this.dnsServerIps().clear();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withSubnet(String name) {
        this.primaryIpConfiguration().withSubnet(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withInternalDnsNameLabel(String dnsNameLabel) {
        ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().withInternalDnsNameLabel(dnsNameLabel);
        return this;
    }

    @Override
    public String virtualMachineId() {
        if (((NetworkInterfaceInner)((Object)this.inner())).virtualMachine() != null) {
            return ((NetworkInterfaceInner)((Object)this.inner())).virtualMachine().id();
        }
        return null;
    }

    @Override
    public boolean isIpForwardingEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.inner())).enableIPForwarding());
    }

    @Override
    public String macAddress() {
        return ((NetworkInterfaceInner)((Object)this.inner())).macAddress();
    }

    @Override
    public String internalDnsNameLabel() {
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDnsNameLabel() : null;
    }

    @Override
    public String internalDomainNameSuffix() {
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDomainNameSuffix() : null;
    }

    @Override
    public List<String> appliedDnsServers() {
        ArrayList dnsServers = new ArrayList();
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers());
    }

    @Override
    public String internalFqdn() {
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalFqdn() : null;
    }

    @Override
    public List<String> dnsServers() {
        return this.dnsServerIps();
    }

    @Override
    public String primaryPrivateIp() {
        return this.primaryIpConfiguration().privateIpAddress();
    }

    @Override
    public IPAllocationMethod primaryPrivateIpAllocationMethod() {
        return this.primaryIpConfiguration().privateIpAllocationMethod();
    }

    @Override
    public Map<String, NicIpConfiguration> ipConfigurations() {
        return Collections.unmodifiableMap(this.nicIpConfigurations);
    }

    @Override
    public String networkSecurityGroupId() {
        return ((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup() != null ? ((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup().id() : null;
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        if (this.networkSecurityGroup == null && this.networkSecurityGroupId() != null) {
            String id = this.networkSecurityGroupId();
            this.networkSecurityGroup = (NetworkSecurityGroup)((NetworkManager)this.myManager).networkSecurityGroups().getByGroup(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id));
        }
        return this.networkSecurityGroup;
    }

    @Override
    public NicIpConfigurationImpl primaryIpConfiguration() {
        if (this.nicPrimaryIpConfiguration != null) {
            return this.nicPrimaryIpConfiguration;
        }
        if (this.isInCreateMode()) {
            this.nicPrimaryIpConfiguration = this.prepareNewNicIpConfiguration("primary");
            this.withIpConfiguration(this.nicPrimaryIpConfiguration);
        } else {
            this.nicPrimaryIpConfiguration = (NicIpConfigurationImpl)new ArrayList<NicIpConfiguration>(this.nicIpConfigurations.values()).get(0);
        }
        return this.nicPrimaryIpConfiguration;
    }

    private List<String> dnsServerIps() {
        ArrayList<String> dnsServers = new ArrayList<String>();
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return dnsServers;
        }
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers() == null) {
            return dnsServers;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers();
    }

    protected void initializeChildrenFromInner() {
        this.nicIpConfigurations = new TreeMap<String, NicIpConfiguration>();
        List<NetworkInterfaceIPConfigurationInner> inners = ((NetworkInterfaceInner)((Object)this.inner())).ipConfigurations();
        if (inners != null) {
            for (NetworkInterfaceIPConfigurationInner inner : inners) {
                NicIpConfigurationImpl nicIpConfiguration = new NicIpConfigurationImpl(inner, this, (NetworkManager)this.myManager, false);
                this.nicIpConfigurations.put(nicIpConfiguration.name(), nicIpConfiguration);
            }
        }
    }

    private NicIpConfigurationImpl prepareNewNicIpConfiguration(String name) {
        NicIpConfigurationImpl nicIpConfiguration = NicIpConfigurationImpl.prepareNicIpConfiguration(name, this, (NetworkManager)this.myManager);
        return nicIpConfiguration;
    }

    private void clearCachedRelatedResources() {
        this.networkSecurityGroup = null;
        this.nicPrimaryIpConfiguration = null;
    }

    NetworkInterfaceImpl withIpConfiguration(NicIpConfigurationImpl nicIpConfiguration) {
        this.nicIpConfigurations.put(nicIpConfiguration.name(), nicIpConfiguration);
        return this;
    }

    void addToCreatableDependencies(Creatable<? extends com.microsoft.azure.management.resources.fluentcore.arm.models.Resource> creatableResource) {
        super.addCreatableDependency(creatableResource);
    }

    com.microsoft.azure.management.resources.fluentcore.arm.models.Resource createdDependencyResource(String key) {
        return super.createdResource(key);
    }

    Creatable<ResourceGroup> newGroup() {
        return this.creatableGroup;
    }

    protected Observable<NetworkInterfaceInner> createInner() {
        return this.innerCollection.createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkInterfaceInner)((Object)this.inner()));
    }

    protected void afterCreating() {
        this.clearCachedRelatedResources();
    }

    NetworkManager manager() {
        return (NetworkManager)this.myManager;
    }

    protected void beforeCreating() {
        NetworkSecurityGroup networkSecurityGroup = null;
        if (this.creatableNetworkSecurityGroupKey != null) {
            networkSecurityGroup = (NetworkSecurityGroup)this.createdResource(this.creatableNetworkSecurityGroupKey);
        } else if (this.existingNetworkSecurityGroupToAssociate != null) {
            networkSecurityGroup = this.existingNetworkSecurityGroupToAssociate;
        }
        if (networkSecurityGroup != null) {
            ((NetworkInterfaceInner)((Object)this.inner())).withNetworkSecurityGroup(new SubResource().withId(networkSecurityGroup.id()));
        }
        NicIpConfigurationImpl.ensureConfigurations(this.nicIpConfigurations.values());
        ((NetworkInterfaceInner)((Object)this.inner())).withIpConfigurations(this.innersFromWrappers(this.nicIpConfigurations.values()));
    }
}

