/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.network.LoadBalancers;
import com.microsoft.azure.management.network.NetworkInterfaces;
import com.microsoft.azure.management.network.NetworkSecurityGroups;
import com.microsoft.azure.management.network.Networks;
import com.microsoft.azure.management.network.PublicIpAddresses;
import com.microsoft.azure.management.network.implementation.LoadBalancersImpl;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupsImpl;
import com.microsoft.azure.management.network.implementation.NetworksImpl;
import com.microsoft.azure.management.network.implementation.PublicIpAddressesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public final class NetworkManager
extends Manager<NetworkManager, NetworkManagementClientImpl> {
    private PublicIpAddresses publicIpAddresses;
    private Networks networks;
    private NetworkSecurityGroups networkSecurityGroups;
    private NetworkInterfaces networkInterfaces;
    private LoadBalancers loadBalancers;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static NetworkManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new NetworkManager(credentials.getEnvironment().newRestClientBuilder().withCredentials((ServiceClientCredentials)credentials).build(), subscriptionId);
    }

    public static NetworkManager authenticate(RestClient restClient, String subscriptionId) {
        return new NetworkManager(restClient, subscriptionId);
    }

    private NetworkManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new NetworkManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public Networks networks() {
        if (this.networks == null) {
            this.networks = new NetworksImpl((NetworkManagementClientImpl)((Object)this.innerManagementClient), this);
        }
        return this.networks;
    }

    public NetworkSecurityGroups networkSecurityGroups() {
        if (this.networkSecurityGroups == null) {
            this.networkSecurityGroups = new NetworkSecurityGroupsImpl(((NetworkManagementClientImpl)((Object)this.innerManagementClient)).networkSecurityGroups(), this);
        }
        return this.networkSecurityGroups;
    }

    public PublicIpAddresses publicIpAddresses() {
        if (this.publicIpAddresses == null) {
            this.publicIpAddresses = new PublicIpAddressesImpl(((NetworkManagementClientImpl)((Object)this.innerManagementClient)).publicIPAddresses(), this);
        }
        return this.publicIpAddresses;
    }

    public NetworkInterfaces networkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new NetworkInterfacesImpl(((NetworkManagementClientImpl)((Object)this.innerManagementClient)).networkInterfaces(), this);
        }
        return this.networkInterfaces;
    }

    public LoadBalancers loadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new LoadBalancersImpl((NetworkManagementClientImpl)((Object)this.innerManagementClient), this);
        }
        return this.loadBalancers;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public NetworkManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return NetworkManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public NetworkManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

