/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterfaceBase;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Map;

@Fluent
public interface NetworkInterface
extends NetworkInterfaceBase,
GroupableResource<NetworkManager, NetworkInterfaceInner>,
Refreshable<NetworkInterface>,
Updatable<Update> {
    public Map<String, NicIPConfiguration> ipConfigurations();

    public NicIPConfiguration primaryIPConfiguration();

    public static interface Update
    extends Appliable<NetworkInterface>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithPrimaryNetworkSubnet,
    UpdateStages.WithPrimaryPrivateIP,
    UpdateStages.WithPrimaryPublicIPAddress,
    UpdateStages.WithNetworkSecurityGroup,
    UpdateStages.WithIPForwarding,
    UpdateStages.WithDnsServer,
    UpdateStages.WithIPConfiguration,
    UpdateStages.WithLoadBalancer {
    }

    public static interface UpdateStages {

        public static interface WithLoadBalancer {
            public Update withExistingLoadBalancerBackend(LoadBalancer var1, String var2);

            public Update withExistingLoadBalancerInboundNatRule(LoadBalancer var1, String var2);

            public Update withoutLoadBalancerBackends();

            public Update withoutLoadBalancerInboundNatRules();
        }

        public static interface WithIPConfiguration {
            public NicIPConfiguration.UpdateDefinitionStages.Blank<Update> defineSecondaryIPConfiguration(String var1);

            public NicIPConfiguration.Update updateIPConfiguration(String var1);
        }

        public static interface WithDnsServer {
            public Update withDnsServer(String var1);

            public Update withoutDnsServer(String var1);

            public Update withAzureDnsServer();
        }

        public static interface WithIPForwarding {
            public Update withIPForwarding();

            public Update withoutIPForwarding();
        }

        public static interface WithNetworkSecurityGroup {
            public Update withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> var1);

            public Update withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);

            public Update withoutNetworkSecurityGroup();
        }

        public static interface WithPrimaryPublicIPAddress {
            public Update withNewPrimaryPublicIPAddress(Creatable<PublicIPAddress> var1);

            public Update withNewPrimaryPublicIPAddress();

            public Update withNewPrimaryPublicIPAddress(String var1);

            public Update withoutPrimaryPublicIPAddress();

            public Update withExistingPrimaryPublicIPAddress(PublicIPAddress var1);
        }

        public static interface WithPrimaryPrivateIP {
            public Update withPrimaryPrivateIPAddressDynamic();

            public Update withPrimaryPrivateIPAddressStatic(String var1);
        }

        public static interface WithPrimaryNetworkSubnet {
            public Update withSubnet(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<NetworkInterface>,
        Resource.DefinitionWithTags<WithCreate>,
        WithPrimaryPublicIPAddress,
        WithNetworkSecurityGroup,
        WithSecondaryIPConfiguration,
        WithLoadBalancer {
            public WithCreate withIPForwarding();

            public WithCreate withDnsServer(String var1);

            public WithCreate withInternalDnsNameLabel(String var1);
        }

        public static interface WithSecondaryIPConfiguration {
            public NicIPConfiguration.DefinitionStages.Blank<WithCreate> defineSecondaryIPConfiguration(String var1);
        }

        public static interface WithNetworkSecurityGroup {
            public WithCreate withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> var1);

            public WithCreate withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);
        }

        public static interface WithPrimaryPublicIPAddress {
            public WithCreate withNewPrimaryPublicIPAddress(Creatable<PublicIPAddress> var1);

            public WithCreate withNewPrimaryPublicIPAddress();

            public WithCreate withNewPrimaryPublicIPAddress(String var1);

            public WithCreate withExistingPrimaryPublicIPAddress(PublicIPAddress var1);
        }

        public static interface WithPrimaryPrivateIP {
            public WithCreate withPrimaryPrivateIPAddressDynamic();

            public WithCreate withPrimaryPrivateIPAddressStatic(String var1);
        }

        public static interface WithPrimaryNetworkSubnet {
            public WithPrimaryPrivateIP withSubnet(String var1);
        }

        public static interface WithPrimaryNetwork {
            public WithPrimaryPrivateIP withNewPrimaryNetwork(Creatable<Network> var1);

            public WithPrimaryPrivateIP withNewPrimaryNetwork(String var1, String var2);

            public WithPrimaryPrivateIP withNewPrimaryNetwork(String var1);

            public WithPrimaryNetworkSubnet withExistingPrimaryNetwork(Network var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithPrimaryNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }

        public static interface WithLoadBalancer {
            public WithCreate withExistingLoadBalancerBackend(LoadBalancer var1, String var2);

            public WithCreate withExistingLoadBalancerInboundNatRule(LoadBalancer var1, String var2);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithPrimaryNetwork,
    DefinitionStages.WithPrimaryNetworkSubnet,
    DefinitionStages.WithPrimaryPrivateIP,
    DefinitionStages.WithCreate {
    }
}

