/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.PCFilter;
import com.microsoft.azure.management.network.PacketCapture;
import com.microsoft.azure.management.network.PacketCaptureFilter;
import com.microsoft.azure.management.network.PacketCaptureStatus;
import com.microsoft.azure.management.network.PacketCaptureStorageLocation;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.network.implementation.PCFilterImpl;
import com.microsoft.azure.management.network.implementation.PacketCaptureInner;
import com.microsoft.azure.management.network.implementation.PacketCaptureQueryStatusResultInner;
import com.microsoft.azure.management.network.implementation.PacketCaptureResultInner;
import com.microsoft.azure.management.network.implementation.PacketCaptureStatusImpl;
import com.microsoft.azure.management.network.implementation.PacketCapturesInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.ArrayList;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class PacketCaptureImpl
extends CreatableUpdatableImpl<PacketCapture, PacketCaptureResultInner, PacketCaptureImpl>
implements PacketCapture,
PacketCapture.Definition {
    private final PacketCapturesInner client;
    private final PacketCaptureInner createParameters;
    private final NetworkWatcher parent;

    PacketCaptureImpl(String name, NetworkWatcherImpl parent, PacketCaptureResultInner innerObject, PacketCapturesInner client) {
        super(name, (Object)innerObject);
        this.client = client;
        this.parent = parent;
        this.createParameters = new PacketCaptureInner();
    }

    protected Observable<PacketCaptureResultInner> getInnerAsync() {
        return this.client.getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    @Override
    public void stop() {
        this.stopAsync().await();
    }

    @Override
    public Completable stopAsync() {
        return this.client.stopAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).toCompletable();
    }

    @Override
    public PacketCaptureStatus getStatus() {
        return (PacketCaptureStatus)this.getStatusAsync().toBlocking().last();
    }

    @Override
    public Observable<PacketCaptureStatus> getStatusAsync() {
        return this.client.getStatusAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).map((Func1)new Func1<PacketCaptureQueryStatusResultInner, PacketCaptureStatus>(){

            public PacketCaptureStatus call(PacketCaptureQueryStatusResultInner inner) {
                return new PacketCaptureStatusImpl(inner);
            }
        });
    }

    @Override
    public PacketCaptureImpl withTarget(String target) {
        this.createParameters.withTarget(target);
        return this;
    }

    @Override
    public PacketCaptureImpl withExistingStorageAccount(StorageAccount storageAccount) {
        return this.withStorageAccountId(storageAccount.id());
    }

    @Override
    public PacketCaptureImpl withStorageAccountId(String storageId) {
        PacketCaptureStorageLocation storageLocation = this.createParameters.storageLocation();
        if (storageLocation == null) {
            storageLocation = new PacketCaptureStorageLocation();
        }
        this.createParameters.withStorageLocation(storageLocation.withStorageId(storageId));
        return this;
    }

    @Override
    public PacketCapture.DefinitionStages.WithCreate withStoragePath(String storagePath) {
        this.createParameters.storageLocation().withStoragePath(storagePath);
        return this;
    }

    @Override
    public PacketCaptureImpl withFilePath(String filePath) {
        PacketCaptureStorageLocation storageLocation = this.createParameters.storageLocation();
        if (storageLocation == null) {
            storageLocation = new PacketCaptureStorageLocation();
        }
        this.createParameters.withStorageLocation(storageLocation.withFilePath(filePath));
        return this;
    }

    @Override
    public PacketCaptureImpl withBytesToCapturePerPacket(int bytesToCapturePerPacket) {
        this.createParameters.withBytesToCapturePerPacket(bytesToCapturePerPacket);
        return this;
    }

    @Override
    public PacketCaptureImpl withTotalBytesPerSession(int totalBytesPerSession) {
        this.createParameters.withTotalBytesPerSession(totalBytesPerSession);
        return this;
    }

    @Override
    public PacketCaptureImpl withTimeLimitInSeconds(int timeLimitInSeconds) {
        this.createParameters.withTimeLimitInSeconds(timeLimitInSeconds);
        return this;
    }

    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> definePacketCaptureFilter() {
        return new PCFilterImpl(new PacketCaptureFilter(), this);
    }

    void attachPCFilter(PCFilterImpl pcFilter) {
        if (this.createParameters.filters() == null) {
            this.createParameters.withFilters(new ArrayList<PacketCaptureFilter>());
        }
        this.createParameters.filters().add((PacketCaptureFilter)pcFilter.inner());
    }

    public boolean isInCreateMode() {
        return ((PacketCaptureResultInner)this.inner()).id() == null;
    }

    public Observable<PacketCapture> createResourceAsync() {
        return this.client.createAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public String id() {
        return ((PacketCaptureResultInner)this.inner()).id();
    }

    @Override
    public String targetId() {
        return ((PacketCaptureResultInner)this.inner()).target();
    }

    @Override
    public int bytesToCapturePerPacket() {
        return Utils.toPrimitiveInt((Integer)((PacketCaptureResultInner)this.inner()).bytesToCapturePerPacket());
    }

    @Override
    public int totalBytesPerSession() {
        return Utils.toPrimitiveInt((Integer)((PacketCaptureResultInner)this.inner()).totalBytesPerSession());
    }

    @Override
    public int timeLimitInSeconds() {
        return Utils.toPrimitiveInt((Integer)((PacketCaptureResultInner)this.inner()).timeLimitInSeconds());
    }

    @Override
    public PacketCaptureStorageLocation storageLocation() {
        return ((PacketCaptureResultInner)this.inner()).storageLocation();
    }

    @Override
    public List<PacketCaptureFilter> filters() {
        return ((PacketCaptureResultInner)this.inner()).filters();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PacketCaptureResultInner)this.inner()).provisioningState();
    }
}

