/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in PacketCaptures.
 */
public class PacketCapturesInner {
    /** The Retrofit service to perform REST calls. */
    private PacketCapturesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of PacketCapturesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PacketCapturesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(PacketCapturesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for PacketCaptures to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PacketCapturesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Body PacketCaptureInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Body PacketCaptureInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures stop" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/stop")
        Observable<Response<ResponseBody>> stop(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginStop" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/stop")
        Observable<Response<ResponseBody>> beginStop(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures getStatus" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/queryStatus")
        Observable<Response<ResponseBody>> getStatus(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginGetStatus" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/queryStatus")
        Observable<Response<ResponseBody>> beginGetStatus(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("packetCaptureName") String packetCaptureName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("networkWatcherName") String networkWatcherName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PacketCaptureResultInner object if successful.
     */
    public PacketCaptureResultInner create(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).toBlocking().last().body();
    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PacketCaptureResultInner> createAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters, final ServiceCallback<PacketCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters), serviceCallback);
    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PacketCaptureResultInner> createAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).map(new Func1<ServiceResponse<PacketCaptureResultInner>, PacketCaptureResultInner>() {
            @Override
            public PacketCaptureResultInner call(ServiceResponse<PacketCaptureResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<PacketCaptureResultInner>> createWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PacketCaptureResultInner>() { }.getType());
    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PacketCaptureResultInner object if successful.
     */
    public PacketCaptureResultInner beginCreate(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).toBlocking().single().body();
    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PacketCaptureResultInner> beginCreateAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters, final ServiceCallback<PacketCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters), serviceCallback);
    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PacketCaptureResultInner object
     */
    public Observable<PacketCaptureResultInner> beginCreateAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).map(new Func1<ServiceResponse<PacketCaptureResultInner>, PacketCaptureResultInner>() {
            @Override
            public PacketCaptureResultInner call(ServiceResponse<PacketCaptureResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create and start a packet capture on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param parameters Parameters that define the create packet capture operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PacketCaptureResultInner object
     */
    public Observable<ServiceResponse<PacketCaptureResultInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-04-01";
        return service.beginCreate(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PacketCaptureResultInner>>>() {
                @Override
                public Observable<ServiceResponse<PacketCaptureResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PacketCaptureResultInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PacketCaptureResultInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PacketCaptureResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<PacketCaptureResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PacketCaptureResultInner object if successful.
     */
    public PacketCaptureResultInner get(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return getWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single().body();
    }

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PacketCaptureResultInner> getAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, final ServiceCallback<PacketCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PacketCaptureResultInner object
     */
    public Observable<PacketCaptureResultInner> getAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return getWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map(new Func1<ServiceResponse<PacketCaptureResultInner>, PacketCaptureResultInner>() {
            @Override
            public PacketCaptureResultInner call(ServiceResponse<PacketCaptureResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a packet capture session by name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PacketCaptureResultInner object
     */
    public Observable<ServiceResponse<PacketCaptureResultInner>> getWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        return service.get(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PacketCaptureResultInner>>>() {
                @Override
                public Observable<ServiceResponse<PacketCaptureResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PacketCaptureResultInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PacketCaptureResultInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PacketCaptureResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PacketCaptureResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().last().body();
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single().body();
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        return service.beginDelete(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void stop(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().last().body();
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> stopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> stopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> stopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = service.stop(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginStop(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single().body();
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Stops a specified packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param packetCaptureName The name of the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginStopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        return service.beginStop(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginStopDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginStopDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PacketCaptureQueryStatusResultInner object if successful.
     */
    public PacketCaptureQueryStatusResultInner getStatus(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return getStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().last().body();
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PacketCaptureQueryStatusResultInner> getStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, final ServiceCallback<PacketCaptureQueryStatusResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(getStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PacketCaptureQueryStatusResultInner> getStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return getStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map(new Func1<ServiceResponse<PacketCaptureQueryStatusResultInner>, PacketCaptureQueryStatusResultInner>() {
            @Override
            public PacketCaptureQueryStatusResultInner call(ServiceResponse<PacketCaptureQueryStatusResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>> getStatusWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = service.getStatus(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<PacketCaptureQueryStatusResultInner>() { }.getType());
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PacketCaptureQueryStatusResultInner object if successful.
     */
    public PacketCaptureQueryStatusResultInner beginGetStatus(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return beginGetStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single().body();
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PacketCaptureQueryStatusResultInner> beginGetStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, final ServiceCallback<PacketCaptureQueryStatusResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginGetStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PacketCaptureQueryStatusResultInner object
     */
    public Observable<PacketCaptureQueryStatusResultInner> beginGetStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return beginGetStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map(new Func1<ServiceResponse<PacketCaptureQueryStatusResultInner>, PacketCaptureQueryStatusResultInner>() {
            @Override
            public PacketCaptureQueryStatusResultInner call(ServiceResponse<PacketCaptureQueryStatusResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Query the status of a running packet capture session.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param packetCaptureName The name given to the packet capture session.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PacketCaptureQueryStatusResultInner object
     */
    public Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>> beginGetStatusWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        return service.beginGetStatus(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>>>() {
                @Override
                public Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PacketCaptureQueryStatusResultInner> clientResponse = beginGetStatusDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PacketCaptureQueryStatusResultInner> beginGetStatusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PacketCaptureQueryStatusResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PacketCaptureQueryStatusResultInner>() { }.getType())
                .register(202, new TypeToken<PacketCaptureQueryStatusResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all packet capture sessions within the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;PacketCaptureResultInner&gt; object if successful.
     */
    public List<PacketCaptureResultInner> list(String resourceGroupName, String networkWatcherName) {
        return listWithServiceResponseAsync(resourceGroupName, networkWatcherName).toBlocking().single().body();
    }

    /**
     * Lists all packet capture sessions within the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PacketCaptureResultInner>> listAsync(String resourceGroupName, String networkWatcherName, final ServiceCallback<List<PacketCaptureResultInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceGroupName, networkWatcherName), serviceCallback);
    }

    /**
     * Lists all packet capture sessions within the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;PacketCaptureResultInner&gt; object
     */
    public Observable<List<PacketCaptureResultInner>> listAsync(String resourceGroupName, String networkWatcherName) {
        return listWithServiceResponseAsync(resourceGroupName, networkWatcherName).map(new Func1<ServiceResponse<List<PacketCaptureResultInner>>, List<PacketCaptureResultInner>>() {
            @Override
            public List<PacketCaptureResultInner> call(ServiceResponse<List<PacketCaptureResultInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists all packet capture sessions within the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the Network Watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;PacketCaptureResultInner&gt; object
     */
    public Observable<ServiceResponse<List<PacketCaptureResultInner>>> listWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-01";
        return service.list(resourceGroupName, networkWatcherName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PacketCaptureResultInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<PacketCaptureResultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<PacketCaptureResultInner>> result = listDelegate(response);
                        List<PacketCaptureResultInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<PacketCaptureResultInner>> clientResponse = new ServiceResponse<List<PacketCaptureResultInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<PacketCaptureResultInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<PacketCaptureResultInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<PacketCaptureResultInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
