/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRouteCrossConnectionPeeringsInner {
    private ExpressRouteCrossConnectionPeeringsService service;
    private NetworkManagementClientImpl client;

    public ExpressRouteCrossConnectionPeeringsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ExpressRouteCrossConnectionPeeringsService)retrofit.create(ExpressRouteCrossConnectionPeeringsService.class);
        this.client = client;
    }

    public PagedList<ExpressRouteCrossConnectionPeeringInner> list(String resourceGroupName, String crossConnectionName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, crossConnectionName).toBlocking().single();
        return new PagedList<ExpressRouteCrossConnectionPeeringInner>((Page)response.body()){

            public Page<ExpressRouteCrossConnectionPeeringInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteCrossConnectionPeeringsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteCrossConnectionPeeringInner>> listAsync(String resourceGroupName, String crossConnectionName, ListOperationCallback<ExpressRouteCrossConnectionPeeringInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, crossConnectionName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> call(String nextPageLink) {
                return ExpressRouteCrossConnectionPeeringsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteCrossConnectionPeeringInner>> listAsync(String resourceGroupName, String crossConnectionName) {
        return this.listWithServiceResponseAsync(resourceGroupName, crossConnectionName).map((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>, Page<ExpressRouteCrossConnectionPeeringInner>>(){

            public Page<ExpressRouteCrossConnectionPeeringInner> call(ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> listWithServiceResponseAsync(String resourceGroupName, String crossConnectionName) {
        return this.listSinglePageAsync(resourceGroupName, crossConnectionName).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> call(ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteCrossConnectionPeeringsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> listSinglePageAsync(String resourceGroupName, String crossConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        return this.service.list(resourceGroupName, crossConnectionName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteCrossConnectionPeeringsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteCrossConnectionPeeringInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteCrossConnectionPeeringInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String crossConnectionName, String peeringName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String crossConnectionName, String peeringName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String crossConnectionName, String peeringName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, crossConnectionName, peeringName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String crossConnectionName, String peeringName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String crossConnectionName, String peeringName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String crossConnectionName, String peeringName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        return this.service.beginDelete(resourceGroupName, crossConnectionName, peeringName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionPeeringsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCrossConnectionPeeringInner get(String resourceGroupName, String crossConnectionName, String peeringName) {
        return (ExpressRouteCrossConnectionPeeringInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionPeeringInner> getAsync(String resourceGroupName, String crossConnectionName, String peeringName, ServiceCallback<ExpressRouteCrossConnectionPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionPeeringInner> getAsync(String resourceGroupName, String crossConnectionName, String peeringName) {
        return this.getWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>, ExpressRouteCrossConnectionPeeringInner>(){

            public ExpressRouteCrossConnectionPeeringInner call(ServiceResponse<ExpressRouteCrossConnectionPeeringInner> response) {
                return (ExpressRouteCrossConnectionPeeringInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>> getWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-01";
        return this.service.get(resourceGroupName, crossConnectionName, peeringName, this.client.subscriptionId(), "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionPeeringsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCrossConnectionPeeringInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCrossConnectionPeeringInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteCrossConnectionPeeringInner createOrUpdate(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters) {
        return (ExpressRouteCrossConnectionPeeringInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, peeringParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionPeeringInner> createOrUpdateAsync(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters, ServiceCallback<ExpressRouteCrossConnectionPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, peeringParameters), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionPeeringInner> createOrUpdateAsync(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, peeringParameters).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>, ExpressRouteCrossConnectionPeeringInner>(){

            public ExpressRouteCrossConnectionPeeringInner call(ServiceResponse<ExpressRouteCrossConnectionPeeringInner> response) {
                return (ExpressRouteCrossConnectionPeeringInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (peeringParameters == null) {
            throw new IllegalArgumentException("Parameter peeringParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)peeringParameters));
        String apiVersion = "2018-04-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, crossConnectionName, peeringName, this.client.subscriptionId(), peeringParameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRouteCrossConnectionPeeringInner>(){}.getType());
    }

    public ExpressRouteCrossConnectionPeeringInner beginCreateOrUpdate(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters) {
        return (ExpressRouteCrossConnectionPeeringInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, peeringParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteCrossConnectionPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters, ServiceCallback<ExpressRouteCrossConnectionPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, peeringParameters), serviceCallback);
    }

    public Observable<ExpressRouteCrossConnectionPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, crossConnectionName, peeringName, peeringParameters).map((Func1)new Func1<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>, ExpressRouteCrossConnectionPeeringInner>(){

            public ExpressRouteCrossConnectionPeeringInner call(ServiceResponse<ExpressRouteCrossConnectionPeeringInner> response) {
                return (ExpressRouteCrossConnectionPeeringInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String crossConnectionName, String peeringName, ExpressRouteCrossConnectionPeeringInner peeringParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (crossConnectionName == null) {
            throw new IllegalArgumentException("Parameter crossConnectionName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (peeringParameters == null) {
            throw new IllegalArgumentException("Parameter peeringParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)peeringParameters));
        String apiVersion = "2018-04-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, crossConnectionName, peeringName, this.client.subscriptionId(), peeringParameters, "2018-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>>>(){

            public Observable<ServiceResponse<ExpressRouteCrossConnectionPeeringInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteCrossConnectionPeeringsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteCrossConnectionPeeringInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteCrossConnectionPeeringInner>(){}.getType()).register(201, new TypeToken<ExpressRouteCrossConnectionPeeringInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRouteCrossConnectionPeeringInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExpressRouteCrossConnectionPeeringInner>((Page)response.body()){

            public Page<ExpressRouteCrossConnectionPeeringInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRouteCrossConnectionPeeringsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRouteCrossConnectionPeeringInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ExpressRouteCrossConnectionPeeringInner>> serviceFuture, ListOperationCallback<ExpressRouteCrossConnectionPeeringInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> call(String nextPageLink) {
                return ExpressRouteCrossConnectionPeeringsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRouteCrossConnectionPeeringInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>, Page<ExpressRouteCrossConnectionPeeringInner>>(){

            public Page<ExpressRouteCrossConnectionPeeringInner> call(ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> call(ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRouteCrossConnectionPeeringsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRouteCrossConnectionPeeringInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteCrossConnectionPeeringsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRouteCrossConnectionPeeringInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRouteCrossConnectionPeeringInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExpressRouteCrossConnectionPeeringsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Body ExpressRouteCrossConnectionPeeringInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="crossConnectionName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Body ExpressRouteCrossConnectionPeeringInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

