/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in AzureFirewalls.
 */
public class AzureFirewallsInner implements InnerSupportsGet<AzureFirewallInner>, InnerSupportsDelete<Void>, InnerSupportsListing<AzureFirewallInner> {
    /** The Retrofit service to perform REST calls. */
    private AzureFirewallsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of AzureFirewallsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public AzureFirewallsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(AzureFirewallsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureFirewalls to be
     * used by Retrofit to perform actually REST calls.
     */
    interface AzureFirewallsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls/{azureFirewallName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("azureFirewallName") String azureFirewallName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls/{azureFirewallName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("azureFirewallName") String azureFirewallName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls/{azureFirewallName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("azureFirewallName") String azureFirewallName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls/{azureFirewallName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("azureFirewallName") String azureFirewallName, @Path("subscriptionId") String subscriptionId, @Body AzureFirewallInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls/{azureFirewallName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("azureFirewallName") String azureFirewallName, @Path("subscriptionId") String subscriptionId, @Body AzureFirewallInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/azureFirewalls")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AzureFirewalls listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String azureFirewallName) {
        deleteWithServiceResponseAsync(resourceGroupName, azureFirewallName).toBlocking().last().body();
    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String azureFirewallName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, azureFirewallName), serviceCallback);
    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String azureFirewallName) {
        return deleteWithServiceResponseAsync(resourceGroupName, azureFirewallName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String azureFirewallName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (azureFirewallName == null) {
            throw new IllegalArgumentException("Parameter azureFirewallName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, azureFirewallName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String azureFirewallName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, azureFirewallName).toBlocking().single().body();
    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String azureFirewallName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, azureFirewallName), serviceCallback);
    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String azureFirewallName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, azureFirewallName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String azureFirewallName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (azureFirewallName == null) {
            throw new IllegalArgumentException("Parameter azureFirewallName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.beginDelete(resourceGroupName, azureFirewallName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AzureFirewallInner object if successful.
     */
    public AzureFirewallInner getByResourceGroup(String resourceGroupName, String azureFirewallName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, azureFirewallName).toBlocking().single().body();
    }

    /**
     * Gets the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AzureFirewallInner> getByResourceGroupAsync(String resourceGroupName, String azureFirewallName, final ServiceCallback<AzureFirewallInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, azureFirewallName), serviceCallback);
    }

    /**
     * Gets the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureFirewallInner object
     */
    public Observable<AzureFirewallInner> getByResourceGroupAsync(String resourceGroupName, String azureFirewallName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, azureFirewallName).map(new Func1<ServiceResponse<AzureFirewallInner>, AzureFirewallInner>() {
            @Override
            public AzureFirewallInner call(ServiceResponse<AzureFirewallInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureFirewallInner object
     */
    public Observable<ServiceResponse<AzureFirewallInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String azureFirewallName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (azureFirewallName == null) {
            throw new IllegalArgumentException("Parameter azureFirewallName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.getByResourceGroup(resourceGroupName, azureFirewallName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AzureFirewallInner>>>() {
                @Override
                public Observable<ServiceResponse<AzureFirewallInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AzureFirewallInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AzureFirewallInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AzureFirewallInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AzureFirewallInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AzureFirewallInner object if successful.
     */
    public AzureFirewallInner createOrUpdate(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, azureFirewallName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AzureFirewallInner> createOrUpdateAsync(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters, final ServiceCallback<AzureFirewallInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, azureFirewallName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AzureFirewallInner> createOrUpdateAsync(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, azureFirewallName, parameters).map(new Func1<ServiceResponse<AzureFirewallInner>, AzureFirewallInner>() {
            @Override
            public AzureFirewallInner call(ServiceResponse<AzureFirewallInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AzureFirewallInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (azureFirewallName == null) {
            throw new IllegalArgumentException("Parameter azureFirewallName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, azureFirewallName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AzureFirewallInner>() { }.getType());
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AzureFirewallInner object if successful.
     */
    public AzureFirewallInner beginCreateOrUpdate(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, azureFirewallName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AzureFirewallInner> beginCreateOrUpdateAsync(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters, final ServiceCallback<AzureFirewallInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, azureFirewallName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureFirewallInner object
     */
    public Observable<AzureFirewallInner> beginCreateOrUpdateAsync(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, azureFirewallName, parameters).map(new Func1<ServiceResponse<AzureFirewallInner>, AzureFirewallInner>() {
            @Override
            public AzureFirewallInner call(ServiceResponse<AzureFirewallInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Azure Firewall.
     *
     * @param resourceGroupName The name of the resource group.
     * @param azureFirewallName The name of the Azure Firewall.
     * @param parameters Parameters supplied to the create or update Azure Firewall operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureFirewallInner object
     */
    public Observable<ServiceResponse<AzureFirewallInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String azureFirewallName, AzureFirewallInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (azureFirewallName == null) {
            throw new IllegalArgumentException("Parameter azureFirewallName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-06-01";
        return service.beginCreateOrUpdate(resourceGroupName, azureFirewallName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AzureFirewallInner>>>() {
                @Override
                public Observable<ServiceResponse<AzureFirewallInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AzureFirewallInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AzureFirewallInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AzureFirewallInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AzureFirewallInner>() { }.getType())
                .register(201, new TypeToken<AzureFirewallInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AzureFirewallInner&gt; object if successful.
     */
    public PagedList<AzureFirewallInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<AzureFirewallInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<AzureFirewallInner>(response.body()) {
            @Override
            public Page<AzureFirewallInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AzureFirewallInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<AzureFirewallInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<Page<AzureFirewallInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Page<AzureFirewallInner>>() {
                @Override
                public Page<AzureFirewallInner> call(ServiceResponse<Page<AzureFirewallInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(ServiceResponse<Page<AzureFirewallInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
    ServiceResponse<PageImpl<AzureFirewallInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AzureFirewallInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AzureFirewallInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AzureFirewallInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AzureFirewallInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AzureFirewallInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AzureFirewallInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AzureFirewallInner&gt; object if successful.
     */
    public PagedList<AzureFirewallInner> list() {
        ServiceResponse<Page<AzureFirewallInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<AzureFirewallInner>(response.body()) {
            @Override
            public Page<AzureFirewallInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AzureFirewallInner>> listAsync(final ListOperationCallback<AzureFirewallInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<Page<AzureFirewallInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Page<AzureFirewallInner>>() {
                @Override
                public Page<AzureFirewallInner> call(ServiceResponse<Page<AzureFirewallInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(ServiceResponse<Page<AzureFirewallInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AzureFirewallInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AzureFirewallInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AzureFirewallInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AzureFirewallInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AzureFirewallInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AzureFirewallInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AzureFirewallInner&gt; object if successful.
     */
    public PagedList<AzureFirewallInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<AzureFirewallInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AzureFirewallInner>(response.body()) {
            @Override
            public Page<AzureFirewallInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AzureFirewallInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<AzureFirewallInner>> serviceFuture, final ListOperationCallback<AzureFirewallInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<Page<AzureFirewallInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Page<AzureFirewallInner>>() {
                @Override
                public Page<AzureFirewallInner> call(ServiceResponse<Page<AzureFirewallInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(ServiceResponse<Page<AzureFirewallInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Azure Firewalls in a resource group.
     *
    ServiceResponse<PageImpl<AzureFirewallInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AzureFirewallInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AzureFirewallInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AzureFirewallInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AzureFirewallInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AzureFirewallInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AzureFirewallInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AzureFirewallInner&gt; object if successful.
     */
    public PagedList<AzureFirewallInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<AzureFirewallInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AzureFirewallInner>(response.body()) {
            @Override
            public Page<AzureFirewallInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AzureFirewallInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<AzureFirewallInner>> serviceFuture, final ListOperationCallback<AzureFirewallInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<Page<AzureFirewallInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Page<AzureFirewallInner>>() {
                @Override
                public Page<AzureFirewallInner> call(ServiceResponse<Page<AzureFirewallInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AzureFirewallInner&gt; object
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AzureFirewallInner>>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(ServiceResponse<Page<AzureFirewallInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the Azure Firewalls in a subscription.
     *
    ServiceResponse<PageImpl<AzureFirewallInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AzureFirewallInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AzureFirewallInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AzureFirewallInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AzureFirewallInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AzureFirewallInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AzureFirewallInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AzureFirewallInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AzureFirewallInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AzureFirewallInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
