/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters that determine how the connectivity check will be performed.
 */
public class ConnectivityParameters {
    /**
     * The source property.
     */
    @JsonProperty(value = "source", required = true)
    private ConnectivitySource source;

    /**
     * The destination property.
     */
    @JsonProperty(value = "destination", required = true)
    private ConnectivityDestination destination;

    /**
     * Network protocol. Possible values include: 'Tcp', 'Http', 'Https',
     * 'Icmp'.
     */
    @JsonProperty(value = "protocol")
    private Protocol protocol;

    /**
     * The protocolConfiguration property.
     */
    @JsonProperty(value = "protocolConfiguration")
    private ProtocolConfiguration protocolConfiguration;

    /**
     * Get the source value.
     *
     * @return the source value
     */
    public ConnectivitySource source() {
        return this.source;
    }

    /**
     * Set the source value.
     *
     * @param source the source value to set
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withSource(ConnectivitySource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the destination value.
     *
     * @return the destination value
     */
    public ConnectivityDestination destination() {
        return this.destination;
    }

    /**
     * Set the destination value.
     *
     * @param destination the destination value to set
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withDestination(ConnectivityDestination destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get the protocol value.
     *
     * @return the protocol value
     */
    public Protocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol value.
     *
     * @param protocol the protocol value to set
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the protocolConfiguration value.
     *
     * @return the protocolConfiguration value
     */
    public ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    /**
     * Set the protocolConfiguration value.
     *
     * @param protocolConfiguration the protocolConfiguration value to set
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withProtocolConfiguration(ProtocolConfiguration protocolConfiguration) {
        this.protocolConfiguration = protocolConfiguration;
        return this;
    }

}
