/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.Topology;
import com.microsoft.azure.management.network.TopologyParameters;
import com.microsoft.azure.management.network.TopologyResource;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.network.implementation.TopologyInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.ExecutableImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TopologyImpl
extends ExecutableImpl<Topology>
implements Topology,
Topology.Definition {
    private Map<String, TopologyResource> resources;
    private final NetworkWatcherImpl parent;
    private TopologyParameters parameters = new TopologyParameters();
    private TopologyInner inner;

    TopologyImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public String id() {
        return this.inner().id();
    }

    @Override
    public TopologyParameters topologyParameters() {
        return this.parameters;
    }

    @Override
    public DateTime createdTime() {
        return this.inner().createdDateTime();
    }

    @Override
    public DateTime lastModifiedTime() {
        return this.inner().lastModified();
    }

    @Override
    public Map<String, TopologyResource> resources() {
        return Collections.unmodifiableMap(this.resources);
    }

    private void initializeResourcesFromInner() {
        this.resources = new TreeMap<String, TopologyResource>();
        List<TopologyResource> topologyResources = this.inner().resources();
        if (topologyResources != null) {
            for (TopologyResource resource : topologyResources) {
                this.resources.put(resource.id(), resource);
            }
        }
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    @Override
    public TopologyImpl withTargetResourceGroup(String resourceGroupName) {
        this.parameters.withTargetResourceGroupName(resourceGroupName);
        return this;
    }

    @Override
    public TopologyImpl withTargetNetwork(String networkId) {
        this.parameters.withTargetVirtualNetwork(new SubResource().withId(networkId));
        return this;
    }

    @Override
    public TopologyImpl withTargetSubnet(String subnetName) {
        this.parameters.withTargetSubnet(new SubResource().withId(this.parameters.targetVirtualNetwork().id() + "/subnets/" + subnetName));
        return this;
    }

    public TopologyInner inner() {
        return this.inner;
    }

    public Observable<Topology> executeWorkAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)this.parent().manager())).inner())).networkWatchers().getTopologyAsync(this.parent().resourceGroupName(), this.parent().name(), this.parameters).map((Func1)new Func1<TopologyInner, Topology>(){

            public Topology call(TopologyInner topologyInner) {
                TopologyImpl.this.inner = topologyInner;
                TopologyImpl.this.initializeResourcesFromInner();
                return TopologyImpl.this;
            }
        });
    }
}

