/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.DdosProtectionPlanInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DdosProtectionPlansInner
implements InnerSupportsGet<DdosProtectionPlanInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DdosProtectionPlanInner> {
    private DdosProtectionPlansService service;
    private NetworkManagementClientImpl client;

    public DdosProtectionPlansInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (DdosProtectionPlansService)retrofit.create(DdosProtectionPlansService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String ddosProtectionPlanName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ddosProtectionPlanName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String ddosProtectionPlanName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String ddosProtectionPlanName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String ddosProtectionPlanName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String ddosProtectionPlanName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosProtectionPlansInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DdosProtectionPlanInner getByResourceGroup(String resourceGroupName, String ddosProtectionPlanName) {
        return (DdosProtectionPlanInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).toBlocking().single()).body());
    }

    public ServiceFuture<DdosProtectionPlanInner> getByResourceGroupAsync(String resourceGroupName, String ddosProtectionPlanName, ServiceCallback<DdosProtectionPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName), serviceCallback);
    }

    public Observable<DdosProtectionPlanInner> getByResourceGroupAsync(String resourceGroupName, String ddosProtectionPlanName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).map((Func1)new Func1<ServiceResponse<DdosProtectionPlanInner>, DdosProtectionPlanInner>(){

            public DdosProtectionPlanInner call(ServiceResponse<DdosProtectionPlanInner> response) {
                return (DdosProtectionPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosProtectionPlanInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosProtectionPlanInner>>>(){

            public Observable<ServiceResponse<DdosProtectionPlanInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosProtectionPlansInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DdosProtectionPlanInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DdosProtectionPlanInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DdosProtectionPlanInner createOrUpdate(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters) {
        return (DdosProtectionPlanInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DdosProtectionPlanInner> createOrUpdateAsync(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters, ServiceCallback<DdosProtectionPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, parameters), serviceCallback);
    }

    public Observable<DdosProtectionPlanInner> createOrUpdateAsync(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, parameters).map((Func1)new Func1<ServiceResponse<DdosProtectionPlanInner>, DdosProtectionPlanInner>(){

            public DdosProtectionPlanInner call(ServiceResponse<DdosProtectionPlanInner> response) {
                return (DdosProtectionPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosProtectionPlanInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DdosProtectionPlanInner>(){}.getType());
    }

    public DdosProtectionPlanInner beginCreateOrUpdate(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters) {
        return (DdosProtectionPlanInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DdosProtectionPlanInner> beginCreateOrUpdateAsync(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters, ServiceCallback<DdosProtectionPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, parameters), serviceCallback);
    }

    public Observable<DdosProtectionPlanInner> beginCreateOrUpdateAsync(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, parameters).map((Func1)new Func1<ServiceResponse<DdosProtectionPlanInner>, DdosProtectionPlanInner>(){

            public DdosProtectionPlanInner call(ServiceResponse<DdosProtectionPlanInner> response) {
                return (DdosProtectionPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosProtectionPlanInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName, DdosProtectionPlanInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosProtectionPlanInner>>>(){

            public Observable<ServiceResponse<DdosProtectionPlanInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosProtectionPlansInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DdosProtectionPlanInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DdosProtectionPlanInner>(){}.getType()).register(201, new TypeToken<DdosProtectionPlanInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DdosProtectionPlanInner updateTags(String resourceGroupName, String ddosProtectionPlanName) {
        return (DdosProtectionPlanInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).toBlocking().last()).body());
    }

    public ServiceFuture<DdosProtectionPlanInner> updateTagsAsync(String resourceGroupName, String ddosProtectionPlanName, ServiceCallback<DdosProtectionPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName), serviceCallback);
    }

    public Observable<DdosProtectionPlanInner> updateTagsAsync(String resourceGroupName, String ddosProtectionPlanName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).map((Func1)new Func1<ServiceResponse<DdosProtectionPlanInner>, DdosProtectionPlanInner>(){

            public DdosProtectionPlanInner call(ServiceResponse<DdosProtectionPlanInner> response) {
                return (DdosProtectionPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosProtectionPlanInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DdosProtectionPlanInner>(){}.getType());
    }

    public DdosProtectionPlanInner updateTags(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags) {
        return (DdosProtectionPlanInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<DdosProtectionPlanInner> updateTagsAsync(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags, ServiceCallback<DdosProtectionPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, tags), serviceCallback);
    }

    public Observable<DdosProtectionPlanInner> updateTagsAsync(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, tags).map((Func1)new Func1<ServiceResponse<DdosProtectionPlanInner>, DdosProtectionPlanInner>(){

            public DdosProtectionPlanInner call(ServiceResponse<DdosProtectionPlanInner> response) {
                return (DdosProtectionPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosProtectionPlanInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DdosProtectionPlanInner>(){}.getType());
    }

    public DdosProtectionPlanInner beginUpdateTags(String resourceGroupName, String ddosProtectionPlanName) {
        return (DdosProtectionPlanInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).toBlocking().single()).body());
    }

    public ServiceFuture<DdosProtectionPlanInner> beginUpdateTagsAsync(String resourceGroupName, String ddosProtectionPlanName, ServiceCallback<DdosProtectionPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName), serviceCallback);
    }

    public Observable<DdosProtectionPlanInner> beginUpdateTagsAsync(String resourceGroupName, String ddosProtectionPlanName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName).map((Func1)new Func1<ServiceResponse<DdosProtectionPlanInner>, DdosProtectionPlanInner>(){

            public DdosProtectionPlanInner call(ServiceResponse<DdosProtectionPlanInner> response) {
                return (DdosProtectionPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosProtectionPlanInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdateTags(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosProtectionPlanInner>>>(){

            public Observable<ServiceResponse<DdosProtectionPlanInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosProtectionPlansInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DdosProtectionPlanInner beginUpdateTags(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags) {
        return (DdosProtectionPlanInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<DdosProtectionPlanInner> beginUpdateTagsAsync(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags, ServiceCallback<DdosProtectionPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, tags), serviceCallback);
    }

    public Observable<DdosProtectionPlanInner> beginUpdateTagsAsync(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosProtectionPlanName, tags).map((Func1)new Func1<ServiceResponse<DdosProtectionPlanInner>, DdosProtectionPlanInner>(){

            public DdosProtectionPlanInner call(ServiceResponse<DdosProtectionPlanInner> response) {
                return (DdosProtectionPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosProtectionPlanInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String ddosProtectionPlanName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosProtectionPlanName == null) {
            throw new IllegalArgumentException("Parameter ddosProtectionPlanName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdateTags(resourceGroupName, ddosProtectionPlanName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosProtectionPlanInner>>>(){

            public Observable<ServiceResponse<DdosProtectionPlanInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosProtectionPlansInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DdosProtectionPlanInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DdosProtectionPlanInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DdosProtectionPlanInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DdosProtectionPlanInner>((Page)response.body()){

            public Page<DdosProtectionPlanInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DdosProtectionPlansInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DdosProtectionPlanInner>> listAsync(ListOperationCallback<DdosProtectionPlanInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(String nextPageLink) {
                return DdosProtectionPlansInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DdosProtectionPlanInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Page<DdosProtectionPlanInner>>(){

            public Page<DdosProtectionPlanInner> call(ServiceResponse<Page<DdosProtectionPlanInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(ServiceResponse<Page<DdosProtectionPlanInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DdosProtectionPlansInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DdosProtectionPlansInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DdosProtectionPlanInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DdosProtectionPlanInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DdosProtectionPlanInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DdosProtectionPlanInner>((Page)response.body()){

            public Page<DdosProtectionPlanInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DdosProtectionPlansInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DdosProtectionPlanInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DdosProtectionPlanInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(String nextPageLink) {
                return DdosProtectionPlansInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DdosProtectionPlanInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Page<DdosProtectionPlanInner>>(){

            public Page<DdosProtectionPlanInner> call(ServiceResponse<Page<DdosProtectionPlanInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(ServiceResponse<Page<DdosProtectionPlanInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DdosProtectionPlansInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DdosProtectionPlansInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DdosProtectionPlanInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DdosProtectionPlanInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DdosProtectionPlanInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DdosProtectionPlanInner>((Page)response.body()){

            public Page<DdosProtectionPlanInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DdosProtectionPlansInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DdosProtectionPlanInner>> listNextAsync(String nextPageLink, ServiceFuture<List<DdosProtectionPlanInner>> serviceFuture, ListOperationCallback<DdosProtectionPlanInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(String nextPageLink) {
                return DdosProtectionPlansInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DdosProtectionPlanInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Page<DdosProtectionPlanInner>>(){

            public Page<DdosProtectionPlanInner> call(ServiceResponse<Page<DdosProtectionPlanInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(ServiceResponse<Page<DdosProtectionPlanInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DdosProtectionPlansInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DdosProtectionPlansInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DdosProtectionPlanInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DdosProtectionPlanInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DdosProtectionPlanInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DdosProtectionPlanInner>((Page)response.body()){

            public Page<DdosProtectionPlanInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DdosProtectionPlansInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DdosProtectionPlanInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DdosProtectionPlanInner>> serviceFuture, ListOperationCallback<DdosProtectionPlanInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(String nextPageLink) {
                return DdosProtectionPlansInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DdosProtectionPlanInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Page<DdosProtectionPlanInner>>(){

            public Page<DdosProtectionPlanInner> call(ServiceResponse<Page<DdosProtectionPlanInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DdosProtectionPlanInner>>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(ServiceResponse<Page<DdosProtectionPlanInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DdosProtectionPlansInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DdosProtectionPlanInner>>>>(){

            public Observable<ServiceResponse<Page<DdosProtectionPlanInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DdosProtectionPlansInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DdosProtectionPlanInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DdosProtectionPlanInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DdosProtectionPlansService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="ddosProtectionPlanName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="ddosProtectionPlanName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="ddosProtectionPlanName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="ddosProtectionPlanName") String var2, @Path(value="subscriptionId") String var3, @Body DdosProtectionPlanInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="ddosProtectionPlanName") String var2, @Path(value="subscriptionId") String var3, @Body DdosProtectionPlanInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="ddosProtectionPlanName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="resourceGroupName") String var1, @Path(value="ddosProtectionPlanName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/ddosProtectionPlans")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosProtectionPlans listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

