/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.WebApplicationFirewallPolicyInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class WebApplicationFirewallPoliciesInner
implements InnerSupportsGet<WebApplicationFirewallPolicyInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<WebApplicationFirewallPolicyInner> {
    private WebApplicationFirewallPoliciesService service;
    private NetworkManagementClientImpl client;

    public WebApplicationFirewallPoliciesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (WebApplicationFirewallPoliciesService)retrofit.create(WebApplicationFirewallPoliciesService.class);
        this.client = client;
    }

    public PagedList<WebApplicationFirewallPolicyInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>((Page)response.body()){

            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebApplicationFirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                return WebApplicationFirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebApplicationFirewallPolicyInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>(){

            public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebApplicationFirewallPoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebApplicationFirewallPoliciesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebApplicationFirewallPolicyInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>((Page)response.body()){

            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebApplicationFirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listAsync(ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                return WebApplicationFirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebApplicationFirewallPolicyInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>(){

            public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebApplicationFirewallPoliciesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebApplicationFirewallPoliciesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WebApplicationFirewallPolicyInner getByResourceGroup(String resourceGroupName, String policyName) {
        return (WebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single()).body());
    }

    public ServiceFuture<WebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName, ServiceCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    public Observable<WebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).map((Func1)new Func1<ServiceResponse<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner>(){

            public WebApplicationFirewallPolicyInner call(ServiceResponse<WebApplicationFirewallPolicyInner> response) {
                return (WebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, policyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebApplicationFirewallPolicyInner>>>(){

            public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebApplicationFirewallPoliciesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebApplicationFirewallPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebApplicationFirewallPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WebApplicationFirewallPolicyInner createOrUpdate(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        return (WebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<WebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters, ServiceCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, parameters), serviceCallback);
    }

    public Observable<WebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, parameters).map((Func1)new Func1<ServiceResponse<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner>(){

            public WebApplicationFirewallPolicyInner call(ServiceResponse<WebApplicationFirewallPolicyInner> response) {
                return (WebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        return this.service.createOrUpdate(resourceGroupName, policyName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebApplicationFirewallPolicyInner>>>(){

            public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebApplicationFirewallPoliciesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebApplicationFirewallPolicyInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebApplicationFirewallPolicyInner>(){}.getType()).register(201, new TypeToken<WebApplicationFirewallPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String policyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String policyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String policyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, policyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, policyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String policyName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String policyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String policyName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, policyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, policyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebApplicationFirewallPoliciesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebApplicationFirewallPolicyInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>((Page)response.body()){

            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebApplicationFirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<WebApplicationFirewallPolicyInner>> serviceFuture, ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                return WebApplicationFirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>(){

            public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebApplicationFirewallPoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebApplicationFirewallPoliciesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebApplicationFirewallPolicyInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>((Page)response.body()){

            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebApplicationFirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listNextAsync(String nextPageLink, ServiceFuture<List<WebApplicationFirewallPolicyInner>> serviceFuture, ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                return WebApplicationFirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebApplicationFirewallPolicyInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>(){

            public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebApplicationFirewallPoliciesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebApplicationFirewallPoliciesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface WebApplicationFirewallPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Body WebApplicationFirewallPolicyInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

