/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ApplicationGatewayOperationalState.
 */
public final class ApplicationGatewayOperationalState {
    /** Static value Stopped for ApplicationGatewayOperationalState. */
    public static final ApplicationGatewayOperationalState STOPPED = new ApplicationGatewayOperationalState("Stopped");

    /** Static value Starting for ApplicationGatewayOperationalState. */
    public static final ApplicationGatewayOperationalState STARTING = new ApplicationGatewayOperationalState("Starting");

    /** Static value Running for ApplicationGatewayOperationalState. */
    public static final ApplicationGatewayOperationalState RUNNING = new ApplicationGatewayOperationalState("Running");

    /** Static value Stopping for ApplicationGatewayOperationalState. */
    public static final ApplicationGatewayOperationalState STOPPING = new ApplicationGatewayOperationalState("Stopping");

    private String value;

    /**
     * Creates a custom value for ApplicationGatewayOperationalState.
     * @param value the custom value
     */
    public ApplicationGatewayOperationalState(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationGatewayOperationalState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ApplicationGatewayOperationalState rhs = (ApplicationGatewayOperationalState) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
