/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ApplicationGatewaySkuName.
 */
public final class ApplicationGatewaySkuName {
    /** Static value Standard_Small for ApplicationGatewaySkuName. */
    public static final ApplicationGatewaySkuName STANDARD_SMALL = new ApplicationGatewaySkuName("Standard_Small");

    /** Static value Standard_Medium for ApplicationGatewaySkuName. */
    public static final ApplicationGatewaySkuName STANDARD_MEDIUM = new ApplicationGatewaySkuName("Standard_Medium");

    /** Static value Standard_Large for ApplicationGatewaySkuName. */
    public static final ApplicationGatewaySkuName STANDARD_LARGE = new ApplicationGatewaySkuName("Standard_Large");

    /** Static value WAF_Medium for ApplicationGatewaySkuName. */
    public static final ApplicationGatewaySkuName WAF_MEDIUM = new ApplicationGatewaySkuName("WAF_Medium");

    /** Static value WAF_Large for ApplicationGatewaySkuName. */
    public static final ApplicationGatewaySkuName WAF_LARGE = new ApplicationGatewaySkuName("WAF_Large");

    private String value;

    /**
     * Creates a custom value for ApplicationGatewaySkuName.
     * @param value the custom value
     */
    public ApplicationGatewaySkuName(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ApplicationGatewaySkuName)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ApplicationGatewaySkuName rhs = (ApplicationGatewaySkuName) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
