/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ConnectionStatus.
 */
public final class ConnectionStatus {
    /** Static value Unknown for ConnectionStatus. */
    public static final ConnectionStatus UNKNOWN = new ConnectionStatus("Unknown");

    /** Static value Connected for ConnectionStatus. */
    public static final ConnectionStatus CONNECTED = new ConnectionStatus("Connected");

    /** Static value Disconnected for ConnectionStatus. */
    public static final ConnectionStatus DISCONNECTED = new ConnectionStatus("Disconnected");

    /** Static value Degraded for ConnectionStatus. */
    public static final ConnectionStatus DEGRADED = new ConnectionStatus("Degraded");

    private String value;

    /**
     * Creates a custom value for ConnectionStatus.
     * @param value the custom value
     */
    public ConnectionStatus(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ConnectionStatus)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ConnectionStatus rhs = (ConnectionStatus) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
