/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for Origin.
 */
public final class Origin {
    /** Static value Local for Origin. */
    public static final Origin LOCAL = new Origin("Local");

    /** Static value Inbound for Origin. */
    public static final Origin INBOUND = new Origin("Inbound");

    /** Static value Outbound for Origin. */
    public static final Origin OUTBOUND = new Origin("Outbound");

    private String value;

    /**
     * Creates a custom value for Origin.
     * @param value the custom value
     */
    public Origin(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Origin)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Origin rhs = (Origin) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
