/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PcProtocol.
 */
public final class PcProtocol {
    /** Static value TCP for PcProtocol. */
    public static final PcProtocol TCP = new PcProtocol("TCP");

    /** Static value UDP for PcProtocol. */
    public static final PcProtocol UDP = new PcProtocol("UDP");

    /** Static value Any for PcProtocol. */
    public static final PcProtocol ANY = new PcProtocol("Any");

    private String value;

    /**
     * Creates a custom value for PcProtocol.
     * @param value the custom value
     */
    public PcProtocol(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PcProtocol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PcProtocol rhs = (PcProtocol) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
