/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PfsGroup.
 */
public final class PfsGroup {
    /** Static value None for PfsGroup. */
    public static final PfsGroup NONE = new PfsGroup("None");

    /** Static value PFS1 for PfsGroup. */
    public static final PfsGroup PFS1 = new PfsGroup("PFS1");

    /** Static value PFS2 for PfsGroup. */
    public static final PfsGroup PFS2 = new PfsGroup("PFS2");

    /** Static value PFS2048 for PfsGroup. */
    public static final PfsGroup PFS2048 = new PfsGroup("PFS2048");

    /** Static value ECP256 for PfsGroup. */
    public static final PfsGroup ECP256 = new PfsGroup("ECP256");

    /** Static value ECP384 for PfsGroup. */
    public static final PfsGroup ECP384 = new PfsGroup("ECP384");

    /** Static value PFS24 for PfsGroup. */
    public static final PfsGroup PFS24 = new PfsGroup("PFS24");

    private String value;

    /**
     * Creates a custom value for PfsGroup.
     * @param value the custom value
     */
    public PfsGroup(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PfsGroup)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PfsGroup rhs = (PfsGroup) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
