/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import java.util.List;
import com.microsoft.azure.management.network.ApplicationGatewayFirewallRuleGroup;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * A web application firewall rule set.
 */
@JsonFlatten
public class ApplicationGatewayFirewallRuleSetInner extends Resource {
    /**
     * The provisioning state of the web application firewall rule set.
     */
    @JsonProperty(value = "properties.provisioningState")
    private String provisioningState;

    /**
     * The type of the web application firewall rule set.
     */
    @JsonProperty(value = "properties.ruleSetType", required = true)
    private String ruleSetType;

    /**
     * The version of the web application firewall rule set type.
     */
    @JsonProperty(value = "properties.ruleSetVersion", required = true)
    private String ruleSetVersion;

    /**
     * The rule groups of the web application firewall rule set.
     */
    @JsonProperty(value = "properties.ruleGroups", required = true)
    private List<ApplicationGatewayFirewallRuleGroup> ruleGroups;

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState value.
     *
     * @param provisioningState the provisioningState value to set
     * @return the ApplicationGatewayFirewallRuleSetInner object itself.
     */
    public ApplicationGatewayFirewallRuleSetInner withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the ruleSetType value.
     *
     * @return the ruleSetType value
     */
    public String ruleSetType() {
        return this.ruleSetType;
    }

    /**
     * Set the ruleSetType value.
     *
     * @param ruleSetType the ruleSetType value to set
     * @return the ApplicationGatewayFirewallRuleSetInner object itself.
     */
    public ApplicationGatewayFirewallRuleSetInner withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    /**
     * Get the ruleSetVersion value.
     *
     * @return the ruleSetVersion value
     */
    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    /**
     * Set the ruleSetVersion value.
     *
     * @param ruleSetVersion the ruleSetVersion value to set
     * @return the ApplicationGatewayFirewallRuleSetInner object itself.
     */
    public ApplicationGatewayFirewallRuleSetInner withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    /**
     * Get the ruleGroups value.
     *
     * @return the ruleGroups value
     */
    public List<ApplicationGatewayFirewallRuleGroup> ruleGroups() {
        return this.ruleGroups;
    }

    /**
     * Set the ruleGroups value.
     *
     * @param ruleGroups the ruleGroups value to set
     * @return the ApplicationGatewayFirewallRuleSetInner object itself.
     */
    public ApplicationGatewayFirewallRuleSetInner withRuleGroups(List<ApplicationGatewayFirewallRuleGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

}
