/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.network.ConnectivitySource;
import com.microsoft.azure.management.network.ConnectivityDestination;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters that determine how the connectivity check will be performed.
 */
public class ConnectivityParametersInner {
    /**
     * The source property.
     */
    @JsonProperty(value = "source", required = true)
    private ConnectivitySource source;

    /**
     * The destination property.
     */
    @JsonProperty(value = "destination", required = true)
    private ConnectivityDestination destination;

    /**
     * Get the source value.
     *
     * @return the source value
     */
    public ConnectivitySource source() {
        return this.source;
    }

    /**
     * Set the source value.
     *
     * @param source the source value to set
     * @return the ConnectivityParametersInner object itself.
     */
    public ConnectivityParametersInner withSource(ConnectivitySource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the destination value.
     *
     * @return the destination value
     */
    public ConnectivityDestination destination() {
        return this.destination;
    }

    /**
     * Set the destination value.
     *
     * @param destination the destination value to set
     * @return the ConnectivityParametersInner object itself.
     */
    public ConnectivityParametersInner withDestination(ConnectivityDestination destination) {
        this.destination = destination;
        return this;
    }

}
