/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.AddressSpace;
import com.microsoft.azure.management.network.BgpSettings;
import com.microsoft.azure.management.network.LocalNetworkGateway;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import rx.Observable;

@LangDefinition
class LocalNetworkGatewayImpl
extends GroupableResourceImpl<LocalNetworkGateway, LocalNetworkGatewayInner, LocalNetworkGatewayImpl, NetworkManager>
implements LocalNetworkGateway,
LocalNetworkGateway.Definition,
LocalNetworkGateway.Update {
    LocalNetworkGatewayImpl(String name, LocalNetworkGatewayInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
    }

    @Override
    public String ipAddress() {
        return ((LocalNetworkGatewayInner)((Object)this.inner())).gatewayIpAddress();
    }

    @Override
    public BgpSettings bgpSettings() {
        return ((LocalNetworkGatewayInner)((Object)this.inner())).bgpSettings();
    }

    @Override
    public Set<String> addressSpaces() {
        HashSet<String> addressSpaces = new HashSet<String>();
        if (((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace() != null && ((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace().addressPrefixes() != null) {
            addressSpaces.addAll(((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace().addressPrefixes());
        }
        return Collections.unmodifiableSet(addressSpaces);
    }

    @Override
    public String provisioningState() {
        return ((LocalNetworkGatewayInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public LocalNetworkGatewayImpl withIPAddress(String ipAddress) {
        ((LocalNetworkGatewayInner)((Object)this.inner())).withGatewayIpAddress(ipAddress);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withAddressSpace(String cidr) {
        if (((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace() == null) {
            ((LocalNetworkGatewayInner)((Object)this.inner())).withLocalNetworkAddressSpace(new AddressSpace());
        }
        if (((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace().addressPrefixes() == null) {
            ((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace().withAddressPrefixes(new ArrayList<String>());
        }
        ((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace().addressPrefixes().add(cidr);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withoutAddressSpace(String cidr) {
        if (((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace() == null || ((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace().addressPrefixes() == null) {
            return this;
        }
        ((LocalNetworkGatewayInner)((Object)this.inner())).localNetworkAddressSpace().addressPrefixes().remove(cidr);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withBgp(long asn, String bgpPeeringAddress) {
        this.ensureBgpSettings().withAsn(asn).withBgpPeeringAddress(bgpPeeringAddress);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl disableBgp() {
        ((LocalNetworkGatewayInner)((Object)this.inner())).withBgpSettings(null);
        return this;
    }

    protected Observable<LocalNetworkGatewayInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).localNetworkGateways().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<LocalNetworkGateway> createResourceAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).localNetworkGateways().createOrUpdateAsync(this.resourceGroupName(), this.name(), (LocalNetworkGatewayInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    private BgpSettings ensureBgpSettings() {
        if (((LocalNetworkGatewayInner)((Object)this.inner())).bgpSettings() == null) {
            ((LocalNetworkGatewayInner)((Object)this.inner())).withBgpSettings(new BgpSettings());
        }
        return ((LocalNetworkGatewayInner)((Object)this.inner())).bgpSettings();
    }
}

