/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in BastionHosts.
 */
public class BastionHostsInner implements InnerSupportsGet<BastionHostInner>, InnerSupportsDelete<Void>, InnerSupportsListing<BastionHostInner> {
    /** The Retrofit service to perform REST calls. */
    private BastionHostsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of BastionHostsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public BastionHostsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(BastionHostsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for BastionHosts to be
     * used by Retrofit to perform actually REST calls.
     */
    interface BastionHostsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Body BastionHostInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Body BastionHostInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/bastionHosts")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String bastionHostName) {
        deleteWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().last().body();
    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String bastionHostName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String bastionHostName) {
        return deleteWithServiceResponseAsync(resourceGroupName, bastionHostName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, bastionHostName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String bastionHostName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().single().body();
    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String bastionHostName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String bastionHostName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, bastionHostName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.beginDelete(resourceGroupName, bastionHostName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BastionHostInner object if successful.
     */
    public BastionHostInner getByResourceGroup(String resourceGroupName, String bastionHostName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().single().body();
    }

    /**
     * Gets the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BastionHostInner> getByResourceGroupAsync(String resourceGroupName, String bastionHostName, final ServiceCallback<BastionHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    /**
     * Gets the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BastionHostInner object
     */
    public Observable<BastionHostInner> getByResourceGroupAsync(String resourceGroupName, String bastionHostName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, bastionHostName).map(new Func1<ServiceResponse<BastionHostInner>, BastionHostInner>() {
            @Override
            public BastionHostInner call(ServiceResponse<BastionHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BastionHostInner object
     */
    public Observable<ServiceResponse<BastionHostInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.getByResourceGroup(resourceGroupName, bastionHostName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BastionHostInner>>>() {
                @Override
                public Observable<ServiceResponse<BastionHostInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BastionHostInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BastionHostInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BastionHostInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BastionHostInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BastionHostInner object if successful.
     */
    public BastionHostInner createOrUpdate(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BastionHostInner> createOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters, final ServiceCallback<BastionHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BastionHostInner> createOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).map(new Func1<ServiceResponse<BastionHostInner>, BastionHostInner>() {
            @Override
            public BastionHostInner call(ServiceResponse<BastionHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BastionHostInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, bastionHostName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BastionHostInner>() { }.getType());
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BastionHostInner object if successful.
     */
    public BastionHostInner beginCreateOrUpdate(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BastionHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters, final ServiceCallback<BastionHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BastionHostInner object
     */
    public Observable<BastionHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).map(new Func1<ServiceResponse<BastionHostInner>, BastionHostInner>() {
            @Override
            public BastionHostInner call(ServiceResponse<BastionHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Bastion Host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param parameters Parameters supplied to the create or update Bastion Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BastionHostInner object
     */
    public Observable<ServiceResponse<BastionHostInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-06-01";
        return service.beginCreateOrUpdate(resourceGroupName, bastionHostName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BastionHostInner>>>() {
                @Override
                public Observable<ServiceResponse<BastionHostInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BastionHostInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BastionHostInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BastionHostInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BastionHostInner>() { }.getType())
                .register(201, new TypeToken<BastionHostInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionHostInner&gt; object if successful.
     */
    public PagedList<BastionHostInner> list() {
        ServiceResponse<Page<BastionHostInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<BastionHostInner>(response.body()) {
            @Override
            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionHostInner>> listAsync(final ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<Page<BastionHostInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>() {
                @Override
                public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionHostInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionHostInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionHostInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BastionHostInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionHostInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionHostInner&gt; object if successful.
     */
    public PagedList<BastionHostInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<BastionHostInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<BastionHostInner>(response.body()) {
            @Override
            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionHostInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<Page<BastionHostInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>() {
                @Override
                public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
    ServiceResponse<PageImpl<BastionHostInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionHostInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionHostInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionHostInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BastionHostInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionHostInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionHostInner&gt; object if successful.
     */
    public PagedList<BastionHostInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<BastionHostInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionHostInner>(response.body()) {
            @Override
            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionHostInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<BastionHostInner>> serviceFuture, final ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<Page<BastionHostInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>() {
                @Override
                public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a subscription.
     *
    ServiceResponse<PageImpl<BastionHostInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionHostInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionHostInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionHostInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BastionHostInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionHostInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionHostInner&gt; object if successful.
     */
    public PagedList<BastionHostInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<BastionHostInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionHostInner>(response.body()) {
            @Override
            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionHostInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<BastionHostInner>> serviceFuture, final ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<Page<BastionHostInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>() {
                @Override
                public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionHostInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Bastion Hosts in a resource group.
     *
    ServiceResponse<PageImpl<BastionHostInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionHostInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionHostInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionHostInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BastionHostInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionHostInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
