/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in PublicIPPrefixes.
 */
public class PublicIPPrefixesInner implements InnerSupportsGet<PublicIPPrefixInner>, InnerSupportsDelete<Void>, InnerSupportsListing<PublicIPPrefixInner> {
    /** The Retrofit service to perform REST calls. */
    private PublicIPPrefixesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of PublicIPPrefixesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PublicIPPrefixesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(PublicIPPrefixesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for PublicIPPrefixes to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PublicIPPrefixesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("publicIpPrefixName") String publicIpPrefixName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("publicIpPrefixName") String publicIpPrefixName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("publicIpPrefixName") String publicIpPrefixName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("publicIpPrefixName") String publicIpPrefixName, @Path("subscriptionId") String subscriptionId, @Body PublicIPPrefixInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("publicIpPrefixName") String publicIpPrefixName, @Path("subscriptionId") String subscriptionId, @Body PublicIPPrefixInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        Observable<Response<ResponseBody>> updateTags(@Path("resourceGroupName") String resourceGroupName, @Path("publicIpPrefixName") String publicIpPrefixName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes beginUpdateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        Observable<Response<ResponseBody>> beginUpdateTags(@Path("resourceGroupName") String resourceGroupName, @Path("publicIpPrefixName") String publicIpPrefixName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/publicIPPrefixes")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String publicIpPrefixName) {
        deleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().last().body();
    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String publicIpPrefixName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String publicIpPrefixName) {
        return deleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String publicIpPrefixName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().single().body();
    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String publicIpPrefixName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String publicIpPrefixName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the PublicIpPrefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.beginDelete(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner getByResourceGroup(String resourceGroupName, String publicIpPrefixName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().single().body();
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        final String expand = null;
        return service.getByResourceGroup(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>() {
                @Override
                public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PublicIPPrefixInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner getByResourceGroup(String resourceGroupName, String publicIpPrefixName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, expand).toBlocking().single().body();
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param expand Expands referenced resources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName, String expand, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, expand), serviceCallback);
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, expand).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified public IP prefix in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.getByResourceGroup(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>() {
                @Override
                public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PublicIPPrefixInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PublicIPPrefixInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PublicIPPrefixInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PublicIPPrefixInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner createOrUpdate(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> createOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PublicIPPrefixInner> createOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PublicIPPrefixInner>() { }.getType());
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner beginCreateOrUpdate(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<PublicIPPrefixInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a static or dynamic public IP prefix.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param parameters Parameters supplied to the create or update public IP prefix operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-06-01";
        return service.beginCreateOrUpdate(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>() {
                @Override
                public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PublicIPPrefixInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PublicIPPrefixInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PublicIPPrefixInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PublicIPPrefixInner>() { }.getType())
                .register(201, new TypeToken<PublicIPPrefixInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner updateTags(String resourceGroupName, String publicIpPrefixName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().last().body();
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        final Map<String, String> tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = service.updateTags(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PublicIPPrefixInner>() { }.getType());
    }
    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner updateTags(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags).toBlocking().last().body();
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags), serviceCallback);
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.updateTags(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PublicIPPrefixInner>() { }.getType());
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner beginUpdateTags(String resourceGroupName, String publicIpPrefixName) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().single().body();
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> beginUpdateTagsAsync(String resourceGroupName, String publicIpPrefixName, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<PublicIPPrefixInner> beginUpdateTagsAsync(String resourceGroupName, String publicIpPrefixName) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        final Map<String, String> tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return service.beginUpdateTags(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>() {
                @Override
                public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PublicIPPrefixInner> clientResponse = beginUpdateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PublicIPPrefixInner object if successful.
     */
    public PublicIPPrefixInner beginUpdateTags(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags).toBlocking().single().body();
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PublicIPPrefixInner> beginUpdateTagsAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags, final ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags), serviceCallback);
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<PublicIPPrefixInner> beginUpdateTagsAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags).map(new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>() {
            @Override
            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates public IP prefix tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param publicIpPrefixName The name of the public IP prefix.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PublicIPPrefixInner object
     */
    public Observable<ServiceResponse<PublicIPPrefixInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return service.beginUpdateTags(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>() {
                @Override
                public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PublicIPPrefixInner> clientResponse = beginUpdateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PublicIPPrefixInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PublicIPPrefixInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PublicIPPrefixInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object if successful.
     */
    public PagedList<PublicIPPrefixInner> list() {
        ServiceResponse<Page<PublicIPPrefixInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<PublicIPPrefixInner>(response.body()) {
            @Override
            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PublicIPPrefixInner>> listAsync(final ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<Page<PublicIPPrefixInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>() {
                @Override
                public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PublicIPPrefixInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PublicIPPrefixInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PublicIPPrefixInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object if successful.
     */
    public PagedList<PublicIPPrefixInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<PublicIPPrefixInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PublicIPPrefixInner>(response.body()) {
            @Override
            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PublicIPPrefixInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<Page<PublicIPPrefixInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>() {
                @Override
                public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
    ServiceResponse<PageImpl<PublicIPPrefixInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PublicIPPrefixInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PublicIPPrefixInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PublicIPPrefixInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object if successful.
     */
    public PagedList<PublicIPPrefixInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<PublicIPPrefixInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPPrefixInner>(response.body()) {
            @Override
            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PublicIPPrefixInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<PublicIPPrefixInner>> serviceFuture, final ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<Page<PublicIPPrefixInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>() {
                @Override
                public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the public IP prefixes in a subscription.
     *
    ServiceResponse<PageImpl<PublicIPPrefixInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PublicIPPrefixInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PublicIPPrefixInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PublicIPPrefixInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object if successful.
     */
    public PagedList<PublicIPPrefixInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<PublicIPPrefixInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPPrefixInner>(response.body()) {
            @Override
            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PublicIPPrefixInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<PublicIPPrefixInner>> serviceFuture, final ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<Page<PublicIPPrefixInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>() {
                @Override
                public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PublicIPPrefixInner&gt; object
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all public IP prefixes in a resource group.
     *
    ServiceResponse<PageImpl<PublicIPPrefixInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PublicIPPrefixInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PublicIPPrefixInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PublicIPPrefixInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PublicIPPrefixInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
