/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in WebApplicationFirewallPolicies.
 */
public class WebApplicationFirewallPoliciesInner implements InnerSupportsGet<WebApplicationFirewallPolicyInner>, InnerSupportsDelete<Void>, InnerSupportsListing<WebApplicationFirewallPolicyInner> {
    /** The Retrofit service to perform REST calls. */
    private WebApplicationFirewallPoliciesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of WebApplicationFirewallPoliciesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public WebApplicationFirewallPoliciesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(WebApplicationFirewallPoliciesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for WebApplicationFirewallPolicies to be
     * used by Retrofit to perform actually REST calls.
     */
    interface WebApplicationFirewallPoliciesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Body WebApplicationFirewallPolicyInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.WebApplicationFirewallPolicies listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object if successful.
     */
    public PagedList<WebApplicationFirewallPolicyInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>(response.body()) {
            @Override
            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<Page<WebApplicationFirewallPolicyInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>() {
                @Override
                public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
    ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WebApplicationFirewallPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WebApplicationFirewallPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object if successful.
     */
    public PagedList<WebApplicationFirewallPolicyInner> list() {
        ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>(response.body()) {
            @Override
            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listAsync(final ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<Page<WebApplicationFirewallPolicyInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>() {
                @Override
                public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WebApplicationFirewallPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WebApplicationFirewallPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WebApplicationFirewallPolicyInner object if successful.
     */
    public WebApplicationFirewallPolicyInner getByResourceGroup(String resourceGroupName, String policyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single().body();
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName, final ServiceCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebApplicationFirewallPolicyInner object
     */
    public Observable<WebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).map(new Func1<ServiceResponse<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner>() {
            @Override
            public WebApplicationFirewallPolicyInner call(ServiceResponse<WebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebApplicationFirewallPolicyInner object
     */
    public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.getByResourceGroup(resourceGroupName, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebApplicationFirewallPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WebApplicationFirewallPolicyInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WebApplicationFirewallPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WebApplicationFirewallPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WebApplicationFirewallPolicyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @param parameters Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WebApplicationFirewallPolicyInner object if successful.
     */
    public WebApplicationFirewallPolicyInner createOrUpdate(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @param parameters Policy to be created.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters, final ServiceCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, parameters), serviceCallback);
    }

    /**
     * Creates or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @param parameters Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebApplicationFirewallPolicyInner object
     */
    public Observable<WebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, parameters).map(new Func1<ServiceResponse<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner>() {
            @Override
            public WebApplicationFirewallPolicyInner call(ServiceResponse<WebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @param parameters Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebApplicationFirewallPolicyInner object
     */
    public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-06-01";
        return service.createOrUpdate(resourceGroupName, policyName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebApplicationFirewallPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<WebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WebApplicationFirewallPolicyInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WebApplicationFirewallPolicyInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WebApplicationFirewallPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WebApplicationFirewallPolicyInner>() { }.getType())
                .register(201, new TypeToken<WebApplicationFirewallPolicyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String policyName) {
        deleteWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().last().body();
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String policyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String policyName) {
        return deleteWithServiceResponseAsync(resourceGroupName, policyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String policyName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single().body();
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String policyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String policyName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, policyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param policyName The name of the policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-06-01";
        return service.beginDelete(resourceGroupName, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object if successful.
     */
    public PagedList<WebApplicationFirewallPolicyInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>(response.body()) {
            @Override
            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<WebApplicationFirewallPolicyInner>> serviceFuture, final ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<Page<WebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>() {
                @Override
                public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
    ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WebApplicationFirewallPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WebApplicationFirewallPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object if successful.
     */
    public PagedList<WebApplicationFirewallPolicyInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebApplicationFirewallPolicyInner>(response.body()) {
            @Override
            public Page<WebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WebApplicationFirewallPolicyInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<WebApplicationFirewallPolicyInner>> serviceFuture, final ListOperationCallback<WebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<Page<WebApplicationFirewallPolicyInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Page<WebApplicationFirewallPolicyInner>>() {
                @Override
                public Page<WebApplicationFirewallPolicyInner> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<WebApplicationFirewallPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the WAF policies in a subscription.
     *
    ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WebApplicationFirewallPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WebApplicationFirewallPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WebApplicationFirewallPolicyInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WebApplicationFirewallPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WebApplicationFirewallPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
