/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.ExpressRoutePortsLocationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRoutePortsLocationsInner {
    private ExpressRoutePortsLocationsService service;
    private NetworkManagementClientImpl client;

    public ExpressRoutePortsLocationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ExpressRoutePortsLocationsService)retrofit.create(ExpressRoutePortsLocationsService.class);
        this.client = client;
    }

    public PagedList<ExpressRoutePortsLocationInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ExpressRoutePortsLocationInner>((Page)response.body()){

            public Page<ExpressRoutePortsLocationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRoutePortsLocationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRoutePortsLocationInner>> listAsync(ListOperationCallback<ExpressRoutePortsLocationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> call(String nextPageLink) {
                return ExpressRoutePortsLocationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRoutePortsLocationInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortsLocationInner>>, Page<ExpressRoutePortsLocationInner>>(){

            public Page<ExpressRoutePortsLocationInner> call(ServiceResponse<Page<ExpressRoutePortsLocationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortsLocationInner>>, Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> call(ServiceResponse<Page<ExpressRoutePortsLocationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRoutePortsLocationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRoutePortsLocationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRoutePortsLocationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRoutePortsLocationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRoutePortsLocationInner get(String locationName) {
        return (ExpressRoutePortsLocationInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(locationName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRoutePortsLocationInner> getAsync(String locationName, ServiceCallback<ExpressRoutePortsLocationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(locationName), serviceCallback);
    }

    public Observable<ExpressRoutePortsLocationInner> getAsync(String locationName) {
        return this.getWithServiceResponseAsync(locationName).map((Func1)new Func1<ServiceResponse<ExpressRoutePortsLocationInner>, ExpressRoutePortsLocationInner>(){

            public ExpressRoutePortsLocationInner call(ServiceResponse<ExpressRoutePortsLocationInner> response) {
                return (ExpressRoutePortsLocationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRoutePortsLocationInner>> getWithServiceResponseAsync(String locationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(this.client.subscriptionId(), locationName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRoutePortsLocationInner>>>(){

            public Observable<ServiceResponse<ExpressRoutePortsLocationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRoutePortsLocationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRoutePortsLocationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRoutePortsLocationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRoutePortsLocationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ExpressRoutePortsLocationInner>((Page)response.body()){

            public Page<ExpressRoutePortsLocationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ExpressRoutePortsLocationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ExpressRoutePortsLocationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ExpressRoutePortsLocationInner>> serviceFuture, ListOperationCallback<ExpressRoutePortsLocationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> call(String nextPageLink) {
                return ExpressRoutePortsLocationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ExpressRoutePortsLocationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortsLocationInner>>, Page<ExpressRoutePortsLocationInner>>(){

            public Page<ExpressRoutePortsLocationInner> call(ServiceResponse<Page<ExpressRoutePortsLocationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ExpressRoutePortsLocationInner>>, Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> call(ServiceResponse<Page<ExpressRoutePortsLocationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ExpressRoutePortsLocationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>>>(){

            public Observable<ServiceResponse<Page<ExpressRoutePortsLocationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRoutePortsLocationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ExpressRoutePortsLocationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ExpressRoutePortsLocationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExpressRoutePortsLocationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePortsLocations list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/ExpressRoutePortsLocations")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePortsLocations get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/ExpressRoutePortsLocations/{locationName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="locationName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRoutePortsLocations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

