/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.ServiceEndpointPolicyInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ServiceEndpointPoliciesInner
implements InnerSupportsGet<ServiceEndpointPolicyInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ServiceEndpointPolicyInner> {
    private ServiceEndpointPoliciesService service;
    private NetworkManagementClientImpl client;

    public ServiceEndpointPoliciesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ServiceEndpointPoliciesService)retrofit.create(ServiceEndpointPoliciesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String serviceEndpointPolicyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serviceEndpointPolicyName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPoliciesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServiceEndpointPolicyInner getByResourceGroup(String resourceGroupName, String serviceEndpointPolicyName) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>(){

            public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPoliciesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ServiceEndpointPolicyInner getByResourceGroup(String resourceGroupName, String serviceEndpointPolicyName, String expand) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName, String expand, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, expand), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> getByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, expand).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>(){

            public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPoliciesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceEndpointPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceEndpointPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServiceEndpointPolicyInner createOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyInner>(){}.getType());
    }

    public ServiceEndpointPolicyInner beginCreateOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, parameters).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceEndpointPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>(){

            public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceEndpointPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceEndpointPolicyInner>(){}.getType()).register(201, new TypeToken<ServiceEndpointPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServiceEndpointPolicyInner update(String resourceGroupName, String serviceEndpointPolicyName) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().last()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyInner>(){}.getType());
    }

    public ServiceEndpointPolicyInner update(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> updateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyInner>(){}.getType());
    }

    public ServiceEndpointPolicyInner beginUpdate(String resourceGroupName, String serviceEndpointPolicyName) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>(){

            public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ServiceEndpointPolicyInner beginUpdate(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return (ServiceEndpointPolicyInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags, ServiceCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyInner> beginUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, tags).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyInner>, ServiceEndpointPolicyInner>(){

            public ServiceEndpointPolicyInner call(ServiceResponse<ServiceEndpointPolicyInner> response) {
                return (ServiceEndpointPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdate(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyInner>>>(){

            public Observable<ServiceResponse<ServiceEndpointPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceEndpointPolicyInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceEndpointPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServiceEndpointPolicyInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>((Page)response.body()){

            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServiceEndpointPoliciesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServiceEndpointPolicyInner>> listAsync(ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                return ServiceEndpointPoliciesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServiceEndpointPolicyInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>(){

            public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServiceEndpointPoliciesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServiceEndpointPoliciesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServiceEndpointPolicyInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>((Page)response.body()){

            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServiceEndpointPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServiceEndpointPolicyInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                return ServiceEndpointPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServiceEndpointPolicyInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>(){

            public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServiceEndpointPoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServiceEndpointPoliciesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServiceEndpointPolicyInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>((Page)response.body()){

            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServiceEndpointPoliciesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServiceEndpointPolicyInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ServiceEndpointPolicyInner>> serviceFuture, ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                return ServiceEndpointPoliciesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServiceEndpointPolicyInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>(){

            public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServiceEndpointPoliciesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServiceEndpointPoliciesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServiceEndpointPolicyInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyInner>((Page)response.body()){

            public Page<ServiceEndpointPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServiceEndpointPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServiceEndpointPolicyInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ServiceEndpointPolicyInner>> serviceFuture, ListOperationCallback<ServiceEndpointPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(String nextPageLink) {
                return ServiceEndpointPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServiceEndpointPolicyInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Page<ServiceEndpointPolicyInner>>(){

            public Page<ServiceEndpointPolicyInner> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServiceEndpointPoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServiceEndpointPoliciesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServiceEndpointPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServiceEndpointPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Body ServiceEndpointPolicyInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Body ServiceEndpointPolicyInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/ServiceEndpointPolicies")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicies listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

