/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ConnectionMonitor;
import com.microsoft.azure.management.network.ConnectionMonitors;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorImpl;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorResultInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorsInner;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ConnectionMonitorsImpl
extends CreatableResourcesImpl<ConnectionMonitor, ConnectionMonitorImpl, ConnectionMonitorResultInner>
implements ConnectionMonitors {
    private final NetworkWatcherImpl parent;
    private final ConnectionMonitorsInner innerCollection;

    ConnectionMonitorsImpl(ConnectionMonitorsInner innerCollection, NetworkWatcherImpl parent) {
        this.parent = parent;
        this.innerCollection = innerCollection;
    }

    public final PagedList<ConnectionMonitor> list() {
        return new PagedListConverter<ConnectionMonitorResultInner, ConnectionMonitor>(){

            public Observable<ConnectionMonitor> typeConvertAsync(ConnectionMonitorResultInner inner) {
                return Observable.just((Object)ConnectionMonitorsImpl.this.wrapModel(inner));
            }
        }.convert(ReadableWrappersImpl.convertToPagedList(this.inner().list(this.parent.resourceGroupName(), this.parent.name())));
    }

    public Observable<ConnectionMonitor> listAsync() {
        Observable<List<ConnectionMonitorResultInner>> list = this.inner().listAsync(this.parent.resourceGroupName(), this.parent.name());
        return ReadableWrappersImpl.convertListToInnerAsync(list).map((Func1)new Func1<ConnectionMonitorResultInner, ConnectionMonitor>(){

            public ConnectionMonitor call(ConnectionMonitorResultInner inner) {
                return ConnectionMonitorsImpl.this.wrapModel(inner);
            }
        });
    }

    protected ConnectionMonitorImpl wrapModel(String name) {
        return new ConnectionMonitorImpl(name, this.parent, new ConnectionMonitorResultInner(), this.inner());
    }

    protected ConnectionMonitorImpl wrapModel(ConnectionMonitorResultInner inner) {
        return inner == null ? null : new ConnectionMonitorImpl(inner.name(), this.parent, inner, this.inner());
    }

    public ConnectionMonitorImpl define(String name) {
        return new ConnectionMonitorImpl(name, this.parent, new ConnectionMonitorResultInner(), this.inner());
    }

    public Observable<ConnectionMonitor> getByNameAsync(String name) {
        return this.inner().getAsync(this.parent.resourceGroupName(), this.parent.name(), name).map((Func1)new Func1<ConnectionMonitorResultInner, ConnectionMonitor>(){

            public ConnectionMonitor call(ConnectionMonitorResultInner inner) {
                return ConnectionMonitorsImpl.this.wrapModel(inner);
            }
        });
    }

    public ConnectionMonitor getByName(String name) {
        return (ConnectionMonitor)this.getByNameAsync(name).toBlocking().last();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return this.inner().deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name, callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name).toCompletable();
    }

    public ConnectionMonitorsInner inner() {
        return this.innerCollection;
    }

    public Completable deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().deleteAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name()).toCompletable();
    }
}

