/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.management.network.BastionShareableLinkListRequest;
import com.microsoft.azure.management.network.SessionIds;
import com.microsoft.azure.management.network.VirtualWanVpnProfileParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * Initializes a new instance of the NetworkManagementClientImpl class.
 */
public class NetworkManagementClientImpl extends AzureServiceClient {
    /** The Retrofit service to perform REST calls. */
    private NetworkManagementClientService service;
    /** the {@link AzureClient} used for long running operations. */
    private AzureClient azureClient;

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    /** The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call. */
    private String subscriptionId;

    /**
     * Gets The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Sets The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
     *
     * @param subscriptionId the subscriptionId value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /** Client API version. */
    private String apiVersion;

    /**
     * Gets Client API version.
     *
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.apiVersion;
    }

    /** The preferred language for the response. */
    private String acceptLanguage;

    /**
     * Gets The preferred language for the response.
     *
     * @return the acceptLanguage value.
     */
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    /**
     * Sets The preferred language for the response.
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    /** The retry timeout in seconds for Long Running Operations. Default value is 30. */
    private int longRunningOperationRetryTimeout;

    /**
     * Gets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    /**
     * Sets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    /** Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true. */
    private boolean generateClientRequestId;

    /**
     * Gets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @return the generateClientRequestId value.
     */
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    /**
     * Sets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    public NetworkManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    /**
     * The ApplicationGatewaysInner object to access its operations.
     */
    private ApplicationGatewaysInner applicationGateways;

    /**
     * Gets the ApplicationGatewaysInner object to access its operations.
     * @return the ApplicationGatewaysInner object.
     */
    public ApplicationGatewaysInner applicationGateways() {
        return this.applicationGateways;
    }

    /**
     * The ApplicationSecurityGroupsInner object to access its operations.
     */
    private ApplicationSecurityGroupsInner applicationSecurityGroups;

    /**
     * Gets the ApplicationSecurityGroupsInner object to access its operations.
     * @return the ApplicationSecurityGroupsInner object.
     */
    public ApplicationSecurityGroupsInner applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    /**
     * The AvailableDelegationsInner object to access its operations.
     */
    private AvailableDelegationsInner availableDelegations;

    /**
     * Gets the AvailableDelegationsInner object to access its operations.
     * @return the AvailableDelegationsInner object.
     */
    public AvailableDelegationsInner availableDelegations() {
        return this.availableDelegations;
    }

    /**
     * The AvailableResourceGroupDelegationsInner object to access its operations.
     */
    private AvailableResourceGroupDelegationsInner availableResourceGroupDelegations;

    /**
     * Gets the AvailableResourceGroupDelegationsInner object to access its operations.
     * @return the AvailableResourceGroupDelegationsInner object.
     */
    public AvailableResourceGroupDelegationsInner availableResourceGroupDelegations() {
        return this.availableResourceGroupDelegations;
    }

    /**
     * The AvailableServiceAliasesInner object to access its operations.
     */
    private AvailableServiceAliasesInner availableServiceAliases;

    /**
     * Gets the AvailableServiceAliasesInner object to access its operations.
     * @return the AvailableServiceAliasesInner object.
     */
    public AvailableServiceAliasesInner availableServiceAliases() {
        return this.availableServiceAliases;
    }

    /**
     * The AzureFirewallsInner object to access its operations.
     */
    private AzureFirewallsInner azureFirewalls;

    /**
     * Gets the AzureFirewallsInner object to access its operations.
     * @return the AzureFirewallsInner object.
     */
    public AzureFirewallsInner azureFirewalls() {
        return this.azureFirewalls;
    }

    /**
     * The AzureFirewallFqdnTagsInner object to access its operations.
     */
    private AzureFirewallFqdnTagsInner azureFirewallFqdnTags;

    /**
     * Gets the AzureFirewallFqdnTagsInner object to access its operations.
     * @return the AzureFirewallFqdnTagsInner object.
     */
    public AzureFirewallFqdnTagsInner azureFirewallFqdnTags() {
        return this.azureFirewallFqdnTags;
    }

    /**
     * The BastionHostsInner object to access its operations.
     */
    private BastionHostsInner bastionHosts;

    /**
     * Gets the BastionHostsInner object to access its operations.
     * @return the BastionHostsInner object.
     */
    public BastionHostsInner bastionHosts() {
        return this.bastionHosts;
    }

    /**
     * The DdosCustomPoliciesInner object to access its operations.
     */
    private DdosCustomPoliciesInner ddosCustomPolicies;

    /**
     * Gets the DdosCustomPoliciesInner object to access its operations.
     * @return the DdosCustomPoliciesInner object.
     */
    public DdosCustomPoliciesInner ddosCustomPolicies() {
        return this.ddosCustomPolicies;
    }

    /**
     * The DdosProtectionPlansInner object to access its operations.
     */
    private DdosProtectionPlansInner ddosProtectionPlans;

    /**
     * Gets the DdosProtectionPlansInner object to access its operations.
     * @return the DdosProtectionPlansInner object.
     */
    public DdosProtectionPlansInner ddosProtectionPlans() {
        return this.ddosProtectionPlans;
    }

    /**
     * The AvailableEndpointServicesInner object to access its operations.
     */
    private AvailableEndpointServicesInner availableEndpointServices;

    /**
     * Gets the AvailableEndpointServicesInner object to access its operations.
     * @return the AvailableEndpointServicesInner object.
     */
    public AvailableEndpointServicesInner availableEndpointServices() {
        return this.availableEndpointServices;
    }

    /**
     * The ExpressRouteCircuitAuthorizationsInner object to access its operations.
     */
    private ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations;

    /**
     * Gets the ExpressRouteCircuitAuthorizationsInner object to access its operations.
     * @return the ExpressRouteCircuitAuthorizationsInner object.
     */
    public ExpressRouteCircuitAuthorizationsInner expressRouteCircuitAuthorizations() {
        return this.expressRouteCircuitAuthorizations;
    }

    /**
     * The ExpressRouteCircuitPeeringsInner object to access its operations.
     */
    private ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings;

    /**
     * Gets the ExpressRouteCircuitPeeringsInner object to access its operations.
     * @return the ExpressRouteCircuitPeeringsInner object.
     */
    public ExpressRouteCircuitPeeringsInner expressRouteCircuitPeerings() {
        return this.expressRouteCircuitPeerings;
    }

    /**
     * The ExpressRouteCircuitConnectionsInner object to access its operations.
     */
    private ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections;

    /**
     * Gets the ExpressRouteCircuitConnectionsInner object to access its operations.
     * @return the ExpressRouteCircuitConnectionsInner object.
     */
    public ExpressRouteCircuitConnectionsInner expressRouteCircuitConnections() {
        return this.expressRouteCircuitConnections;
    }

    /**
     * The PeerExpressRouteCircuitConnectionsInner object to access its operations.
     */
    private PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections;

    /**
     * Gets the PeerExpressRouteCircuitConnectionsInner object to access its operations.
     * @return the PeerExpressRouteCircuitConnectionsInner object.
     */
    public PeerExpressRouteCircuitConnectionsInner peerExpressRouteCircuitConnections() {
        return this.peerExpressRouteCircuitConnections;
    }

    /**
     * The ExpressRouteCircuitsInner object to access its operations.
     */
    private ExpressRouteCircuitsInner expressRouteCircuits;

    /**
     * Gets the ExpressRouteCircuitsInner object to access its operations.
     * @return the ExpressRouteCircuitsInner object.
     */
    public ExpressRouteCircuitsInner expressRouteCircuits() {
        return this.expressRouteCircuits;
    }

    /**
     * The ExpressRouteServiceProvidersInner object to access its operations.
     */
    private ExpressRouteServiceProvidersInner expressRouteServiceProviders;

    /**
     * Gets the ExpressRouteServiceProvidersInner object to access its operations.
     * @return the ExpressRouteServiceProvidersInner object.
     */
    public ExpressRouteServiceProvidersInner expressRouteServiceProviders() {
        return this.expressRouteServiceProviders;
    }

    /**
     * The ExpressRouteCrossConnectionsInner object to access its operations.
     */
    private ExpressRouteCrossConnectionsInner expressRouteCrossConnections;

    /**
     * Gets the ExpressRouteCrossConnectionsInner object to access its operations.
     * @return the ExpressRouteCrossConnectionsInner object.
     */
    public ExpressRouteCrossConnectionsInner expressRouteCrossConnections() {
        return this.expressRouteCrossConnections;
    }

    /**
     * The ExpressRouteCrossConnectionPeeringsInner object to access its operations.
     */
    private ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings;

    /**
     * Gets the ExpressRouteCrossConnectionPeeringsInner object to access its operations.
     * @return the ExpressRouteCrossConnectionPeeringsInner object.
     */
    public ExpressRouteCrossConnectionPeeringsInner expressRouteCrossConnectionPeerings() {
        return this.expressRouteCrossConnectionPeerings;
    }

    /**
     * The ExpressRouteGatewaysInner object to access its operations.
     */
    private ExpressRouteGatewaysInner expressRouteGateways;

    /**
     * Gets the ExpressRouteGatewaysInner object to access its operations.
     * @return the ExpressRouteGatewaysInner object.
     */
    public ExpressRouteGatewaysInner expressRouteGateways() {
        return this.expressRouteGateways;
    }

    /**
     * The ExpressRouteConnectionsInner object to access its operations.
     */
    private ExpressRouteConnectionsInner expressRouteConnections;

    /**
     * Gets the ExpressRouteConnectionsInner object to access its operations.
     * @return the ExpressRouteConnectionsInner object.
     */
    public ExpressRouteConnectionsInner expressRouteConnections() {
        return this.expressRouteConnections;
    }

    /**
     * The ExpressRoutePortsLocationsInner object to access its operations.
     */
    private ExpressRoutePortsLocationsInner expressRoutePortsLocations;

    /**
     * Gets the ExpressRoutePortsLocationsInner object to access its operations.
     * @return the ExpressRoutePortsLocationsInner object.
     */
    public ExpressRoutePortsLocationsInner expressRoutePortsLocations() {
        return this.expressRoutePortsLocations;
    }

    /**
     * The ExpressRoutePortsInner object to access its operations.
     */
    private ExpressRoutePortsInner expressRoutePorts;

    /**
     * Gets the ExpressRoutePortsInner object to access its operations.
     * @return the ExpressRoutePortsInner object.
     */
    public ExpressRoutePortsInner expressRoutePorts() {
        return this.expressRoutePorts;
    }

    /**
     * The ExpressRouteLinksInner object to access its operations.
     */
    private ExpressRouteLinksInner expressRouteLinks;

    /**
     * Gets the ExpressRouteLinksInner object to access its operations.
     * @return the ExpressRouteLinksInner object.
     */
    public ExpressRouteLinksInner expressRouteLinks() {
        return this.expressRouteLinks;
    }

    /**
     * The FirewallPoliciesInner object to access its operations.
     */
    private FirewallPoliciesInner firewallPolicies;

    /**
     * Gets the FirewallPoliciesInner object to access its operations.
     * @return the FirewallPoliciesInner object.
     */
    public FirewallPoliciesInner firewallPolicies() {
        return this.firewallPolicies;
    }

    /**
     * The FirewallPolicyRuleGroupsInner object to access its operations.
     */
    private FirewallPolicyRuleGroupsInner firewallPolicyRuleGroups;

    /**
     * Gets the FirewallPolicyRuleGroupsInner object to access its operations.
     * @return the FirewallPolicyRuleGroupsInner object.
     */
    public FirewallPolicyRuleGroupsInner firewallPolicyRuleGroups() {
        return this.firewallPolicyRuleGroups;
    }

    /**
     * The IpGroupsInner object to access its operations.
     */
    private IpGroupsInner ipGroups;

    /**
     * Gets the IpGroupsInner object to access its operations.
     * @return the IpGroupsInner object.
     */
    public IpGroupsInner ipGroups() {
        return this.ipGroups;
    }

    /**
     * The LoadBalancersInner object to access its operations.
     */
    private LoadBalancersInner loadBalancers;

    /**
     * Gets the LoadBalancersInner object to access its operations.
     * @return the LoadBalancersInner object.
     */
    public LoadBalancersInner loadBalancers() {
        return this.loadBalancers;
    }

    /**
     * The LoadBalancerBackendAddressPoolsInner object to access its operations.
     */
    private LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools;

    /**
     * Gets the LoadBalancerBackendAddressPoolsInner object to access its operations.
     * @return the LoadBalancerBackendAddressPoolsInner object.
     */
    public LoadBalancerBackendAddressPoolsInner loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    /**
     * The LoadBalancerFrontendIPConfigurationsInner object to access its operations.
     */
    private LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations;

    /**
     * Gets the LoadBalancerFrontendIPConfigurationsInner object to access its operations.
     * @return the LoadBalancerFrontendIPConfigurationsInner object.
     */
    public LoadBalancerFrontendIPConfigurationsInner loadBalancerFrontendIPConfigurations() {
        return this.loadBalancerFrontendIPConfigurations;
    }

    /**
     * The InboundNatRulesInner object to access its operations.
     */
    private InboundNatRulesInner inboundNatRules;

    /**
     * Gets the InboundNatRulesInner object to access its operations.
     * @return the InboundNatRulesInner object.
     */
    public InboundNatRulesInner inboundNatRules() {
        return this.inboundNatRules;
    }

    /**
     * The LoadBalancerLoadBalancingRulesInner object to access its operations.
     */
    private LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules;

    /**
     * Gets the LoadBalancerLoadBalancingRulesInner object to access its operations.
     * @return the LoadBalancerLoadBalancingRulesInner object.
     */
    public LoadBalancerLoadBalancingRulesInner loadBalancerLoadBalancingRules() {
        return this.loadBalancerLoadBalancingRules;
    }

    /**
     * The LoadBalancerOutboundRulesInner object to access its operations.
     */
    private LoadBalancerOutboundRulesInner loadBalancerOutboundRules;

    /**
     * Gets the LoadBalancerOutboundRulesInner object to access its operations.
     * @return the LoadBalancerOutboundRulesInner object.
     */
    public LoadBalancerOutboundRulesInner loadBalancerOutboundRules() {
        return this.loadBalancerOutboundRules;
    }

    /**
     * The LoadBalancerNetworkInterfacesInner object to access its operations.
     */
    private LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces;

    /**
     * Gets the LoadBalancerNetworkInterfacesInner object to access its operations.
     * @return the LoadBalancerNetworkInterfacesInner object.
     */
    public LoadBalancerNetworkInterfacesInner loadBalancerNetworkInterfaces() {
        return this.loadBalancerNetworkInterfaces;
    }

    /**
     * The LoadBalancerProbesInner object to access its operations.
     */
    private LoadBalancerProbesInner loadBalancerProbes;

    /**
     * Gets the LoadBalancerProbesInner object to access its operations.
     * @return the LoadBalancerProbesInner object.
     */
    public LoadBalancerProbesInner loadBalancerProbes() {
        return this.loadBalancerProbes;
    }

    /**
     * The NatGatewaysInner object to access its operations.
     */
    private NatGatewaysInner natGateways;

    /**
     * Gets the NatGatewaysInner object to access its operations.
     * @return the NatGatewaysInner object.
     */
    public NatGatewaysInner natGateways() {
        return this.natGateways;
    }

    /**
     * The NetworkInterfacesInner object to access its operations.
     */
    private NetworkInterfacesInner networkInterfaces;

    /**
     * Gets the NetworkInterfacesInner object to access its operations.
     * @return the NetworkInterfacesInner object.
     */
    public NetworkInterfacesInner networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * The NetworkInterfaceIPConfigurationsInner object to access its operations.
     */
    private NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations;

    /**
     * Gets the NetworkInterfaceIPConfigurationsInner object to access its operations.
     * @return the NetworkInterfaceIPConfigurationsInner object.
     */
    public NetworkInterfaceIPConfigurationsInner networkInterfaceIPConfigurations() {
        return this.networkInterfaceIPConfigurations;
    }

    /**
     * The NetworkInterfaceLoadBalancersInner object to access its operations.
     */
    private NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers;

    /**
     * Gets the NetworkInterfaceLoadBalancersInner object to access its operations.
     * @return the NetworkInterfaceLoadBalancersInner object.
     */
    public NetworkInterfaceLoadBalancersInner networkInterfaceLoadBalancers() {
        return this.networkInterfaceLoadBalancers;
    }

    /**
     * The NetworkInterfaceTapConfigurationsInner object to access its operations.
     */
    private NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations;

    /**
     * Gets the NetworkInterfaceTapConfigurationsInner object to access its operations.
     * @return the NetworkInterfaceTapConfigurationsInner object.
     */
    public NetworkInterfaceTapConfigurationsInner networkInterfaceTapConfigurations() {
        return this.networkInterfaceTapConfigurations;
    }

    /**
     * The NetworkProfilesInner object to access its operations.
     */
    private NetworkProfilesInner networkProfiles;

    /**
     * Gets the NetworkProfilesInner object to access its operations.
     * @return the NetworkProfilesInner object.
     */
    public NetworkProfilesInner networkProfiles() {
        return this.networkProfiles;
    }

    /**
     * The NetworkSecurityGroupsInner object to access its operations.
     */
    private NetworkSecurityGroupsInner networkSecurityGroups;

    /**
     * Gets the NetworkSecurityGroupsInner object to access its operations.
     * @return the NetworkSecurityGroupsInner object.
     */
    public NetworkSecurityGroupsInner networkSecurityGroups() {
        return this.networkSecurityGroups;
    }

    /**
     * The SecurityRulesInner object to access its operations.
     */
    private SecurityRulesInner securityRules;

    /**
     * Gets the SecurityRulesInner object to access its operations.
     * @return the SecurityRulesInner object.
     */
    public SecurityRulesInner securityRules() {
        return this.securityRules;
    }

    /**
     * The DefaultSecurityRulesInner object to access its operations.
     */
    private DefaultSecurityRulesInner defaultSecurityRules;

    /**
     * Gets the DefaultSecurityRulesInner object to access its operations.
     * @return the DefaultSecurityRulesInner object.
     */
    public DefaultSecurityRulesInner defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    /**
     * The NetworkWatchersInner object to access its operations.
     */
    private NetworkWatchersInner networkWatchers;

    /**
     * Gets the NetworkWatchersInner object to access its operations.
     * @return the NetworkWatchersInner object.
     */
    public NetworkWatchersInner networkWatchers() {
        return this.networkWatchers;
    }

    /**
     * The PacketCapturesInner object to access its operations.
     */
    private PacketCapturesInner packetCaptures;

    /**
     * Gets the PacketCapturesInner object to access its operations.
     * @return the PacketCapturesInner object.
     */
    public PacketCapturesInner packetCaptures() {
        return this.packetCaptures;
    }

    /**
     * The ConnectionMonitorsInner object to access its operations.
     */
    private ConnectionMonitorsInner connectionMonitors;

    /**
     * Gets the ConnectionMonitorsInner object to access its operations.
     * @return the ConnectionMonitorsInner object.
     */
    public ConnectionMonitorsInner connectionMonitors() {
        return this.connectionMonitors;
    }

    /**
     * The FlowLogsInner object to access its operations.
     */
    private FlowLogsInner flowLogs;

    /**
     * Gets the FlowLogsInner object to access its operations.
     * @return the FlowLogsInner object.
     */
    public FlowLogsInner flowLogs() {
        return this.flowLogs;
    }

    /**
     * The OperationsInner object to access its operations.
     */
    private OperationsInner operations;

    /**
     * Gets the OperationsInner object to access its operations.
     * @return the OperationsInner object.
     */
    public OperationsInner operations() {
        return this.operations;
    }

    /**
     * The PrivateEndpointsInner object to access its operations.
     */
    private PrivateEndpointsInner privateEndpoints;

    /**
     * Gets the PrivateEndpointsInner object to access its operations.
     * @return the PrivateEndpointsInner object.
     */
    public PrivateEndpointsInner privateEndpoints() {
        return this.privateEndpoints;
    }

    /**
     * The AvailablePrivateEndpointTypesInner object to access its operations.
     */
    private AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes;

    /**
     * Gets the AvailablePrivateEndpointTypesInner object to access its operations.
     * @return the AvailablePrivateEndpointTypesInner object.
     */
    public AvailablePrivateEndpointTypesInner availablePrivateEndpointTypes() {
        return this.availablePrivateEndpointTypes;
    }

    /**
     * The PrivateLinkServicesInner object to access its operations.
     */
    private PrivateLinkServicesInner privateLinkServices;

    /**
     * Gets the PrivateLinkServicesInner object to access its operations.
     * @return the PrivateLinkServicesInner object.
     */
    public PrivateLinkServicesInner privateLinkServices() {
        return this.privateLinkServices;
    }

    /**
     * The PublicIPAddressesInner object to access its operations.
     */
    private PublicIPAddressesInner publicIPAddresses;

    /**
     * Gets the PublicIPAddressesInner object to access its operations.
     * @return the PublicIPAddressesInner object.
     */
    public PublicIPAddressesInner publicIPAddresses() {
        return this.publicIPAddresses;
    }

    /**
     * The PublicIPPrefixesInner object to access its operations.
     */
    private PublicIPPrefixesInner publicIPPrefixes;

    /**
     * Gets the PublicIPPrefixesInner object to access its operations.
     * @return the PublicIPPrefixesInner object.
     */
    public PublicIPPrefixesInner publicIPPrefixes() {
        return this.publicIPPrefixes;
    }

    /**
     * The RouteFiltersInner object to access its operations.
     */
    private RouteFiltersInner routeFilters;

    /**
     * Gets the RouteFiltersInner object to access its operations.
     * @return the RouteFiltersInner object.
     */
    public RouteFiltersInner routeFilters() {
        return this.routeFilters;
    }

    /**
     * The RouteFilterRulesInner object to access its operations.
     */
    private RouteFilterRulesInner routeFilterRules;

    /**
     * Gets the RouteFilterRulesInner object to access its operations.
     * @return the RouteFilterRulesInner object.
     */
    public RouteFilterRulesInner routeFilterRules() {
        return this.routeFilterRules;
    }

    /**
     * The RouteTablesInner object to access its operations.
     */
    private RouteTablesInner routeTables;

    /**
     * Gets the RouteTablesInner object to access its operations.
     * @return the RouteTablesInner object.
     */
    public RouteTablesInner routeTables() {
        return this.routeTables;
    }

    /**
     * The RoutesInner object to access its operations.
     */
    private RoutesInner routes;

    /**
     * Gets the RoutesInner object to access its operations.
     * @return the RoutesInner object.
     */
    public RoutesInner routes() {
        return this.routes;
    }

    /**
     * The BgpServiceCommunitiesInner object to access its operations.
     */
    private BgpServiceCommunitiesInner bgpServiceCommunities;

    /**
     * Gets the BgpServiceCommunitiesInner object to access its operations.
     * @return the BgpServiceCommunitiesInner object.
     */
    public BgpServiceCommunitiesInner bgpServiceCommunities() {
        return this.bgpServiceCommunities;
    }

    /**
     * The ServiceEndpointPoliciesInner object to access its operations.
     */
    private ServiceEndpointPoliciesInner serviceEndpointPolicies;

    /**
     * Gets the ServiceEndpointPoliciesInner object to access its operations.
     * @return the ServiceEndpointPoliciesInner object.
     */
    public ServiceEndpointPoliciesInner serviceEndpointPolicies() {
        return this.serviceEndpointPolicies;
    }

    /**
     * The ServiceEndpointPolicyDefinitionsInner object to access its operations.
     */
    private ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions;

    /**
     * Gets the ServiceEndpointPolicyDefinitionsInner object to access its operations.
     * @return the ServiceEndpointPolicyDefinitionsInner object.
     */
    public ServiceEndpointPolicyDefinitionsInner serviceEndpointPolicyDefinitions() {
        return this.serviceEndpointPolicyDefinitions;
    }

    /**
     * The ServiceTagsInner object to access its operations.
     */
    private ServiceTagsInner serviceTags;

    /**
     * Gets the ServiceTagsInner object to access its operations.
     * @return the ServiceTagsInner object.
     */
    public ServiceTagsInner serviceTags() {
        return this.serviceTags;
    }

    /**
     * The UsagesInner object to access its operations.
     */
    private UsagesInner usages;

    /**
     * Gets the UsagesInner object to access its operations.
     * @return the UsagesInner object.
     */
    public UsagesInner usages() {
        return this.usages;
    }

    /**
     * The VirtualNetworksInner object to access its operations.
     */
    private VirtualNetworksInner virtualNetworks;

    /**
     * Gets the VirtualNetworksInner object to access its operations.
     * @return the VirtualNetworksInner object.
     */
    public VirtualNetworksInner virtualNetworks() {
        return this.virtualNetworks;
    }

    /**
     * The SubnetsInner object to access its operations.
     */
    private SubnetsInner subnets;

    /**
     * Gets the SubnetsInner object to access its operations.
     * @return the SubnetsInner object.
     */
    public SubnetsInner subnets() {
        return this.subnets;
    }

    /**
     * The ResourceNavigationLinksInner object to access its operations.
     */
    private ResourceNavigationLinksInner resourceNavigationLinks;

    /**
     * Gets the ResourceNavigationLinksInner object to access its operations.
     * @return the ResourceNavigationLinksInner object.
     */
    public ResourceNavigationLinksInner resourceNavigationLinks() {
        return this.resourceNavigationLinks;
    }

    /**
     * The ServiceAssociationLinksInner object to access its operations.
     */
    private ServiceAssociationLinksInner serviceAssociationLinks;

    /**
     * Gets the ServiceAssociationLinksInner object to access its operations.
     * @return the ServiceAssociationLinksInner object.
     */
    public ServiceAssociationLinksInner serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    /**
     * The VirtualNetworkPeeringsInner object to access its operations.
     */
    private VirtualNetworkPeeringsInner virtualNetworkPeerings;

    /**
     * Gets the VirtualNetworkPeeringsInner object to access its operations.
     * @return the VirtualNetworkPeeringsInner object.
     */
    public VirtualNetworkPeeringsInner virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    /**
     * The VirtualNetworkGatewaysInner object to access its operations.
     */
    private VirtualNetworkGatewaysInner virtualNetworkGateways;

    /**
     * Gets the VirtualNetworkGatewaysInner object to access its operations.
     * @return the VirtualNetworkGatewaysInner object.
     */
    public VirtualNetworkGatewaysInner virtualNetworkGateways() {
        return this.virtualNetworkGateways;
    }

    /**
     * The VirtualNetworkGatewayConnectionsInner object to access its operations.
     */
    private VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections;

    /**
     * Gets the VirtualNetworkGatewayConnectionsInner object to access its operations.
     * @return the VirtualNetworkGatewayConnectionsInner object.
     */
    public VirtualNetworkGatewayConnectionsInner virtualNetworkGatewayConnections() {
        return this.virtualNetworkGatewayConnections;
    }

    /**
     * The LocalNetworkGatewaysInner object to access its operations.
     */
    private LocalNetworkGatewaysInner localNetworkGateways;

    /**
     * Gets the LocalNetworkGatewaysInner object to access its operations.
     * @return the LocalNetworkGatewaysInner object.
     */
    public LocalNetworkGatewaysInner localNetworkGateways() {
        return this.localNetworkGateways;
    }

    /**
     * The VirtualNetworkTapsInner object to access its operations.
     */
    private VirtualNetworkTapsInner virtualNetworkTaps;

    /**
     * Gets the VirtualNetworkTapsInner object to access its operations.
     * @return the VirtualNetworkTapsInner object.
     */
    public VirtualNetworkTapsInner virtualNetworkTaps() {
        return this.virtualNetworkTaps;
    }

    /**
     * The VirtualRoutersInner object to access its operations.
     */
    private VirtualRoutersInner virtualRouters;

    /**
     * Gets the VirtualRoutersInner object to access its operations.
     * @return the VirtualRoutersInner object.
     */
    public VirtualRoutersInner virtualRouters() {
        return this.virtualRouters;
    }

    /**
     * The VirtualRouterPeeringsInner object to access its operations.
     */
    private VirtualRouterPeeringsInner virtualRouterPeerings;

    /**
     * Gets the VirtualRouterPeeringsInner object to access its operations.
     * @return the VirtualRouterPeeringsInner object.
     */
    public VirtualRouterPeeringsInner virtualRouterPeerings() {
        return this.virtualRouterPeerings;
    }

    /**
     * The VirtualWansInner object to access its operations.
     */
    private VirtualWansInner virtualWans;

    /**
     * Gets the VirtualWansInner object to access its operations.
     * @return the VirtualWansInner object.
     */
    public VirtualWansInner virtualWans() {
        return this.virtualWans;
    }

    /**
     * The VpnSitesInner object to access its operations.
     */
    private VpnSitesInner vpnSites;

    /**
     * Gets the VpnSitesInner object to access its operations.
     * @return the VpnSitesInner object.
     */
    public VpnSitesInner vpnSites() {
        return this.vpnSites;
    }

    /**
     * The VpnSiteLinksInner object to access its operations.
     */
    private VpnSiteLinksInner vpnSiteLinks;

    /**
     * Gets the VpnSiteLinksInner object to access its operations.
     * @return the VpnSiteLinksInner object.
     */
    public VpnSiteLinksInner vpnSiteLinks() {
        return this.vpnSiteLinks;
    }

    /**
     * The VpnSitesConfigurationsInner object to access its operations.
     */
    private VpnSitesConfigurationsInner vpnSitesConfigurations;

    /**
     * Gets the VpnSitesConfigurationsInner object to access its operations.
     * @return the VpnSitesConfigurationsInner object.
     */
    public VpnSitesConfigurationsInner vpnSitesConfigurations() {
        return this.vpnSitesConfigurations;
    }

    /**
     * The VpnServerConfigurationsInner object to access its operations.
     */
    private VpnServerConfigurationsInner vpnServerConfigurations;

    /**
     * Gets the VpnServerConfigurationsInner object to access its operations.
     * @return the VpnServerConfigurationsInner object.
     */
    public VpnServerConfigurationsInner vpnServerConfigurations() {
        return this.vpnServerConfigurations;
    }

    /**
     * The VirtualHubsInner object to access its operations.
     */
    private VirtualHubsInner virtualHubs;

    /**
     * Gets the VirtualHubsInner object to access its operations.
     * @return the VirtualHubsInner object.
     */
    public VirtualHubsInner virtualHubs() {
        return this.virtualHubs;
    }

    /**
     * The HubVirtualNetworkConnectionsInner object to access its operations.
     */
    private HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections;

    /**
     * Gets the HubVirtualNetworkConnectionsInner object to access its operations.
     * @return the HubVirtualNetworkConnectionsInner object.
     */
    public HubVirtualNetworkConnectionsInner hubVirtualNetworkConnections() {
        return this.hubVirtualNetworkConnections;
    }

    /**
     * The VpnGatewaysInner object to access its operations.
     */
    private VpnGatewaysInner vpnGateways;

    /**
     * Gets the VpnGatewaysInner object to access its operations.
     * @return the VpnGatewaysInner object.
     */
    public VpnGatewaysInner vpnGateways() {
        return this.vpnGateways;
    }

    /**
     * The VpnConnectionsInner object to access its operations.
     */
    private VpnConnectionsInner vpnConnections;

    /**
     * Gets the VpnConnectionsInner object to access its operations.
     * @return the VpnConnectionsInner object.
     */
    public VpnConnectionsInner vpnConnections() {
        return this.vpnConnections;
    }

    /**
     * The VpnSiteLinkConnectionsInner object to access its operations.
     */
    private VpnSiteLinkConnectionsInner vpnSiteLinkConnections;

    /**
     * Gets the VpnSiteLinkConnectionsInner object to access its operations.
     * @return the VpnSiteLinkConnectionsInner object.
     */
    public VpnSiteLinkConnectionsInner vpnSiteLinkConnections() {
        return this.vpnSiteLinkConnections;
    }

    /**
     * The VpnLinkConnectionsInner object to access its operations.
     */
    private VpnLinkConnectionsInner vpnLinkConnections;

    /**
     * Gets the VpnLinkConnectionsInner object to access its operations.
     * @return the VpnLinkConnectionsInner object.
     */
    public VpnLinkConnectionsInner vpnLinkConnections() {
        return this.vpnLinkConnections;
    }

    /**
     * The P2sVpnGatewaysInner object to access its operations.
     */
    private P2sVpnGatewaysInner p2sVpnGateways;

    /**
     * Gets the P2sVpnGatewaysInner object to access its operations.
     * @return the P2sVpnGatewaysInner object.
     */
    public P2sVpnGatewaysInner p2sVpnGateways() {
        return this.p2sVpnGateways;
    }

    /**
     * The VpnServerConfigurationsAssociatedWithVirtualWansInner object to access its operations.
     */
    private VpnServerConfigurationsAssociatedWithVirtualWansInner vpnServerConfigurationsAssociatedWithVirtualWans;

    /**
     * Gets the VpnServerConfigurationsAssociatedWithVirtualWansInner object to access its operations.
     * @return the VpnServerConfigurationsAssociatedWithVirtualWansInner object.
     */
    public VpnServerConfigurationsAssociatedWithVirtualWansInner vpnServerConfigurationsAssociatedWithVirtualWans() {
        return this.vpnServerConfigurationsAssociatedWithVirtualWans;
    }

    /**
     * The VirtualHubRouteTableV2sInner object to access its operations.
     */
    private VirtualHubRouteTableV2sInner virtualHubRouteTableV2s;

    /**
     * Gets the VirtualHubRouteTableV2sInner object to access its operations.
     * @return the VirtualHubRouteTableV2sInner object.
     */
    public VirtualHubRouteTableV2sInner virtualHubRouteTableV2s() {
        return this.virtualHubRouteTableV2s;
    }

    /**
     * The WebApplicationFirewallPoliciesInner object to access its operations.
     */
    private WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies;

    /**
     * Gets the WebApplicationFirewallPoliciesInner object to access its operations.
     * @return the WebApplicationFirewallPoliciesInner object.
     */
    public WebApplicationFirewallPoliciesInner webApplicationFirewallPolicies() {
        return this.webApplicationFirewallPolicies;
    }

    /**
     * Initializes an instance of NetworkManagementClient client.
     *
     * @param credentials the management credentials for Azure
     */
    public NetworkManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    /**
     * Initializes an instance of NetworkManagementClient client.
     *
     * @param baseUrl the base URL of the host
     * @param credentials the management credentials for Azure
     */
    public NetworkManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        initialize();
    }

    /**
     * Initializes an instance of NetworkManagementClient client.
     *
     * @param restClient the REST client to connect to Azure.
     */
    public NetworkManagementClientImpl(RestClient restClient) {
        super(restClient);
        initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.applicationGateways = new ApplicationGatewaysInner(restClient().retrofit(), this);
        this.applicationSecurityGroups = new ApplicationSecurityGroupsInner(restClient().retrofit(), this);
        this.availableDelegations = new AvailableDelegationsInner(restClient().retrofit(), this);
        this.availableResourceGroupDelegations = new AvailableResourceGroupDelegationsInner(restClient().retrofit(), this);
        this.availableServiceAliases = new AvailableServiceAliasesInner(restClient().retrofit(), this);
        this.azureFirewalls = new AzureFirewallsInner(restClient().retrofit(), this);
        this.azureFirewallFqdnTags = new AzureFirewallFqdnTagsInner(restClient().retrofit(), this);
        this.bastionHosts = new BastionHostsInner(restClient().retrofit(), this);
        this.ddosCustomPolicies = new DdosCustomPoliciesInner(restClient().retrofit(), this);
        this.ddosProtectionPlans = new DdosProtectionPlansInner(restClient().retrofit(), this);
        this.availableEndpointServices = new AvailableEndpointServicesInner(restClient().retrofit(), this);
        this.expressRouteCircuitAuthorizations = new ExpressRouteCircuitAuthorizationsInner(restClient().retrofit(), this);
        this.expressRouteCircuitPeerings = new ExpressRouteCircuitPeeringsInner(restClient().retrofit(), this);
        this.expressRouteCircuitConnections = new ExpressRouteCircuitConnectionsInner(restClient().retrofit(), this);
        this.peerExpressRouteCircuitConnections = new PeerExpressRouteCircuitConnectionsInner(restClient().retrofit(), this);
        this.expressRouteCircuits = new ExpressRouteCircuitsInner(restClient().retrofit(), this);
        this.expressRouteServiceProviders = new ExpressRouteServiceProvidersInner(restClient().retrofit(), this);
        this.expressRouteCrossConnections = new ExpressRouteCrossConnectionsInner(restClient().retrofit(), this);
        this.expressRouteCrossConnectionPeerings = new ExpressRouteCrossConnectionPeeringsInner(restClient().retrofit(), this);
        this.expressRouteGateways = new ExpressRouteGatewaysInner(restClient().retrofit(), this);
        this.expressRouteConnections = new ExpressRouteConnectionsInner(restClient().retrofit(), this);
        this.expressRoutePortsLocations = new ExpressRoutePortsLocationsInner(restClient().retrofit(), this);
        this.expressRoutePorts = new ExpressRoutePortsInner(restClient().retrofit(), this);
        this.expressRouteLinks = new ExpressRouteLinksInner(restClient().retrofit(), this);
        this.firewallPolicies = new FirewallPoliciesInner(restClient().retrofit(), this);
        this.firewallPolicyRuleGroups = new FirewallPolicyRuleGroupsInner(restClient().retrofit(), this);
        this.ipGroups = new IpGroupsInner(restClient().retrofit(), this);
        this.loadBalancers = new LoadBalancersInner(restClient().retrofit(), this);
        this.loadBalancerBackendAddressPools = new LoadBalancerBackendAddressPoolsInner(restClient().retrofit(), this);
        this.loadBalancerFrontendIPConfigurations = new LoadBalancerFrontendIPConfigurationsInner(restClient().retrofit(), this);
        this.inboundNatRules = new InboundNatRulesInner(restClient().retrofit(), this);
        this.loadBalancerLoadBalancingRules = new LoadBalancerLoadBalancingRulesInner(restClient().retrofit(), this);
        this.loadBalancerOutboundRules = new LoadBalancerOutboundRulesInner(restClient().retrofit(), this);
        this.loadBalancerNetworkInterfaces = new LoadBalancerNetworkInterfacesInner(restClient().retrofit(), this);
        this.loadBalancerProbes = new LoadBalancerProbesInner(restClient().retrofit(), this);
        this.natGateways = new NatGatewaysInner(restClient().retrofit(), this);
        this.networkInterfaces = new NetworkInterfacesInner(restClient().retrofit(), this);
        this.networkInterfaceIPConfigurations = new NetworkInterfaceIPConfigurationsInner(restClient().retrofit(), this);
        this.networkInterfaceLoadBalancers = new NetworkInterfaceLoadBalancersInner(restClient().retrofit(), this);
        this.networkInterfaceTapConfigurations = new NetworkInterfaceTapConfigurationsInner(restClient().retrofit(), this);
        this.networkProfiles = new NetworkProfilesInner(restClient().retrofit(), this);
        this.networkSecurityGroups = new NetworkSecurityGroupsInner(restClient().retrofit(), this);
        this.securityRules = new SecurityRulesInner(restClient().retrofit(), this);
        this.defaultSecurityRules = new DefaultSecurityRulesInner(restClient().retrofit(), this);
        this.networkWatchers = new NetworkWatchersInner(restClient().retrofit(), this);
        this.packetCaptures = new PacketCapturesInner(restClient().retrofit(), this);
        this.connectionMonitors = new ConnectionMonitorsInner(restClient().retrofit(), this);
        this.flowLogs = new FlowLogsInner(restClient().retrofit(), this);
        this.operations = new OperationsInner(restClient().retrofit(), this);
        this.privateEndpoints = new PrivateEndpointsInner(restClient().retrofit(), this);
        this.availablePrivateEndpointTypes = new AvailablePrivateEndpointTypesInner(restClient().retrofit(), this);
        this.privateLinkServices = new PrivateLinkServicesInner(restClient().retrofit(), this);
        this.publicIPAddresses = new PublicIPAddressesInner(restClient().retrofit(), this);
        this.publicIPPrefixes = new PublicIPPrefixesInner(restClient().retrofit(), this);
        this.routeFilters = new RouteFiltersInner(restClient().retrofit(), this);
        this.routeFilterRules = new RouteFilterRulesInner(restClient().retrofit(), this);
        this.routeTables = new RouteTablesInner(restClient().retrofit(), this);
        this.routes = new RoutesInner(restClient().retrofit(), this);
        this.bgpServiceCommunities = new BgpServiceCommunitiesInner(restClient().retrofit(), this);
        this.serviceEndpointPolicies = new ServiceEndpointPoliciesInner(restClient().retrofit(), this);
        this.serviceEndpointPolicyDefinitions = new ServiceEndpointPolicyDefinitionsInner(restClient().retrofit(), this);
        this.serviceTags = new ServiceTagsInner(restClient().retrofit(), this);
        this.usages = new UsagesInner(restClient().retrofit(), this);
        this.virtualNetworks = new VirtualNetworksInner(restClient().retrofit(), this);
        this.subnets = new SubnetsInner(restClient().retrofit(), this);
        this.resourceNavigationLinks = new ResourceNavigationLinksInner(restClient().retrofit(), this);
        this.serviceAssociationLinks = new ServiceAssociationLinksInner(restClient().retrofit(), this);
        this.virtualNetworkPeerings = new VirtualNetworkPeeringsInner(restClient().retrofit(), this);
        this.virtualNetworkGateways = new VirtualNetworkGatewaysInner(restClient().retrofit(), this);
        this.virtualNetworkGatewayConnections = new VirtualNetworkGatewayConnectionsInner(restClient().retrofit(), this);
        this.localNetworkGateways = new LocalNetworkGatewaysInner(restClient().retrofit(), this);
        this.virtualNetworkTaps = new VirtualNetworkTapsInner(restClient().retrofit(), this);
        this.virtualRouters = new VirtualRoutersInner(restClient().retrofit(), this);
        this.virtualRouterPeerings = new VirtualRouterPeeringsInner(restClient().retrofit(), this);
        this.virtualWans = new VirtualWansInner(restClient().retrofit(), this);
        this.vpnSites = new VpnSitesInner(restClient().retrofit(), this);
        this.vpnSiteLinks = new VpnSiteLinksInner(restClient().retrofit(), this);
        this.vpnSitesConfigurations = new VpnSitesConfigurationsInner(restClient().retrofit(), this);
        this.vpnServerConfigurations = new VpnServerConfigurationsInner(restClient().retrofit(), this);
        this.virtualHubs = new VirtualHubsInner(restClient().retrofit(), this);
        this.hubVirtualNetworkConnections = new HubVirtualNetworkConnectionsInner(restClient().retrofit(), this);
        this.vpnGateways = new VpnGatewaysInner(restClient().retrofit(), this);
        this.vpnConnections = new VpnConnectionsInner(restClient().retrofit(), this);
        this.vpnSiteLinkConnections = new VpnSiteLinkConnectionsInner(restClient().retrofit(), this);
        this.vpnLinkConnections = new VpnLinkConnectionsInner(restClient().retrofit(), this);
        this.p2sVpnGateways = new P2sVpnGatewaysInner(restClient().retrofit(), this);
        this.vpnServerConfigurationsAssociatedWithVirtualWans = new VpnServerConfigurationsAssociatedWithVirtualWansInner(restClient().retrofit(), this);
        this.virtualHubRouteTableV2s = new VirtualHubRouteTableV2sInner(restClient().retrofit(), this);
        this.webApplicationFirewallPolicies = new WebApplicationFirewallPoliciesInner(restClient().retrofit(), this);
        this.azureClient = new AzureClient(this);
        initializeService();
    }

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    @Override
    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "NetworkManagementClient");
    }

    private void initializeService() {
        service = restClient().retrofit().create(NetworkManagementClientService.class);
    }

    /**
     * The interface defining all the services for NetworkManagementClient to be
     * used by Retrofit to perform actually REST calls.
     */
    interface NetworkManagementClientService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient putBastionShareableLink" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/createShareableLinks")
        Observable<Response<ResponseBody>> putBastionShareableLink(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BastionShareableLinkListRequest bslRequest, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginPutBastionShareableLink" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/createShareableLinks")
        Observable<Response<ResponseBody>> beginPutBastionShareableLink(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BastionShareableLinkListRequest bslRequest, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient deleteBastionShareableLink" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/deleteShareableLinks")
        Observable<Response<ResponseBody>> deleteBastionShareableLink(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BastionShareableLinkListRequest bslRequest, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginDeleteBastionShareableLink" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/deleteShareableLinks")
        Observable<Response<ResponseBody>> beginDeleteBastionShareableLink(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BastionShareableLinkListRequest bslRequest, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getBastionShareableLink" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/getShareableLinks")
        Observable<Response<ResponseBody>> getBastionShareableLink(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BastionShareableLinkListRequest bslRequest, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getActiveSessions" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/getActiveSessions")
        Observable<Response<ResponseBody>> getActiveSessions(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginGetActiveSessions" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/getActiveSessions")
        Observable<Response<ResponseBody>> beginGetActiveSessions(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient disconnectActiveSessions" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}/disconnectActiveSessions")
        Observable<Response<ResponseBody>> disconnectActiveSessions(@Path("resourceGroupName") String resourceGroupName, @Path("bastionHostName") String bastionHostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SessionIds sessionIds, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient checkDnsNameAvailability" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/CheckDnsNameAvailability")
        Observable<Response<ResponseBody>> checkDnsNameAvailability(@Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("domainNameLabel") String domainNameLabel, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient supportedSecurityProviders" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/supportedSecurityProviders")
        Observable<Response<ResponseBody>> supportedSecurityProviders(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient generatevirtualwanvpnserverconfigurationvpnprofile" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/GenerateVpnProfile")
        Observable<Response<ResponseBody>> generatevirtualwanvpnserverconfigurationvpnprofile(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWANName") String virtualWANName, @Body VirtualWanVpnProfileParameters vpnClientParams, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginGeneratevirtualwanvpnserverconfigurationvpnprofile" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/GenerateVpnProfile")
        Observable<Response<ResponseBody>> beginGeneratevirtualwanvpnserverconfigurationvpnprofile(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualWANName") String virtualWANName, @Body VirtualWanVpnProfileParameters vpnClientParams, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient putBastionShareableLinkNext" })
        @GET
        Observable<Response<ResponseBody>> putBastionShareableLinkNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginPutBastionShareableLinkNext" })
        @GET
        Observable<Response<ResponseBody>> beginPutBastionShareableLinkNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getBastionShareableLinkNext" })
        @GET
        Observable<Response<ResponseBody>> getBastionShareableLinkNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient getActiveSessionsNext" })
        @GET
        Observable<Response<ResponseBody>> getActiveSessionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient beginGetActiveSessionsNext" })
        @GET
        Observable<Response<ResponseBody>> beginGetActiveSessionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkManagementClient disconnectActiveSessionsNext" })
        @GET
        Observable<Response<ResponseBody>> disconnectActiveSessionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> putBastionShareableLink(final String resourceGroupName, final String bastionHostName) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> putBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return putBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> putBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName) {
        return putBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName) {
        return putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkSinglePageAsync(final String resourceGroupName, final String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final List<BastionShareableLinkInner> vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return service.putBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = putBastionShareableLinkDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> putBastionShareableLink(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> putBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return putBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> putBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        return putBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        return putBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param bastionHostName The name of the Bastion Host.
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkSinglePageAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        final String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return service.putBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = putBastionShareableLinkDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> putBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionShareableLinkInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> beginPutBastionShareableLink(final String resourceGroupName, final String bastionHostName) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName) {
        return beginPutBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName) {
        return beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkSinglePageAsync(final String resourceGroupName, final String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final List<BastionShareableLinkInner> vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return service.beginPutBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = beginPutBastionShareableLinkDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> beginPutBastionShareableLink(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> beginPutBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        return beginPutBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        return beginPutBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param bastionHostName The name of the Bastion Host.
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkSinglePageAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        final String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return service.beginPutBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = beginPutBastionShareableLinkDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> beginPutBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionShareableLinkInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteBastionShareableLink(String resourceGroupName, String bastionHostName) {
        deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().last().body();
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName) {
        return deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String vmsConverted = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        Observable<Response<ResponseBody>> observable = service.deleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent());
        return getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>() { }.getType());
    }
    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteBastionShareableLink(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).toBlocking().last().body();
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms), serviceCallback);
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return deleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        final String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        Observable<Response<ResponseBody>> observable = service.deleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent());
        return getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteBastionShareableLink(String resourceGroupName, String bastionHostName) {
        beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().single().body();
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName) {
        return beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final List<BastionShareableLinkInner> vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return service.beginDeleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteBastionShareableLinkDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteBastionShareableLink(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).toBlocking().single().body();
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms), serviceCallback);
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteBastionShareableLinkAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        return beginDeleteBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteBastionShareableLinkWithServiceResponseAsync(String resourceGroupName, String bastionHostName, List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        final String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return service.beginDeleteBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteBastionShareableLinkDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> getBastionShareableLink(final String resourceGroupName, final String bastionHostName) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> getBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return getBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> getBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName) {
        return getBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName) {
        return getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkSinglePageAsync(final String resourceGroupName, final String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final List<BastionShareableLinkInner> vms = null;
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(null);
        return service.getBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = getBastionShareableLinkDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> getBastionShareableLink(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> getBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return getBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> getBastionShareableLinkAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        return getBastionShareableLinkWithServiceResponseAsync(resourceGroupName, bastionHostName, vms)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        return getBastionShareableLinkSinglePageAsync(resourceGroupName, bastionHostName, vms)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param bastionHostName The name of the Bastion Host.
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param vms List of VM references.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkSinglePageAsync(final String resourceGroupName, final String bastionHostName, final List<BastionShareableLinkInner> vms) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(vms);
        final String apiVersion = "2019-11-01";
        BastionShareableLinkListRequest bslRequest = new BastionShareableLinkListRequest();
        bslRequest.withVms(vms);
        return service.getBastionShareableLink(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), bslRequest, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = getBastionShareableLinkDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> getBastionShareableLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionShareableLinkInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object if successful.
     */
    public PagedList<BastionActiveSessionInner> getActiveSessions(final String resourceGroupName, final String bastionHostName) {
        ServiceResponse<Page<BastionActiveSessionInner>> response = getActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>(response.body()) {
            @Override
            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return getActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionActiveSessionInner>> getActiveSessionsAsync(final String resourceGroupName, final String bastionHostName, final ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName),
            new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                    return getActiveSessionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<Page<BastionActiveSessionInner>> getActiveSessionsAsync(final String resourceGroupName, final String bastionHostName) {
        return getActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName)
            .map(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>() {
                @Override
                public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName) {
        return getActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName)
            .concatMap(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getActiveSessionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
    ServiceResponse<PageImpl<BastionActiveSessionInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<BastionActiveSessionInner>> * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsSinglePageAsync(final String resourceGroupName, final String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionActiveSessionInner>> result = getActiveSessionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionActiveSessionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> getActiveSessionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionActiveSessionInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object if successful.
     */
    public PagedList<BastionActiveSessionInner> beginGetActiveSessions(final String resourceGroupName, final String bastionHostName) {
        ServiceResponse<Page<BastionActiveSessionInner>> response = beginGetActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>(response.body()) {
            @Override
            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return beginGetActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionActiveSessionInner>> beginGetActiveSessionsAsync(final String resourceGroupName, final String bastionHostName, final ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginGetActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName),
            new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                    return beginGetActiveSessionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<Page<BastionActiveSessionInner>> beginGetActiveSessionsAsync(final String resourceGroupName, final String bastionHostName) {
        return beginGetActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName)
            .map(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>() {
                @Override
                public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName) {
        return beginGetActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName)
            .concatMap(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginGetActiveSessionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
    ServiceResponse<PageImpl<BastionActiveSessionInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<BastionActiveSessionInner>> * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsSinglePageAsync(final String resourceGroupName, final String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginGetActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionActiveSessionInner>> result = beginGetActiveSessionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionActiveSessionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> beginGetActiveSessionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionActiveSessionInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionSessionStateInner&gt; object if successful.
     */
    public PagedList<BastionSessionStateInner> disconnectActiveSessions(final String resourceGroupName, final String bastionHostName) {
        ServiceResponse<Page<BastionSessionStateInner>> response = disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName).toBlocking().single();
        return new PagedList<BastionSessionStateInner>(response.body()) {
            @Override
            public Page<BastionSessionStateInner> nextPage(String nextPageLink) {
                return disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionSessionStateInner>> disconnectActiveSessionsAsync(final String resourceGroupName, final String bastionHostName, final ListOperationCallback<BastionSessionStateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName),
            new Func1<String, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(String nextPageLink) {
                    return disconnectActiveSessionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionSessionStateInner&gt; object
     */
    public Observable<Page<BastionSessionStateInner>> disconnectActiveSessionsAsync(final String resourceGroupName, final String bastionHostName) {
        return disconnectActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName)
            .map(new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Page<BastionSessionStateInner>>() {
                @Override
                public Page<BastionSessionStateInner> call(ServiceResponse<Page<BastionSessionStateInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionSessionStateInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName) {
        return disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName)
            .concatMap(new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(ServiceResponse<Page<BastionSessionStateInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionSessionStateInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsSinglePageAsync(final String resourceGroupName, final String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final List<String> sessionIds = null;
        SessionIds sessionIds1 = new SessionIds();
        sessionIds1.withSessionIds(null);
        return service.disconnectActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), sessionIds1, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionSessionStateInner>> result = disconnectActiveSessionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionSessionStateInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param sessionIds List of session IDs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionSessionStateInner&gt; object if successful.
     */
    public PagedList<BastionSessionStateInner> disconnectActiveSessions(final String resourceGroupName, final String bastionHostName, final List<String> sessionIds) {
        ServiceResponse<Page<BastionSessionStateInner>> response = disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName, sessionIds).toBlocking().single();
        return new PagedList<BastionSessionStateInner>(response.body()) {
            @Override
            public Page<BastionSessionStateInner> nextPage(String nextPageLink) {
                return disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param sessionIds List of session IDs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionSessionStateInner>> disconnectActiveSessionsAsync(final String resourceGroupName, final String bastionHostName, final List<String> sessionIds, final ListOperationCallback<BastionSessionStateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName, sessionIds),
            new Func1<String, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(String nextPageLink) {
                    return disconnectActiveSessionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param sessionIds List of session IDs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionSessionStateInner&gt; object
     */
    public Observable<Page<BastionSessionStateInner>> disconnectActiveSessionsAsync(final String resourceGroupName, final String bastionHostName, final List<String> sessionIds) {
        return disconnectActiveSessionsWithServiceResponseAsync(resourceGroupName, bastionHostName, sessionIds)
            .map(new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Page<BastionSessionStateInner>>() {
                @Override
                public Page<BastionSessionStateInner> call(ServiceResponse<Page<BastionSessionStateInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param resourceGroupName The name of the resource group.
     * @param bastionHostName The name of the Bastion Host.
     * @param sessionIds List of session IDs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionSessionStateInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsWithServiceResponseAsync(final String resourceGroupName, final String bastionHostName, final List<String> sessionIds) {
        return disconnectActiveSessionsSinglePageAsync(resourceGroupName, bastionHostName, sessionIds)
            .concatMap(new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(ServiceResponse<Page<BastionSessionStateInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
    ServiceResponse<PageImpl<BastionSessionStateInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<BastionSessionStateInner>> * @param bastionHostName The name of the Bastion Host.
    ServiceResponse<PageImpl<BastionSessionStateInner>> * @param sessionIds List of session IDs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionSessionStateInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsSinglePageAsync(final String resourceGroupName, final String bastionHostName, final List<String> sessionIds) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(sessionIds);
        final String apiVersion = "2019-11-01";
        SessionIds sessionIds1 = new SessionIds();
        sessionIds1.withSessionIds(sessionIds);
        return service.disconnectActiveSessions(resourceGroupName, bastionHostName, this.subscriptionId(), apiVersion, this.acceptLanguage(), sessionIds1, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionSessionStateInner>> result = disconnectActiveSessionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionSessionStateInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionSessionStateInner>> disconnectActiveSessionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionSessionStateInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionSessionStateInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DnsNameAvailabilityResultInner object if successful.
     */
    public DnsNameAvailabilityResultInner checkDnsNameAvailability(String location, String domainNameLabel) {
        return checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).toBlocking().single().body();
    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel, final ServiceCallback<DnsNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel), serviceCallback);
    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DnsNameAvailabilityResultInner object
     */
    public Observable<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityAsync(String location, String domainNameLabel) {
        return checkDnsNameAvailabilityWithServiceResponseAsync(location, domainNameLabel).map(new Func1<ServiceResponse<DnsNameAvailabilityResultInner>, DnsNameAvailabilityResultInner>() {
            @Override
            public DnsNameAvailabilityResultInner call(ServiceResponse<DnsNameAvailabilityResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether a domain name in the cloudapp.azure.com zone is available for use.
     *
     * @param location The location of the domain name.
     * @param domainNameLabel The domain name to be verified. It must conform to the following regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DnsNameAvailabilityResultInner object
     */
    public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> checkDnsNameAvailabilityWithServiceResponseAsync(String location, String domainNameLabel) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (domainNameLabel == null) {
            throw new IllegalArgumentException("Parameter domainNameLabel is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.checkDnsNameAvailability(location, this.subscriptionId(), domainNameLabel, apiVersion, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DnsNameAvailabilityResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DnsNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DnsNameAvailabilityResultInner> clientResponse = checkDnsNameAvailabilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DnsNameAvailabilityResultInner> checkDnsNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<DnsNameAvailabilityResultInner, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<DnsNameAvailabilityResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWanSecurityProvidersInner object if successful.
     */
    public VirtualWanSecurityProvidersInner supportedSecurityProviders(String resourceGroupName, String virtualWANName) {
        return supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single().body();
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName, final ServiceCallback<VirtualWanSecurityProvidersInner> serviceCallback) {
        return ServiceFuture.fromResponse(supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWanSecurityProvidersInner object
     */
    public Observable<VirtualWanSecurityProvidersInner> supportedSecurityProvidersAsync(String resourceGroupName, String virtualWANName) {
        return supportedSecurityProvidersWithServiceResponseAsync(resourceGroupName, virtualWANName).map(new Func1<ServiceResponse<VirtualWanSecurityProvidersInner>, VirtualWanSecurityProvidersInner>() {
            @Override
            public VirtualWanSecurityProvidersInner call(ServiceResponse<VirtualWanSecurityProvidersInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gives the supported security providers for the virtual wan.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN for which supported security providers are needed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWanSecurityProvidersInner object
     */
    public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> supportedSecurityProvidersWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.supportedSecurityProviders(this.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWanSecurityProvidersInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualWanSecurityProvidersInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualWanSecurityProvidersInner> clientResponse = supportedSecurityProvidersDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualWanSecurityProvidersInner> supportedSecurityProvidersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<VirtualWanSecurityProvidersInner, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<VirtualWanSecurityProvidersInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnProfileResponseInner object if successful.
     */
    public VpnProfileResponseInner generatevirtualwanvpnserverconfigurationvpnprofile(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).toBlocking().last().body();
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnProfileResponseInner> generatevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams, final ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams), serviceCallback);
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VpnProfileResponseInner> generatevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).map(new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>() {
            @Override
            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VpnProfileResponseInner>> generatevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (vpnClientParams == null) {
            throw new IllegalArgumentException("Parameter vpnClientParams is required and cannot be null.");
        }
        Validator.validate(vpnClientParams);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.generatevirtualwanvpnserverconfigurationvpnprofile(this.subscriptionId(), resourceGroupName, virtualWANName, vpnClientParams, apiVersion, this.acceptLanguage(), this.userAgent());
        return getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnProfileResponseInner>() { }.getType());
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnProfileResponseInner object if successful.
     */
    public VpnProfileResponseInner beginGeneratevirtualwanvpnserverconfigurationvpnprofile(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).toBlocking().single().body();
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnProfileResponseInner> beginGeneratevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams, final ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams), serviceCallback);
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnProfileResponseInner object
     */
    public Observable<VpnProfileResponseInner> beginGeneratevirtualwanvpnserverconfigurationvpnprofileAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        return beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(resourceGroupName, virtualWANName, vpnClientParams).map(new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>() {
            @Override
            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Generates a unique VPN profile for P2S clients for VirtualWan and associated VpnServerConfiguration combination in the specified resource group.
     *
     * @param resourceGroupName The resource group name.
     * @param virtualWANName The name of the VirtualWAN whose associated VpnServerConfigurations is needed.
     * @param vpnClientParams Parameters supplied to the generate VirtualWan VPN profile generation operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnProfileResponseInner object
     */
    public Observable<ServiceResponse<VpnProfileResponseInner>> beginGeneratevirtualwanvpnserverconfigurationvpnprofileWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWanVpnProfileParameters vpnClientParams) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (vpnClientParams == null) {
            throw new IllegalArgumentException("Parameter vpnClientParams is required and cannot be null.");
        }
        Validator.validate(vpnClientParams);
        final String apiVersion = "2019-11-01";
        return service.beginGeneratevirtualwanvpnserverconfigurationvpnprofile(this.subscriptionId(), resourceGroupName, virtualWANName, vpnClientParams, apiVersion, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnProfileResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnProfileResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnProfileResponseInner> clientResponse = beginGeneratevirtualwanvpnserverconfigurationvpnprofileDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnProfileResponseInner> beginGeneratevirtualwanvpnserverconfigurationvpnprofileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<VpnProfileResponseInner, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<VpnProfileResponseInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> putBastionShareableLinkNext(final String nextPageLink) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return putBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> putBastionShareableLinkNextAsync(final String nextPageLink, final ServiceFuture<List<BastionShareableLinkInner>> serviceFuture, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            putBastionShareableLinkNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return putBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> putBastionShareableLinkNextAsync(final String nextPageLink) {
        return putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkNextWithServiceResponseAsync(final String nextPageLink) {
        return putBastionShareableLinkNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(putBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> putBastionShareableLinkNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.putBastionShareableLinkNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = putBastionShareableLinkNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> putBastionShareableLinkNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionShareableLinkInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> beginPutBastionShareableLinkNext(final String nextPageLink) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> beginPutBastionShareableLinkNextAsync(final String nextPageLink, final ServiceFuture<List<BastionShareableLinkInner>> serviceFuture, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> beginPutBastionShareableLinkNextAsync(final String nextPageLink) {
        return beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkNextWithServiceResponseAsync(final String nextPageLink) {
        return beginPutBastionShareableLinkNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginPutBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Creates a Bastion Shareable Links for all the VMs specified in the request.
     *
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> beginPutBastionShareableLinkNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.beginPutBastionShareableLinkNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = beginPutBastionShareableLinkNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> beginPutBastionShareableLinkNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionShareableLinkInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object if successful.
     */
    public PagedList<BastionShareableLinkInner> getBastionShareableLinkNext(final String nextPageLink) {
        ServiceResponse<Page<BastionShareableLinkInner>> response = getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionShareableLinkInner>(response.body()) {
            @Override
            public Page<BastionShareableLinkInner> nextPage(String nextPageLink) {
                return getBastionShareableLinkNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionShareableLinkInner>> getBastionShareableLinkNextAsync(final String nextPageLink, final ServiceFuture<List<BastionShareableLinkInner>> serviceFuture, final ListOperationCallback<BastionShareableLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getBastionShareableLinkNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(String nextPageLink) {
                    return getBastionShareableLinkNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<Page<BastionShareableLinkInner>> getBastionShareableLinkNextAsync(final String nextPageLink) {
        return getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Page<BastionShareableLinkInner>>() {
                @Override
                public Page<BastionShareableLinkInner> call(ServiceResponse<Page<BastionShareableLinkInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionShareableLinkInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkNextWithServiceResponseAsync(final String nextPageLink) {
        return getBastionShareableLinkNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionShareableLinkInner>>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(ServiceResponse<Page<BastionShareableLinkInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getBastionShareableLinkNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Return the Bastion Shareable Links for all the VMs specified in the request.
     *
    ServiceResponse<PageImpl<BastionShareableLinkInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionShareableLinkInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> getBastionShareableLinkNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.getBastionShareableLinkNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionShareableLinkInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionShareableLinkInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionShareableLinkInner>> result = getBastionShareableLinkNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionShareableLinkInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionShareableLinkInner>> getBastionShareableLinkNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionShareableLinkInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionShareableLinkInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object if successful.
     */
    public PagedList<BastionActiveSessionInner> getActiveSessionsNext(final String nextPageLink) {
        ServiceResponse<Page<BastionActiveSessionInner>> response = getActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>(response.body()) {
            @Override
            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return getActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionActiveSessionInner>> getActiveSessionsNextAsync(final String nextPageLink, final ServiceFuture<List<BastionActiveSessionInner>> serviceFuture, final ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            getActiveSessionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                    return getActiveSessionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<Page<BastionActiveSessionInner>> getActiveSessionsNextAsync(final String nextPageLink) {
        return getActiveSessionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>() {
                @Override
                public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsNextWithServiceResponseAsync(final String nextPageLink) {
        return getActiveSessionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getActiveSessionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
    ServiceResponse<PageImpl<BastionActiveSessionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> getActiveSessionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.getActiveSessionsNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionActiveSessionInner>> result = getActiveSessionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionActiveSessionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> getActiveSessionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException, InterruptedException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionActiveSessionInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object if successful.
     */
    public PagedList<BastionActiveSessionInner> beginGetActiveSessionsNext(final String nextPageLink) {
        ServiceResponse<Page<BastionActiveSessionInner>> response = beginGetActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionActiveSessionInner>(response.body()) {
            @Override
            public Page<BastionActiveSessionInner> nextPage(String nextPageLink) {
                return beginGetActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionActiveSessionInner>> beginGetActiveSessionsNextAsync(final String nextPageLink, final ServiceFuture<List<BastionActiveSessionInner>> serviceFuture, final ListOperationCallback<BastionActiveSessionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginGetActiveSessionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(String nextPageLink) {
                    return beginGetActiveSessionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<Page<BastionActiveSessionInner>> beginGetActiveSessionsNextAsync(final String nextPageLink) {
        return beginGetActiveSessionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Page<BastionActiveSessionInner>>() {
                @Override
                public Page<BastionActiveSessionInner> call(ServiceResponse<Page<BastionActiveSessionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionActiveSessionInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsNextWithServiceResponseAsync(final String nextPageLink) {
        return beginGetActiveSessionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionActiveSessionInner>>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(ServiceResponse<Page<BastionActiveSessionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginGetActiveSessionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
    ServiceResponse<PageImpl<BastionActiveSessionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionActiveSessionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> beginGetActiveSessionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.beginGetActiveSessionsNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionActiveSessionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionActiveSessionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionActiveSessionInner>> result = beginGetActiveSessionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionActiveSessionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionActiveSessionInner>> beginGetActiveSessionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionActiveSessionInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionActiveSessionInner>>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BastionSessionStateInner&gt; object if successful.
     */
    public PagedList<BastionSessionStateInner> disconnectActiveSessionsNext(final String nextPageLink) {
        ServiceResponse<Page<BastionSessionStateInner>> response = disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionSessionStateInner>(response.body()) {
            @Override
            public Page<BastionSessionStateInner> nextPage(String nextPageLink) {
                return disconnectActiveSessionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BastionSessionStateInner>> disconnectActiveSessionsNextAsync(final String nextPageLink, final ServiceFuture<List<BastionSessionStateInner>> serviceFuture, final ListOperationCallback<BastionSessionStateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            disconnectActiveSessionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(String nextPageLink) {
                    return disconnectActiveSessionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionSessionStateInner&gt; object
     */
    public Observable<Page<BastionSessionStateInner>> disconnectActiveSessionsNextAsync(final String nextPageLink) {
        return disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Page<BastionSessionStateInner>>() {
                @Override
                public Page<BastionSessionStateInner> call(ServiceResponse<Page<BastionSessionStateInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BastionSessionStateInner&gt; object
     */
    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsNextWithServiceResponseAsync(final String nextPageLink) {
        return disconnectActiveSessionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BastionSessionStateInner>>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(ServiceResponse<Page<BastionSessionStateInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(disconnectActiveSessionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns the list of currently active sessions on the Bastion.
     *
    ServiceResponse<PageImpl<BastionSessionStateInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BastionSessionStateInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BastionSessionStateInner>>> disconnectActiveSessionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.disconnectActiveSessionsNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionSessionStateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BastionSessionStateInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BastionSessionStateInner>> result = disconnectActiveSessionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BastionSessionStateInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BastionSessionStateInner>> disconnectActiveSessionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BastionSessionStateInner>, CloudException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BastionSessionStateInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
