/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualNetworkTaps.
 */
public class VirtualNetworkTapsInner implements InnerSupportsGet<VirtualNetworkTapInner>, InnerSupportsDelete<Void>, InnerSupportsListing<VirtualNetworkTapInner> {
    /** The Retrofit service to perform REST calls. */
    private VirtualNetworkTapsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VirtualNetworkTapsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualNetworkTapsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VirtualNetworkTapsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualNetworkTaps to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualNetworkTapsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("tapName") String tapName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("tapName") String tapName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("tapName") String tapName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("tapName") String tapName, @Path("subscriptionId") String subscriptionId, @Body VirtualNetworkTapInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("tapName") String tapName, @Path("subscriptionId") String subscriptionId, @Body VirtualNetworkTapInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        Observable<Response<ResponseBody>> updateTags(@Path("resourceGroupName") String resourceGroupName, @Path("tapName") String tapName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject tapParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualNetworkTaps")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String tapName) {
        deleteWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().last().body();
    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String tapName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String tapName) {
        return deleteWithServiceResponseAsync(resourceGroupName, tapName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, tapName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String tapName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().single().body();
    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String tapName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String tapName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, tapName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, tapName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualNetworkTapInner object if successful.
     */
    public VirtualNetworkTapInner getByResourceGroup(String resourceGroupName, String tapName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().single().body();
    }

    /**
     * Gets information about the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of virtual network tap.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualNetworkTapInner> getByResourceGroupAsync(String resourceGroupName, String tapName, final ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    /**
     * Gets information about the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<VirtualNetworkTapInner> getByResourceGroupAsync(String resourceGroupName, String tapName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, tapName).map(new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>() {
            @Override
            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about the specified virtual network tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of virtual network tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<ServiceResponse<VirtualNetworkTapInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(resourceGroupName, tapName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualNetworkTapInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualNetworkTapInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualNetworkTapInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualNetworkTapInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualNetworkTapInner object if successful.
     */
    public VirtualNetworkTapInner createOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualNetworkTapInner> createOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, final ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualNetworkTapInner> createOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).map(new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>() {
            @Override
            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualNetworkTapInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, tapName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkTapInner>() { }.getType());
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualNetworkTapInner object if successful.
     */
    public VirtualNetworkTapInner beginCreateOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualNetworkTapInner> beginCreateOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, final ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<VirtualNetworkTapInner> beginCreateOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).map(new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>() {
            @Override
            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a Virtual Network Tap.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the virtual network tap.
     * @param parameters Parameters supplied to the create or update virtual network tap operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<ServiceResponse<VirtualNetworkTapInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, tapName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualNetworkTapInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualNetworkTapInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualNetworkTapInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualNetworkTapInner>() { }.getType())
                .register(201, new TypeToken<VirtualNetworkTapInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualNetworkTapInner object if successful.
     */
    public VirtualNetworkTapInner updateTags(String resourceGroupName, String tapName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().single().body();
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName, final ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, tapName).map(new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>() {
            @Override
            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<ServiceResponse<VirtualNetworkTapInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final Map<String, String> tags = null;
        TagsObject tapParameters = new TagsObject();
        tapParameters.withTags(null);
        return service.updateTags(resourceGroupName, tapName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), tapParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualNetworkTapInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualNetworkTapInner object if successful.
     */
    public VirtualNetworkTapInner updateTags(String resourceGroupName, String tapName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags).toBlocking().single().body();
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName, Map<String, String> tags, final ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags), serviceCallback);
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags).map(new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>() {
            @Override
            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an VirtualNetworkTap tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param tapName The name of the tap.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualNetworkTapInner object
     */
    public Observable<ServiceResponse<VirtualNetworkTapInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String tapName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-11-01";
        TagsObject tapParameters = new TagsObject();
        tapParameters.withTags(tags);
        return service.updateTags(resourceGroupName, tapName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), tapParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualNetworkTapInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualNetworkTapInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualNetworkTapInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualNetworkTapInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object if successful.
     */
    public PagedList<VirtualNetworkTapInner> list() {
        ServiceResponse<Page<VirtualNetworkTapInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>(response.body()) {
            @Override
            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualNetworkTapInner>> listAsync(final ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<Page<VirtualNetworkTapInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>() {
                @Override
                public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualNetworkTapInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualNetworkTapInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualNetworkTapInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object if successful.
     */
    public PagedList<VirtualNetworkTapInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VirtualNetworkTapInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>(response.body()) {
            @Override
            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualNetworkTapInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<Page<VirtualNetworkTapInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>() {
                @Override
                public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
    ServiceResponse<PageImpl<VirtualNetworkTapInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualNetworkTapInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualNetworkTapInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualNetworkTapInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object if successful.
     */
    public PagedList<VirtualNetworkTapInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualNetworkTapInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>(response.body()) {
            @Override
            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualNetworkTapInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualNetworkTapInner>> serviceFuture, final ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<Page<VirtualNetworkTapInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>() {
                @Override
                public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
    ServiceResponse<PageImpl<VirtualNetworkTapInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualNetworkTapInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualNetworkTapInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualNetworkTapInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object if successful.
     */
    public PagedList<VirtualNetworkTapInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualNetworkTapInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>(response.body()) {
            @Override
            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualNetworkTapInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualNetworkTapInner>> serviceFuture, final ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<Page<VirtualNetworkTapInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>() {
                @Override
                public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualNetworkTapInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the VirtualNetworkTaps in a subscription.
     *
    ServiceResponse<PageImpl<VirtualNetworkTapInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualNetworkTapInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualNetworkTapInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualNetworkTapInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualNetworkTapInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
