/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualRouters.
 */
public class VirtualRoutersInner implements InnerSupportsGet<VirtualRouterInner>, InnerSupportsDelete<Void>, InnerSupportsListing<VirtualRouterInner> {
    /** The Retrofit service to perform REST calls. */
    private VirtualRoutersService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VirtualRoutersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualRoutersInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VirtualRoutersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualRouters to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualRoutersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("subscriptionId") String subscriptionId, @Body VirtualRouterInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("subscriptionId") String subscriptionId, @Body VirtualRouterInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualRouters")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouters listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String virtualRouterName) {
        deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).toBlocking().last().body();
    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualRouterName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName), serviceCallback);
    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String virtualRouterName) {
        return deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, virtualRouterName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String virtualRouterName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).toBlocking().single().body();
    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName), serviceCallback);
    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, virtualRouterName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualRouterInner object if successful.
     */
    public VirtualRouterInner getByResourceGroup(String resourceGroupName, String virtualRouterName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName).toBlocking().single().body();
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName, final ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName), serviceCallback);
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterInner object
     */
    public Observable<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName).map(new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>() {
            @Override
            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterInner object
     */
    public Observable<ServiceResponse<VirtualRouterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String expand = null;
        return service.getByResourceGroup(resourceGroupName, virtualRouterName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualRouterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualRouterInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualRouterInner object if successful.
     */
    public VirtualRouterInner getByResourceGroup(String resourceGroupName, String virtualRouterName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName, expand).toBlocking().single().body();
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param expand Expands referenced resources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName, String expand, final ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName, expand), serviceCallback);
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterInner object
     */
    public Observable<VirtualRouterInner> getByResourceGroupAsync(String resourceGroupName, String virtualRouterName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualRouterName, expand).map(new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>() {
            @Override
            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterInner object
     */
    public Observable<ServiceResponse<VirtualRouterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(resourceGroupName, virtualRouterName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualRouterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualRouterInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualRouterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualRouterInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualRouterInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualRouterInner object if successful.
     */
    public VirtualRouterInner createOrUpdate(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualRouterInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters, final ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualRouterInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).map(new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>() {
            @Override
            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualRouterInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, virtualRouterName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualRouterInner>() { }.getType());
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualRouterInner object if successful.
     */
    public VirtualRouterInner beginCreateOrUpdate(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualRouterInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters, final ServiceCallback<VirtualRouterInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterInner object
     */
    public Observable<VirtualRouterInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, parameters).map(new Func1<ServiceResponse<VirtualRouterInner>, VirtualRouterInner>() {
            @Override
            public VirtualRouterInner call(ServiceResponse<VirtualRouterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param parameters Parameters supplied to the create or update Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterInner object
     */
    public Observable<ServiceResponse<VirtualRouterInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, VirtualRouterInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, virtualRouterName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualRouterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualRouterInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualRouterInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualRouterInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualRouterInner>() { }.getType())
                .register(201, new TypeToken<VirtualRouterInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualRouterInner&gt; object if successful.
     */
    public PagedList<VirtualRouterInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VirtualRouterInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualRouterInner>(response.body()) {
            @Override
            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualRouterInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<Page<VirtualRouterInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>() {
                @Override
                public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
    ServiceResponse<PageImpl<VirtualRouterInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualRouterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualRouterInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualRouterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualRouterInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualRouterInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualRouterInner&gt; object if successful.
     */
    public PagedList<VirtualRouterInner> list() {
        ServiceResponse<Page<VirtualRouterInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualRouterInner>(response.body()) {
            @Override
            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualRouterInner>> listAsync(final ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<Page<VirtualRouterInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>() {
                @Override
                public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualRouterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualRouterInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualRouterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualRouterInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualRouterInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualRouterInner&gt; object if successful.
     */
    public PagedList<VirtualRouterInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualRouterInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualRouterInner>(response.body()) {
            @Override
            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualRouterInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualRouterInner>> serviceFuture, final ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<Page<VirtualRouterInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>() {
                @Override
                public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Virtual Routers in a resource group.
     *
    ServiceResponse<PageImpl<VirtualRouterInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualRouterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualRouterInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualRouterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualRouterInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualRouterInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualRouterInner&gt; object if successful.
     */
    public PagedList<VirtualRouterInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualRouterInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualRouterInner>(response.body()) {
            @Override
            public Page<VirtualRouterInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualRouterInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualRouterInner>> serviceFuture, final ListOperationCallback<VirtualRouterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<Page<VirtualRouterInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Page<VirtualRouterInner>>() {
                @Override
                public Page<VirtualRouterInner> call(ServiceResponse<Page<VirtualRouterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualRouterInner>>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(ServiceResponse<Page<VirtualRouterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the Virtual Routers in a subscription.
     *
    ServiceResponse<PageImpl<VirtualRouterInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualRouterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualRouterInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualRouterInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualRouterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualRouterInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualRouterInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualRouterInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

}
