/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.VirtualNetworkGateway;
import com.microsoft.azure.management.network.VirtualNetworkGatewayIPConfiguration;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

@LangDefinition
class VirtualNetworkGatewayIPConfigurationImpl
extends ChildResourceImpl<VirtualNetworkGatewayIPConfigurationInner, VirtualNetworkGatewayImpl, VirtualNetworkGateway>
implements VirtualNetworkGatewayIPConfiguration,
VirtualNetworkGatewayIPConfiguration.Definition<VirtualNetworkGateway.DefinitionStages.WithCreate>,
VirtualNetworkGatewayIPConfiguration.UpdateDefinition<VirtualNetworkGateway.Update>,
VirtualNetworkGatewayIPConfiguration.Update {
    VirtualNetworkGatewayIPConfigurationImpl(VirtualNetworkGatewayIPConfigurationInner inner, VirtualNetworkGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).name();
    }

    @Override
    public String publicIPAddressId() {
        if (((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).publicIPAddress() != null) {
            return ((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).publicIPAddress().id();
        }
        return null;
    }

    @Override
    public String networkId() {
        SubResource subnetRef = ((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String subnetName() {
        SubResource subnetRef = ((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public IPAllocationMethod privateIPAllocationMethod() {
        return ((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).privateIPAllocationMethod();
    }

    @Override
    public Subnet getSubnet() {
        return ((NetworkManager)((VirtualNetworkGatewayImpl)this.parent()).manager()).getAssociatedSubnet(((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).subnet());
    }

    public VirtualNetworkGatewayIPConfigurationImpl withExistingSubnet(String networkId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(networkId + "/subnets/" + subnetName);
        ((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).withSubnet(subnetRef);
        return this;
    }

    public VirtualNetworkGatewayIPConfigurationImpl withExistingSubnet(Subnet subnet) {
        return this.withExistingSubnet(((Network)subnet.parent()).id(), subnet.name());
    }

    public VirtualNetworkGatewayIPConfigurationImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public VirtualNetworkGatewayImpl attach() {
        return ((VirtualNetworkGatewayImpl)this.parent()).withConfig(this);
    }

    @Override
    public VirtualNetworkGatewayIPConfigurationImpl withExistingPublicIPAddress(PublicIPAddress pip) {
        return this.withExistingPublicIPAddress(pip.id());
    }

    @Override
    public VirtualNetworkGatewayIPConfigurationImpl withExistingPublicIPAddress(String resourceId) {
        SubResource pipRef = new SubResource().withId(resourceId);
        ((VirtualNetworkGatewayIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(pipRef);
        return this;
    }
}

