/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayProbe;
import com.microsoft.azure.management.network.ApplicationGatewayProbeHealthResponseMatch;
import com.microsoft.azure.management.network.ApplicationGatewayProtocol;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayProbeInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@LangDefinition
class ApplicationGatewayProbeImpl
extends ChildResourceImpl<ApplicationGatewayProbeInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayProbe,
ApplicationGatewayProbe.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayProbe.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayProbe.Update {
    ApplicationGatewayProbeImpl(ApplicationGatewayProbeInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ApplicationGatewayProbeInner)((Object)this.inner())).name();
    }

    @Override
    public String healthyHttpResponseBodyContents() {
        ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)((Object)this.inner())).match();
        if (match == null) {
            return null;
        }
        return match.body();
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayProbeInner)((Object)this.inner())).protocol();
    }

    @Override
    public int timeBetweenProbesInSeconds() {
        return ((ApplicationGatewayProbeInner)((Object)this.inner())).interval() != null ? ((ApplicationGatewayProbeInner)((Object)this.inner())).interval() : 0;
    }

    @Override
    public String path() {
        return ((ApplicationGatewayProbeInner)((Object)this.inner())).path();
    }

    @Override
    public Set<String> healthyHttpResponseStatusCodeRanges() {
        TreeSet<String> httpResponseStatusCodeRanges = new TreeSet<String>();
        if (((ApplicationGatewayProbeInner)((Object)this.inner())).match() != null && ((ApplicationGatewayProbeInner)((Object)this.inner())).match().statusCodes() != null) {
            httpResponseStatusCodeRanges.addAll(((ApplicationGatewayProbeInner)((Object)this.inner())).match().statusCodes());
        }
        return Collections.unmodifiableSet(httpResponseStatusCodeRanges);
    }

    @Override
    public int timeoutInSeconds() {
        return ((ApplicationGatewayProbeInner)((Object)this.inner())).timeout() != null ? ((ApplicationGatewayProbeInner)((Object)this.inner())).timeout() : 0;
    }

    @Override
    public int retriesBeforeUnhealthy() {
        return ((ApplicationGatewayProbeInner)((Object)this.inner())).unhealthyThreshold() != null ? ((ApplicationGatewayProbeInner)((Object)this.inner())).unhealthyThreshold() : 0;
    }

    @Override
    public String host() {
        return ((ApplicationGatewayProbeInner)((Object)this.inner())).host();
    }

    @Override
    public ApplicationGatewayProbeImpl withProtocol(ApplicationGatewayProtocol protocol) {
        ((ApplicationGatewayProbeInner)((Object)this.inner())).withProtocol(protocol);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHttp() {
        return this.withProtocol(ApplicationGatewayProtocol.HTTP);
    }

    @Override
    public ApplicationGatewayProbeImpl withHttps() {
        return this.withProtocol(ApplicationGatewayProtocol.HTTPS);
    }

    @Override
    public ApplicationGatewayProbeImpl withPath(String path) {
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        ((ApplicationGatewayProbeInner)((Object)this.inner())).withPath(path);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHost(String host) {
        ((ApplicationGatewayProbeInner)((Object)this.inner())).withHost(host);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withTimeoutInSeconds(int seconds) {
        ((ApplicationGatewayProbeInner)((Object)this.inner())).withTimeout(seconds);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withTimeBetweenProbesInSeconds(int seconds) {
        ((ApplicationGatewayProbeInner)((Object)this.inner())).withInterval(seconds);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withRetriesBeforeUnhealthy(int retryCount) {
        ((ApplicationGatewayProbeInner)((Object)this.inner())).withUnhealthyThreshold(retryCount);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseStatusCodeRanges(Set<String> ranges) {
        if (ranges != null) {
            for (String range : ranges) {
                this.withHealthyHttpResponseStatusCodeRange(range);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseStatusCodeRange(String range) {
        if (range != null) {
            List<String> ranges;
            ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)((Object)this.inner())).match();
            if (match == null) {
                match = new ApplicationGatewayProbeHealthResponseMatch();
                ((ApplicationGatewayProbeInner)((Object)this.inner())).withMatch(match);
            }
            if ((ranges = match.statusCodes()) == null) {
                ranges = new ArrayList<String>();
                match.withStatusCodes(ranges);
            }
            if (!ranges.contains(range)) {
                ranges.add(range);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseStatusCodeRange(int from, int to) {
        if (from < 0 || to < 0) {
            throw new IllegalArgumentException("The start and end of a range cannot be negative numbers.");
        }
        if (to < from) {
            throw new IllegalArgumentException("The end of the range cannot be less than the start of the range.");
        }
        return this.withHealthyHttpResponseStatusCodeRange(String.valueOf(from) + "-" + String.valueOf(to));
    }

    @Override
    public ApplicationGatewayProbeImpl withoutHealthyHttpResponseStatusCodeRanges() {
        ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)((Object)this.inner())).match();
        if (match != null) {
            match.withStatusCodes(null);
            if (match.body() == null) {
                ((ApplicationGatewayProbeInner)((Object)this.inner())).withMatch(null);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseBodyContents(String text) {
        ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)((Object)this.inner())).match();
        if (text != null) {
            if (match == null) {
                match = new ApplicationGatewayProbeHealthResponseMatch();
                ((ApplicationGatewayProbeInner)((Object)this.inner())).withMatch(match);
            }
            match.withBody(text);
        } else if (match != null) {
            if (match.statusCodes() == null || match.statusCodes().isEmpty()) {
                ((ApplicationGatewayProbeInner)((Object)this.inner())).withMatch(null);
            } else {
                match.withBody(null);
            }
        }
        return this;
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withProbe(this);
    }
}

