/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.ServiceAssociationLinksListResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServiceAssociationLinksInner {
    private ServiceAssociationLinksService service;
    private NetworkManagementClientImpl client;

    public ServiceAssociationLinksInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ServiceAssociationLinksService)retrofit.create(ServiceAssociationLinksService.class);
        this.client = client;
    }

    public ServiceAssociationLinksListResultInner list(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return (ServiceAssociationLinksListResultInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).toBlocking().single()).body();
    }

    public ServiceFuture<ServiceAssociationLinksListResultInner> listAsync(String resourceGroupName, String virtualNetworkName, String subnetName, ServiceCallback<ServiceAssociationLinksListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName), serviceCallback);
    }

    public Observable<ServiceAssociationLinksListResultInner> listAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return this.listWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).map((Func1)new Func1<ServiceResponse<ServiceAssociationLinksListResultInner>, ServiceAssociationLinksListResultInner>(){

            public ServiceAssociationLinksListResultInner call(ServiceResponse<ServiceAssociationLinksListResultInner> response) {
                return (ServiceAssociationLinksListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServiceAssociationLinksListResultInner>> listWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceAssociationLinksListResultInner>>>(){

            public Observable<ServiceResponse<ServiceAssociationLinksListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceAssociationLinksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceAssociationLinksListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceAssociationLinksListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServiceAssociationLinksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceAssociationLinks list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}/ServiceAssociationLinks")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

