/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters that define the operation to create a connection monitor.
 */
public class ConnectionMonitorParameters {
    /**
     * Describes the source of connection monitor.
     */
    @JsonProperty(value = "source")
    private ConnectionMonitorSource source;

    /**
     * Describes the destination of connection monitor.
     */
    @JsonProperty(value = "destination")
    private ConnectionMonitorDestination destination;

    /**
     * Determines if the connection monitor will start automatically once
     * created.
     */
    @JsonProperty(value = "autoStart")
    private Boolean autoStart;

    /**
     * Monitoring interval in seconds.
     */
    @JsonProperty(value = "monitoringIntervalInSeconds")
    private Integer monitoringIntervalInSeconds;

    /**
     * List of connection monitor endpoints.
     */
    @JsonProperty(value = "endpoints")
    private List<ConnectionMonitorEndpoint> endpoints;

    /**
     * List of connection monitor test configurations.
     */
    @JsonProperty(value = "testConfigurations")
    private List<ConnectionMonitorTestConfiguration> testConfigurations;

    /**
     * List of connection monitor test groups.
     */
    @JsonProperty(value = "testGroups")
    private List<ConnectionMonitorTestGroup> testGroups;

    /**
     * List of connection monitor outputs.
     */
    @JsonProperty(value = "outputs")
    private List<ConnectionMonitorOutput> outputs;

    /**
     * Optional notes to be associated with the connection monitor.
     */
    @JsonProperty(value = "notes")
    private String notes;

    /**
     * Get describes the source of connection monitor.
     *
     * @return the source value
     */
    public ConnectionMonitorSource source() {
        return this.source;
    }

    /**
     * Set describes the source of connection monitor.
     *
     * @param source the source value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withSource(ConnectionMonitorSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get describes the destination of connection monitor.
     *
     * @return the destination value
     */
    public ConnectionMonitorDestination destination() {
        return this.destination;
    }

    /**
     * Set describes the destination of connection monitor.
     *
     * @param destination the destination value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withDestination(ConnectionMonitorDestination destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get determines if the connection monitor will start automatically once created.
     *
     * @return the autoStart value
     */
    public Boolean autoStart() {
        return this.autoStart;
    }

    /**
     * Set determines if the connection monitor will start automatically once created.
     *
     * @param autoStart the autoStart value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withAutoStart(Boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    /**
     * Get monitoring interval in seconds.
     *
     * @return the monitoringIntervalInSeconds value
     */
    public Integer monitoringIntervalInSeconds() {
        return this.monitoringIntervalInSeconds;
    }

    /**
     * Set monitoring interval in seconds.
     *
     * @param monitoringIntervalInSeconds the monitoringIntervalInSeconds value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        this.monitoringIntervalInSeconds = monitoringIntervalInSeconds;
        return this;
    }

    /**
     * Get list of connection monitor endpoints.
     *
     * @return the endpoints value
     */
    public List<ConnectionMonitorEndpoint> endpoints() {
        return this.endpoints;
    }

    /**
     * Set list of connection monitor endpoints.
     *
     * @param endpoints the endpoints value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    /**
     * Get list of connection monitor test configurations.
     *
     * @return the testConfigurations value
     */
    public List<ConnectionMonitorTestConfiguration> testConfigurations() {
        return this.testConfigurations;
    }

    /**
     * Set list of connection monitor test configurations.
     *
     * @param testConfigurations the testConfigurations value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withTestConfigurations(List<ConnectionMonitorTestConfiguration> testConfigurations) {
        this.testConfigurations = testConfigurations;
        return this;
    }

    /**
     * Get list of connection monitor test groups.
     *
     * @return the testGroups value
     */
    public List<ConnectionMonitorTestGroup> testGroups() {
        return this.testGroups;
    }

    /**
     * Set list of connection monitor test groups.
     *
     * @param testGroups the testGroups value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        this.testGroups = testGroups;
        return this;
    }

    /**
     * Get list of connection monitor outputs.
     *
     * @return the outputs value
     */
    public List<ConnectionMonitorOutput> outputs() {
        return this.outputs;
    }

    /**
     * Set list of connection monitor outputs.
     *
     * @param outputs the outputs value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withOutputs(List<ConnectionMonitorOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    /**
     * Get optional notes to be associated with the connection monitor.
     *
     * @return the notes value
     */
    public String notes() {
        return this.notes;
    }

    /**
     * Set optional notes to be associated with the connection monitor.
     *
     * @param notes the notes value to set
     * @return the ConnectionMonitorParameters object itself.
     */
    public ConnectionMonitorParameters withNotes(String notes) {
        this.notes = notes;
        return this;
    }

}
