/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 */
public class ManagedRulesDefinition {
    /**
     * The Exclusions that are applied on the policy.
     */
    @JsonProperty(value = "exclusions")
    private List<OwaspCrsExclusionEntry> exclusions;

    /**
     * The managed rule sets that are associated with the policy.
     */
    @JsonProperty(value = "managedRuleSets", required = true)
    private List<ManagedRuleSet> managedRuleSets;

    /**
     * Get the Exclusions that are applied on the policy.
     *
     * @return the exclusions value
     */
    public List<OwaspCrsExclusionEntry> exclusions() {
        return this.exclusions;
    }

    /**
     * Set the Exclusions that are applied on the policy.
     *
     * @param exclusions the exclusions value to set
     * @return the ManagedRulesDefinition object itself.
     */
    public ManagedRulesDefinition withExclusions(List<OwaspCrsExclusionEntry> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    /**
     * Get the managed rule sets that are associated with the policy.
     *
     * @return the managedRuleSets value
     */
    public List<ManagedRuleSet> managedRuleSets() {
        return this.managedRuleSets;
    }

    /**
     * Set the managed rule sets that are associated with the policy.
     *
     * @param managedRuleSets the managedRuleSets value to set
     * @return the ManagedRulesDefinition object itself.
     */
    public ManagedRulesDefinition withManagedRuleSets(List<ManagedRuleSet> managedRuleSets) {
        this.managedRuleSets = managedRuleSets;
        return this;
    }

}
