/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.network.VM;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Bastion Shareable Link.
 */
public class BastionShareableLinkInner {
    /**
     * Reference of the virtual machine resource.
     */
    @JsonProperty(value = "vm", required = true)
    private VM vm;

    /**
     * The unique Bastion Shareable Link to the virtual machine.
     */
    @JsonProperty(value = "bsl", access = JsonProperty.Access.WRITE_ONLY)
    private String bsl;

    /**
     * The time when the link was created.
     */
    @JsonProperty(value = "createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private String createdAt;

    /**
     * Optional field indicating the warning or error message related to the vm
     * in case of partial failure.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /**
     * Get reference of the virtual machine resource.
     *
     * @return the vm value
     */
    public VM vm() {
        return this.vm;
    }

    /**
     * Set reference of the virtual machine resource.
     *
     * @param vm the vm value to set
     * @return the BastionShareableLinkInner object itself.
     */
    public BastionShareableLinkInner withVm(VM vm) {
        this.vm = vm;
        return this;
    }

    /**
     * Get the unique Bastion Shareable Link to the virtual machine.
     *
     * @return the bsl value
     */
    public String bsl() {
        return this.bsl;
    }

    /**
     * Get the time when the link was created.
     *
     * @return the createdAt value
     */
    public String createdAt() {
        return this.createdAt;
    }

    /**
     * Get optional field indicating the warning or error message related to the vm in case of partial failure.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

}
