/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in FirewallPolicyRuleGroups.
 */
public class FirewallPolicyRuleGroupsInner {
    /** The Retrofit service to perform REST calls. */
    private FirewallPolicyRuleGroupsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of FirewallPolicyRuleGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public FirewallPolicyRuleGroupsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(FirewallPolicyRuleGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for FirewallPolicyRuleGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface FirewallPolicyRuleGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("firewallPolicyName") String firewallPolicyName, @Path("ruleGroupName") String ruleGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("firewallPolicyName") String firewallPolicyName, @Path("ruleGroupName") String ruleGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("firewallPolicyName") String firewallPolicyName, @Path("ruleGroupName") String ruleGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("firewallPolicyName") String firewallPolicyName, @Path("ruleGroupName") String ruleGroupName, @Path("subscriptionId") String subscriptionId, @Body FirewallPolicyRuleGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("firewallPolicyName") String firewallPolicyName, @Path("ruleGroupName") String ruleGroupName, @Path("subscriptionId") String subscriptionId, @Body FirewallPolicyRuleGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("firewallPolicyName") String firewallPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).toBlocking().last().body();
    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName), serviceCallback);
    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).toBlocking().single().body();
    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName), serviceCallback);
    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FirewallPolicyRuleGroupInner object if successful.
     */
    public FirewallPolicyRuleGroupInner get(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).toBlocking().single().body();
    }

    /**
     * Gets the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FirewallPolicyRuleGroupInner> getAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, final ServiceCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName), serviceCallback);
    }

    /**
     * Gets the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FirewallPolicyRuleGroupInner object
     */
    public Observable<FirewallPolicyRuleGroupInner> getAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).map(new Func1<ServiceResponse<FirewallPolicyRuleGroupInner>, FirewallPolicyRuleGroupInner>() {
            @Override
            public FirewallPolicyRuleGroupInner call(ServiceResponse<FirewallPolicyRuleGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FirewallPolicyRuleGroupInner object
     */
    public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.get(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallPolicyRuleGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FirewallPolicyRuleGroupInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FirewallPolicyRuleGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FirewallPolicyRuleGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FirewallPolicyRuleGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FirewallPolicyRuleGroupInner object if successful.
     */
    public FirewallPolicyRuleGroupInner createOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FirewallPolicyRuleGroupInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters, final ServiceCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<FirewallPolicyRuleGroupInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).map(new Func1<ServiceResponse<FirewallPolicyRuleGroupInner>, FirewallPolicyRuleGroupInner>() {
            @Override
            public FirewallPolicyRuleGroupInner call(ServiceResponse<FirewallPolicyRuleGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FirewallPolicyRuleGroupInner>() { }.getType());
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FirewallPolicyRuleGroupInner object if successful.
     */
    public FirewallPolicyRuleGroupInner beginCreateOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FirewallPolicyRuleGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters, final ServiceCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FirewallPolicyRuleGroupInner object
     */
    public Observable<FirewallPolicyRuleGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).map(new Func1<ServiceResponse<FirewallPolicyRuleGroupInner>, FirewallPolicyRuleGroupInner>() {
            @Override
            public FirewallPolicyRuleGroupInner call(ServiceResponse<FirewallPolicyRuleGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified FirewallPolicyRuleGroup.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param ruleGroupName The name of the FirewallPolicyRuleGroup.
     * @param parameters Parameters supplied to the create or update FirewallPolicyRuleGroup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FirewallPolicyRuleGroupInner object
     */
    public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallPolicyRuleGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FirewallPolicyRuleGroupInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FirewallPolicyRuleGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FirewallPolicyRuleGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FirewallPolicyRuleGroupInner>() { }.getType())
                .register(201, new TypeToken<FirewallPolicyRuleGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object if successful.
     */
    public PagedList<FirewallPolicyRuleGroupInner> list(final String resourceGroupName, final String firewallPolicyName) {
        ServiceResponse<Page<FirewallPolicyRuleGroupInner>> response = listSinglePageAsync(resourceGroupName, firewallPolicyName).toBlocking().single();
        return new PagedList<FirewallPolicyRuleGroupInner>(response.body()) {
            @Override
            public Page<FirewallPolicyRuleGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FirewallPolicyRuleGroupInner>> listAsync(final String resourceGroupName, final String firewallPolicyName, final ListOperationCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, firewallPolicyName),
            new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object
     */
    public Observable<Page<FirewallPolicyRuleGroupInner>> listAsync(final String resourceGroupName, final String firewallPolicyName) {
        return listWithServiceResponseAsync(resourceGroupName, firewallPolicyName)
            .map(new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Page<FirewallPolicyRuleGroupInner>>() {
                @Override
                public Page<FirewallPolicyRuleGroupInner> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param firewallPolicyName The name of the Firewall Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String firewallPolicyName) {
        return listSinglePageAsync(resourceGroupName, firewallPolicyName)
            .concatMap(new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
    ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> * @param firewallPolicyName The name of the Firewall Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listSinglePageAsync(final String resourceGroupName, final String firewallPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FirewallPolicyRuleGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FirewallPolicyRuleGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FirewallPolicyRuleGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object if successful.
     */
    public PagedList<FirewallPolicyRuleGroupInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<FirewallPolicyRuleGroupInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FirewallPolicyRuleGroupInner>(response.body()) {
            @Override
            public Page<FirewallPolicyRuleGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FirewallPolicyRuleGroupInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<FirewallPolicyRuleGroupInner>> serviceFuture, final ListOperationCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object
     */
    public Observable<Page<FirewallPolicyRuleGroupInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Page<FirewallPolicyRuleGroupInner>>() {
                @Override
                public Page<FirewallPolicyRuleGroupInner> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all FirewallPolicyRuleGroups in a FirewallPolicy resource.
     *
    ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FirewallPolicyRuleGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FirewallPolicyRuleGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FirewallPolicyRuleGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FirewallPolicyRuleGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
