/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PublicIPPrefixInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PublicIPPrefixesInner
implements InnerSupportsGet<PublicIPPrefixInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<PublicIPPrefixInner> {
    private PublicIPPrefixesService service;
    private NetworkManagementClientImpl client;

    public PublicIPPrefixesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (PublicIPPrefixesService)retrofit.create(PublicIPPrefixesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String publicIpPrefixName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String publicIpPrefixName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String publicIpPrefixName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String publicIpPrefixName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String publicIpPrefixName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String publicIpPrefixName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPPrefixesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPPrefixInner getByResourceGroup(String resourceGroupName, String publicIpPrefixName) {
        return (PublicIPPrefixInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName, ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    public Observable<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map((Func1)new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>(){

            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return (PublicIPPrefixInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPPrefixInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>(){

            public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPPrefixesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PublicIPPrefixInner getByResourceGroup(String resourceGroupName, String publicIpPrefixName, String expand) {
        return (PublicIPPrefixInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName, String expand, ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, expand), serviceCallback);
    }

    public Observable<PublicIPPrefixInner> getByResourceGroupAsync(String resourceGroupName, String publicIpPrefixName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, expand).map((Func1)new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>(){

            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return (PublicIPPrefixInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPPrefixInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>(){

            public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPPrefixesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPPrefixInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PublicIPPrefixInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPPrefixInner createOrUpdate(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return (PublicIPPrefixInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<PublicIPPrefixInner> createOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters, ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters), serviceCallback);
    }

    public Observable<PublicIPPrefixInner> createOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).map((Func1)new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>(){

            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return (PublicIPPrefixInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPPrefixInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PublicIPPrefixInner>(){}.getType());
    }

    public PublicIPPrefixInner beginCreateOrUpdate(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return (PublicIPPrefixInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPPrefixInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters, ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters), serviceCallback);
    }

    public Observable<PublicIPPrefixInner> beginCreateOrUpdateAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, parameters).map((Func1)new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>(){

            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return (PublicIPPrefixInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPPrefixInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, PublicIPPrefixInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>(){

            public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPPrefixesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPPrefixInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PublicIPPrefixInner>(){}.getType()).register(201, new TypeToken<PublicIPPrefixInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PublicIPPrefixInner updateTags(String resourceGroupName, String publicIpPrefixName) {
        return (PublicIPPrefixInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName, ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName), serviceCallback);
    }

    public Observable<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName).map((Func1)new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>(){

            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return (PublicIPPrefixInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPPrefixInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.updateTags(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>(){

            public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPPrefixesInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PublicIPPrefixInner updateTags(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        return (PublicIPPrefixInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags, ServiceCallback<PublicIPPrefixInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags), serviceCallback);
    }

    public Observable<PublicIPPrefixInner> updateTagsAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, publicIpPrefixName, tags).map((Func1)new Func1<ServiceResponse<PublicIPPrefixInner>, PublicIPPrefixInner>(){

            public PublicIPPrefixInner call(ServiceResponse<PublicIPPrefixInner> response) {
                return (PublicIPPrefixInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PublicIPPrefixInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String publicIpPrefixName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (publicIpPrefixName == null) {
            throw new IllegalArgumentException("Parameter publicIpPrefixName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.updateTags(resourceGroupName, publicIpPrefixName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PublicIPPrefixInner>>>(){

            public Observable<ServiceResponse<PublicIPPrefixInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PublicIPPrefixesInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PublicIPPrefixInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PublicIPPrefixInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPPrefixInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<PublicIPPrefixInner>((Page)response.body()){

            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPPrefixesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPPrefixInner>> listAsync(ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                return PublicIPPrefixesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPPrefixInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>(){

            public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPPrefixesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPPrefixesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPPrefixInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PublicIPPrefixInner>((Page)response.body()){

            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPPrefixesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPPrefixInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                return PublicIPPrefixesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPPrefixInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>(){

            public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPPrefixesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPPrefixesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPPrefixInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPPrefixInner>((Page)response.body()){

            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPPrefixesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPPrefixInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PublicIPPrefixInner>> serviceFuture, ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                return PublicIPPrefixesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPPrefixInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>(){

            public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPPrefixesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPPrefixesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PublicIPPrefixInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PublicIPPrefixInner>((Page)response.body()){

            public Page<PublicIPPrefixInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PublicIPPrefixesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PublicIPPrefixInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<PublicIPPrefixInner>> serviceFuture, ListOperationCallback<PublicIPPrefixInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(String nextPageLink) {
                return PublicIPPrefixesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PublicIPPrefixInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Page<PublicIPPrefixInner>>(){

            public Page<PublicIPPrefixInner> call(ServiceResponse<Page<PublicIPPrefixInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PublicIPPrefixInner>>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(ServiceResponse<Page<PublicIPPrefixInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PublicIPPrefixesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PublicIPPrefixInner>>>>(){

            public Observable<ServiceResponse<Page<PublicIPPrefixInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PublicIPPrefixesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PublicIPPrefixInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PublicIPPrefixInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PublicIPPrefixesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="publicIpPrefixName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="publicIpPrefixName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="publicIpPrefixName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="publicIpPrefixName") String var2, @Path(value="subscriptionId") String var3, @Body PublicIPPrefixInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="publicIpPrefixName") String var2, @Path(value="subscriptionId") String var3, @Body PublicIPPrefixInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="publicIpPrefixName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/publicIPPrefixes")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PublicIPPrefixes listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

