/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.LoadBalancerInboundNatRule;
import com.microsoft.azure.management.network.LoadBalancerPrivateFrontend;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.FrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.PublicIPAddressInner;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@LangDefinition
class LoadBalancerFrontendImpl
extends ChildResourceImpl<FrontendIPConfigurationInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerFrontend,
LoadBalancerPrivateFrontend,
LoadBalancerPrivateFrontend.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerPrivateFrontend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerPrivateFrontend.Update,
LoadBalancerPublicFrontend,
LoadBalancerPublicFrontend.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerPublicFrontend.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerPublicFrontend.Update {
    LoadBalancerFrontendImpl(FrontendIPConfigurationInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        SubnetInner subnetRef = ((FrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    public String subnetName() {
        SubnetInner subnetRef = ((FrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String privateIPAddress() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).privateIPAddress();
    }

    @Override
    public IPAllocationMethod privateIPAllocationMethod() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).privateIPAllocationMethod();
    }

    public String name() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).name();
    }

    @Override
    public String publicIPAddressId() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress().id();
    }

    @Override
    public boolean isPublic() {
        return ((FrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress() != null;
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).loadBalancingRules() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> inboundNatPools() {
        TreeMap<String, LoadBalancerInboundNatPool> pools = new TreeMap<String, LoadBalancerInboundNatPool>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatPools() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatPools()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancerInboundNatPool pool = ((LoadBalancerImpl)this.parent()).inboundNatPools().get(name);
                if (pool == null) continue;
                pools.put(name, pool);
            }
        }
        return Collections.unmodifiableMap(pools);
    }

    @Override
    public Map<String, LoadBalancerInboundNatRule> inboundNatRules() {
        TreeMap<String, LoadBalancerInboundNatRule> rules = new TreeMap<String, LoadBalancerInboundNatRule>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatRules() != null) {
            for (SubResource innerRef : ((FrontendIPConfigurationInner)((Object)this.inner())).inboundNatRules()) {
                String name = ResourceUtils.nameFromResourceId((String)innerRef.id());
                LoadBalancerInboundNatRule rule = ((LoadBalancerImpl)this.parent()).inboundNatRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public LoadBalancerFrontendImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public LoadBalancerFrontendImpl withExistingSubnet(String parentNetworkResourceId, String subnetName) {
        SubnetInner subnetRef = (SubnetInner)new SubnetInner().withId(parentNetworkResourceId + "/subnets/" + subnetName);
        ((FrontendIPConfigurationInner)((Object)this.inner())).withSubnet(subnetRef).withPublicIPAddress(null);
        return this;
    }

    public LoadBalancerFrontendImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((FrontendIPConfigurationInner)((Object)this.inner())).zones() == null) {
            ((FrontendIPConfigurationInner)((Object)this.inner())).withZones(new ArrayList<String>());
        }
        ((FrontendIPConfigurationInner)((Object)this.inner())).zones().add(zoneId.toString());
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withExistingPublicIPAddress(PublicIPAddress pip) {
        return this.withExistingPublicIPAddress(pip.id());
    }

    @Override
    public LoadBalancerFrontendImpl withExistingPublicIPAddress(String resourceId) {
        PublicIPAddressInner pipRef = new PublicIPAddressInner().withId(resourceId);
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(pipRef).withSubnet(null).withPrivateIPAddress(null).withPrivateIPAllocationMethod(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withoutPublicIPAddress() {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withPrivateIPAddressDynamic() {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(null).withPrivateIPAllocationMethod(IPAllocationMethod.DYNAMIC).withPublicIPAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withPrivateIPAddressStatic(String ipAddress) {
        ((FrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(ipAddress).withPrivateIPAllocationMethod(IPAllocationMethod.STATIC).withPublicIPAddress(null);
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withNewPublicIPAddress(String leafDnsLabel) {
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, this.name());
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withNewPublicIPAddress(Creatable<PublicIPAddress> creatable) {
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(creatable, this.name());
        return this;
    }

    @Override
    public LoadBalancerFrontendImpl withNewPublicIPAddress() {
        String dnsLabel = SdkContext.randomResourceName((String)"fe", (int)20);
        return this.withNewPublicIPAddress(dnsLabel);
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withFrontend(this);
    }

    @Override
    public PublicIPAddress getPublicIPAddress() {
        String pipId = this.publicIPAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIPAddress)((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).publicIPAddresses().getById(pipId);
    }

    @Override
    public Subnet getSubnet() {
        return ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).getAssociatedSubnet(((FrontendIPConfigurationInner)((Object)this.inner())).subnet());
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((FrontendIPConfigurationInner)((Object)this.inner())).zones() != null) {
            for (String zone : ((FrontendIPConfigurationInner)((Object)this.inner())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }
}

